/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Iterator;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Function;

public class Communication
extends Function
implements Serializable {
    public static final String NAME = "Communication";

    public Communication(Building building) {
        super(NAME, building);
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = 1.0;
        double supply = 0.0;
        Iterator<Building> i = settlement.getBuildingManager().getBuildings(NAME).iterator();
        while (i.hasNext()) {
            supply += i.next().getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
        }
        if (!newBuilding && (supply -= 1.0) < 0.0) {
            supply = 0.0;
        }
        return demand / (supply + 1.0);
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }
}

