/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.task.CookMeal;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.CookedMeal;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.time.MarsClock;

public class Cooking
extends Function
implements Serializable {
    private static Logger logger = Logger.getLogger(Cooking.class.getName());
    public static final String NAME = "Cooking";
    public static final double COOKED_MEAL_WORK_REQUIRED = 20.0;
    private int cookCapacity;
    private List<CookedMeal> meals = new ArrayList<CookedMeal>();
    private double cookingWorkTime = 0.0;

    public Cooking(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.cookCapacity = config.getCookCapacity(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = (double)settlement.getAllAssociatedPeople().size() / 5.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            Cooking cookingFunction = (Cooking)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)cookingFunction.cookCapacity * wearModifier;
        }
        double cookingCapacityValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double cookingCapacity = config.getCookCapacity(buildingName);
        return cookingCapacity * cookingCapacityValue;
    }

    public int getCookCapacity() {
        return this.cookCapacity;
    }

    public int getNumCooks() {
        int result = 0;
        if (this.getBuilding().hasFunction("Life Support")) {
            try {
                LifeSupport lifeSupport = (LifeSupport)this.getBuilding().getFunction("Life Support");
                Iterator<Person> i = lifeSupport.getOccupants().iterator();
                while (i.hasNext()) {
                    Task task = i.next().getMind().getTaskManager().getTask();
                    if (!(task instanceof CookMeal)) continue;
                    ++result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public int getBestCookSkill() {
        int result = 0;
        if (this.getBuilding().hasFunction("Life Support")) {
            try {
                LifeSupport lifeSupport = (LifeSupport)this.getBuilding().getFunction("Life Support");
                for (Person person : lifeSupport.getOccupants()) {
                    int cookingSkill;
                    Task task = person.getMind().getTaskManager().getTask();
                    if (!(task instanceof CookMeal) || (cookingSkill = person.getMind().getSkillManager().getEffectiveSkillLevel(NAME)) <= result) continue;
                    result = cookingSkill;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean hasCookedMeal() {
        return this.meals.size() > 0;
    }

    public int getNumberOfCookedMeals() {
        return this.meals.size();
    }

    public CookedMeal getCookedMeal() {
        CookedMeal bestMeal = null;
        int bestQuality = -1;
        for (CookedMeal meal : this.meals) {
            if (meal.getQuality() <= bestQuality) continue;
            bestQuality = meal.getQuality();
            bestMeal = meal;
        }
        if (bestMeal != null) {
            this.meals.remove(bestMeal);
        }
        return bestMeal;
    }

    public int getBestMealQuality() {
        int bestQuality = 0;
        for (CookedMeal meal : this.meals) {
            if (meal.getQuality() <= bestQuality) continue;
            bestQuality = meal.getQuality();
        }
        return bestQuality;
    }

    public void cleanup() {
        this.cookingWorkTime = 0.0;
    }

    public void addWork(double workTime) {
        this.cookingWorkTime += workTime;
        while (this.cookingWorkTime >= 20.0) {
            int mealQuality = this.getBestCookSkill();
            MarsClock time = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
            PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
            double foodAmount = config.getFoodConsumptionRate() * 0.3333333333333333;
            AmountResource food = AmountResource.findAmountResource("food");
            double foodAvailable = this.getBuilding().getInventory().getAmountResourceStored(food, false);
            if (foodAmount <= foodAvailable) {
                this.getBuilding().getInventory().retrieveAmountResource(food, foodAmount);
                this.meals.add(new CookedMeal(mealQuality, time));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(this.getBuilding().getBuildingManager().getSettlement().getName() + " has " + this.meals.size() + " hot meals, quality=" + mealQuality);
                }
            } else {
                Settlement settlement = this.getBuilding().getBuildingManager().getSettlement();
                logger.info("Not enough food to cook meal at " + settlement.getName() + " - food available: " + foodAvailable);
            }
            this.cookingWorkTime -= 20.0;
        }
    }

    @Override
    public void timePassing(double time) {
        Iterator<CookedMeal> i = this.meals.iterator();
        while (i.hasNext()) {
            CookedMeal meal = i.next();
            MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
            if (!(MarsClock.getTimeDiff(meal.getExpirationTime(), currentTime) < 0.0)) continue;
            try {
                PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
                AmountResource food = AmountResource.findAmountResource("food");
                double foodAmount = config.getFoodConsumptionRate() * 0.3333333333333333;
                double foodCapacity = this.getBuilding().getInventory().getAmountResourceRemainingCapacity(food, false, false);
                if (foodAmount > foodCapacity) {
                    foodAmount = foodCapacity;
                }
                this.getBuilding().getInventory().storeAmountResource(food, foodAmount, false);
                i.remove();
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Cooked meal expiring at " + this.getBuilding().getBuildingManager().getSettlement().getName());
            }
            catch (Exception e) {}
        }
    }

    @Override
    public double getFullPowerRequired() {
        return (double)this.getNumCooks() * 10.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.meals.clear();
        this.meals = null;
    }
}

