/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class Dining
extends Function
implements Serializable {
    public static final String NAME = "Dining";
    private int capacity;

    public Dining(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.capacity = config.getDiningCapacity(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        BuildingConfig config;
        double capacity;
        double demand = settlement.getAllAssociatedPeople().size();
        double supply = 0.0;
        for (Building diningBuilding : settlement.getBuildingManager().getBuildings(NAME)) {
            Dining dining = (Dining)diningBuilding.getFunction(NAME);
            double capacity2 = dining.getDiningCapacity();
            double wearFactor = diningBuilding.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += capacity2 * wearFactor;
        }
        if (!newBuilding && (supply -= (capacity = (double)(config = SimulationConfig.instance().getBuildingConfiguration()).getDiningCapacity(buildingName))) < 0.0) {
            supply = 0.0;
        }
        return demand / (supply + 1.0);
    }

    public int getDiningCapacity() {
        return this.capacity;
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }
}

