/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class EarthReturn
extends Function
implements Serializable {
    public static final String NAME = "Earth Return";
    private int crewCapacity;
    private boolean hasLaunched;

    public EarthReturn(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.crewCapacity = config.getEarthReturnCrewCapacity(building.getName());
        this.hasLaunched = false;
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        BuildingConfig config;
        double demand = settlement.getAllAssociatedPeople().size();
        double supply = 0.0;
        for (Building earthReturnBuilding : settlement.getBuildingManager().getBuildings(NAME)) {
            EarthReturn earthReturn = (EarthReturn)earthReturnBuilding.getFunction(NAME);
            double crewCapacity = earthReturn.getCrewCapacity();
            double wearFactor = earthReturnBuilding.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += crewCapacity * wearFactor;
        }
        if (!newBuilding && (supply -= (double)(config = SimulationConfig.instance().getBuildingConfiguration()).getEarthReturnCrewCapacity(buildingName)) < 0.0) {
            supply = 0.0;
        }
        return demand / (supply + 1.0);
    }

    public int getCrewCapacity() {
        return this.crewCapacity;
    }

    public boolean hasLaunched() {
        return this.hasLaunched;
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void timePassing(double time) {
    }
}

