/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class Exercise
extends Function
implements Serializable {
    public static final String NAME = "Exercise";
    private int exercisers;
    private int exerciserCapacity;

    public Exercise(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.exerciserCapacity = config.getExerciseCapacity(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = (double)settlement.getAllAssociatedPeople().size() / 4.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            Exercise exerciseFunction = (Exercise)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)exerciseFunction.exerciserCapacity * wearModifier;
        }
        double valueExerciser = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double exerciserCapacity = config.getExerciseCapacity(buildingName);
        return exerciserCapacity * valueExerciser;
    }

    public int getExerciserCapacity() {
        return this.exerciserCapacity;
    }

    public int getNumExercisers() {
        return this.exercisers;
    }

    public void addExerciser() {
        ++this.exercisers;
        if (this.exercisers > this.exerciserCapacity) {
            this.exercisers = this.exerciserCapacity;
            throw new IllegalStateException("Exercise facility in use.");
        }
    }

    public void removeExerciser() {
        --this.exercisers;
        if (this.exercisers < 0) {
            this.exercisers = 0;
            throw new IllegalStateException("Exercise facility empty.");
        }
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }
}

