/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.PowerSource;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;

public class FuelPowerSource
extends PowerSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FuelPowerSource.class.getName());
    private static final String TYPE = "Fuel Power Source";
    public static final double TOGGLE_RUNNING_WORK_TIME_REQUIRED = 10.0;
    private boolean toggle = false;
    private AmountResource resource;
    private double consumptionSpeed;
    private double toggleRunningWorkTime;

    public FuelPowerSource(double _maxPower, boolean _toggle, String fuelType, double _consumptionSpeed) {
        super(TYPE, _maxPower);
        this.consumptionSpeed = _consumptionSpeed;
        this.toggle = _toggle;
        this.resource = AmountResource.findAmountResource(fuelType);
    }

    @Override
    public double getCurrentPower(Building building) {
        if (this.toggle) {
            double fuelStored = building.getInventory().getAmountResourceStored(this.resource, false);
            if (fuelStored > 0.0) {
                return this.getMaxPower();
            }
            return 0.0;
        }
        return 0.0;
    }

    public void toggleON() {
        this.toggle = true;
    }

    public void toggleOFF() {
        this.toggle = false;
    }

    public boolean isToggleON() {
        return this.toggle;
    }

    public void consumeFuel(double time, Inventory inv) {
        double consumptionRateMillisol = this.consumptionSpeed / 1000.0;
        double consumedFuel = time * consumptionRateMillisol;
        double fuelStored = inv.getAmountResourceStored(this.resource, false);
        if (fuelStored < consumedFuel) {
            consumedFuel = fuelStored;
        }
        inv.retrieveAmountResource(this.resource, consumedFuel);
    }

    public AmountResource getFuelResource() {
        return this.resource;
    }

    public double getFuelConsumptionRate() {
        return this.consumptionSpeed;
    }

    public void addToggleWorkTime(double time) {
        this.toggleRunningWorkTime += time;
        if (this.toggleRunningWorkTime >= 10.0) {
            this.toggleRunningWorkTime = 0.0;
            boolean bl = this.toggle = !this.toggle;
            if (this.toggle) {
                logger.info(this.getType() + " turned on.");
            } else {
                logger.info(this.getType() + " turned off.");
            }
        }
    }

    @Override
    public double getAveragePower(Settlement settlement) {
        double fuelPower = this.getMaxPower();
        AmountResource fuelResource = this.getFuelResource();
        Good fuelGood = GoodsUtil.getResourceGood(fuelResource);
        GoodsManager goodsManager = settlement.getGoodsManager();
        double fuelValue = goodsManager.getGoodValuePerItem(fuelGood);
        if ((fuelPower -= (fuelValue *= this.getFuelConsumptionRate())) < 0.0) {
            fuelPower = 0.0;
        }
        return fuelPower;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resource = null;
    }
}

