/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class LivingAccommodations
extends Function
implements Serializable {
    public static final double WASH_WATER_USAGE_PERSON_SOL = 26.0;
    public static final String NAME = "Living Accommodations";
    private int beds;
    private int sleepers;

    public LivingAccommodations(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.beds = config.getLivingAccommodationBeds(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = (double)settlement.getAllAssociatedPeople().size() * 2.0;
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            LivingAccommodations livingFunction = (LivingAccommodations)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += (double)livingFunction.beds * wearModifier;
        }
        double bedCapacityValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double bedCapacity = config.getLivingAccommodationBeds(buildingName);
        return bedCapacity * bedCapacityValue;
    }

    public int getBeds() {
        return this.beds;
    }

    public int getSleepers() {
        return this.sleepers;
    }

    public void addSleeper() {
        ++this.sleepers;
        if (this.sleepers > this.beds) {
            this.sleepers = this.beds;
            throw new IllegalStateException("All beds are full.");
        }
    }

    public void removeSleeper() {
        --this.sleepers;
        if (this.sleepers < 0) {
            this.sleepers = 0;
            throw new IllegalStateException("Beds are empty.");
        }
    }

    public void waterUsage(double time) {
        AmountResource water;
        Inventory inv;
        double waterAvailable;
        double buildingProportionCap;
        double waterUsagePerPerson = 0.026 * time;
        Settlement settlement = this.getBuilding().getBuildingManager().getSettlement();
        double waterUsageSettlement = waterUsagePerPerson * (double)settlement.getCurrentPopulationNum();
        double waterUsageBuilding = waterUsageSettlement * (buildingProportionCap = (double)this.beds / (double)settlement.getPopulationCapacity());
        double waterUsed = waterUsageBuilding;
        if (waterUsed > (waterAvailable = (inv = this.getBuilding().getInventory()).getAmountResourceStored(water = AmountResource.findAmountResource("water"), false))) {
            waterUsed = waterAvailable;
        }
        inv.retrieveAmountResource(water, waterUsed);
        AmountResource wasteWater = AmountResource.findAmountResource("waste water");
        double wasteWaterProduced = waterUsed;
        double wasteWaterCapacity = inv.getAmountResourceRemainingCapacity(wasteWater, false, false);
        if (wasteWaterProduced > wasteWaterCapacity) {
            wasteWaterProduced = wasteWaterCapacity;
        }
        inv.storeAmountResource(wasteWater, wasteWaterProduced, false);
    }

    @Override
    public void timePassing(double time) {
        this.waterUsage(time);
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }
}

