/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class Management
extends Function
implements Serializable {
    public static final String NAME = "Management";
    private int populationSupport;

    public Management(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.populationSupport = config.getManagementPopulationSupport(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        BuildingConfig config;
        double demand = settlement.getAllAssociatedPeople().size();
        double supply = 0.0;
        for (Building managementBuilding : settlement.getBuildingManager().getBuildings(NAME)) {
            Management management = (Management)managementBuilding.getFunction(NAME);
            double populationSupport = management.getPopulationSupport();
            double wearFactor = managementBuilding.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += populationSupport * wearFactor;
        }
        if (!newBuilding && (supply -= (double)(config = SimulationConfig.instance().getBuildingConfiguration()).getManagementPopulationSupport(buildingName)) < 0.0) {
            supply = 0.0;
        }
        return demand / (supply + 1.0);
    }

    public int getPopulationSupport() {
        return this.populationSupport;
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void timePassing(double time) {
    }
}

