/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.RandomUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.UnitManager;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.EquipmentFactory;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.manufacture.ManufactureProcess;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.manufacture.PartSalvage;
import org.mars_sim.msp.core.manufacture.Salvagable;
import org.mars_sim.msp.core.manufacture.SalvageProcess;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;

public class Manufacture
extends Function
implements Serializable {
    private static String CLASS_NAME = "org.mars_sim.msp.simulation.structure.building.function.Manufacture";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    public static final String NAME = "Manufacture";
    private int techLevel;
    private int concurrentProcesses;
    private List<ManufactureProcess> processes;
    private List<SalvageProcess> salvages;

    public Manufacture(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.techLevel = config.getManufactureTechLevel(building.getName());
        this.concurrentProcesses = config.getManufactureConcurrentProcesses(building.getName());
        this.processes = new ArrayList<ManufactureProcess>();
        this.salvages = new ArrayList<SalvageProcess>();
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double buildingTech = config.getManufactureTechLevel(buildingName);
        double demand = 0.0;
        Iterator<Person> i = settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            demand += (double)i.next().getMind().getSkillManager().getSkillLevel("Materials Science");
        }
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            Manufacture manFunction = (Manufacture)building.getFunction(NAME);
            double tech = manFunction.techLevel;
            double processes = manFunction.concurrentProcesses;
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += tech * tech * processes * wearModifier;
        }
        double baseManufactureValue = demand / (supply + 1.0);
        double processes = config.getManufactureConcurrentProcesses(buildingName);
        double manufactureValue = buildingTech * buildingTech * processes;
        return manufactureValue * baseManufactureValue;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public int getConcurrentProcesses() {
        return this.concurrentProcesses;
    }

    public int getTotalProcessNumber() {
        return this.processes.size() + this.salvages.size();
    }

    public List<ManufactureProcess> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }

    public void addProcess(ManufactureProcess process) {
        if (process == null) {
            throw new IllegalArgumentException("process is null");
        }
        if (this.getTotalProcessNumber() >= this.concurrentProcesses) {
            throw new IllegalStateException("No space to add new manufacturing process.");
        }
        this.processes.add(process);
        Inventory inv = this.getBuilding().getInventory();
        for (ManufactureProcessItem item : process.getInfo().getInputList()) {
            if ("resource".equalsIgnoreCase(item.getType())) {
                AmountResource resource = AmountResource.findAmountResource(item.getName());
                inv.retrieveAmountResource(resource, item.getAmount());
            } else if ("part".equalsIgnoreCase(item.getType())) {
                Part part = (Part)ItemResource.findItemResource(item.getName());
                inv.retrieveItemResources(part, (int)item.getAmount());
            } else {
                throw new IllegalStateException("Manufacture process input: " + item.getType() + " not a valid type.");
            }
            GoodsManager goodsManager = this.getBuilding().getBuildingManager().getSettlement().getGoodsManager();
            goodsManager.updateGoodValue(ManufactureUtil.getGood(item), false);
        }
        if (logger.isLoggable(Level.FINEST)) {
            Settlement settlement = this.getBuilding().getBuildingManager().getSettlement();
            logger.finest(this.getBuilding() + " at " + settlement + " starting manufacturing process: " + process.getInfo().getName());
        }
    }

    public List<SalvageProcess> getSalvageProcesses() {
        return Collections.unmodifiableList(this.salvages);
    }

    public void addSalvageProcess(SalvageProcess process) {
        if (process == null) {
            throw new IllegalArgumentException("process is null");
        }
        if (this.getTotalProcessNumber() >= this.concurrentProcesses) {
            throw new IllegalStateException("No space to add new salvage process.");
        }
        this.salvages.add(process);
        Inventory inv = this.getBuilding().getInventory();
        Unit salvagedUnit = process.getSalvagedUnit();
        if (salvagedUnit == null) {
            throw new IllegalStateException("Salvaged unit is null");
        }
        inv.retrieveUnit(salvagedUnit);
        Settlement settlement = this.getBuilding().getBuildingManager().getSettlement();
        ((Salvagable)((Object)salvagedUnit)).startSalvage(process.getInfo(), settlement);
        GoodsManager goodsManager = settlement.getGoodsManager();
        Good salvagedGood = null;
        if (salvagedUnit instanceof Equipment) {
            salvagedGood = GoodsUtil.getEquipmentGood(salvagedUnit.getClass());
        } else if (salvagedUnit instanceof Vehicle) {
            salvagedGood = GoodsUtil.getVehicleGood(salvagedUnit.getDescription());
        }
        if (salvagedGood == null) {
            throw new IllegalStateException("Salvaged good is null");
        }
        goodsManager.updateGoodValue(salvagedGood, false);
        if (logger.isLoggable(Level.FINEST)) {
            Settlement stl = this.getBuilding().getBuildingManager().getSettlement();
            logger.finest(this.getBuilding() + " at " + stl + " starting salvage process: " + process.toString());
        }
    }

    @Override
    public double getFullPowerRequired() {
        double result = 0.0;
        for (ManufactureProcess process : this.processes) {
            if (!(process.getProcessTimeRemaining() > 0.0)) continue;
            result += process.getInfo().getPowerRequired();
        }
        return result;
    }

    @Override
    public double getPowerDownPowerRequired() {
        double result = 0.0;
        for (ManufactureProcess process : this.processes) {
            if (!(process.getProcessTimeRemaining() > 0.0)) continue;
            result += process.getInfo().getPowerRequired();
        }
        return result;
    }

    @Override
    public void timePassing(double time) {
        ArrayList<ManufactureProcess> finishedProcesses = new ArrayList<ManufactureProcess>();
        for (ManufactureProcess process : this.processes) {
            process.addProcessTime(time);
            if (process.getProcessTimeRemaining() != 0.0 || process.getWorkTimeRemaining() != 0.0) continue;
            finishedProcesses.add(process);
        }
        Iterator j = finishedProcesses.iterator();
        while (j.hasNext()) {
            this.endManufacturingProcess((ManufactureProcess)j.next(), false);
        }
    }

    public boolean requiresManufacturingWork(int skill) {
        boolean result = false;
        if (this.concurrentProcesses > this.getTotalProcessNumber()) {
            result = true;
        } else {
            for (ManufactureProcess process : this.processes) {
                boolean skillRequired;
                boolean workRequired = process.getWorkTimeRemaining() > 0.0;
                boolean bl = skillRequired = process.getInfo().getSkillLevelRequired() <= skill;
                if (!workRequired || !skillRequired) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean requiresSalvagingWork(int skill) {
        boolean result = false;
        if (this.concurrentProcesses > this.getTotalProcessNumber()) {
            result = true;
        } else {
            for (SalvageProcess process : this.salvages) {
                boolean skillRequired;
                boolean workRequired = process.getWorkTimeRemaining() > 0.0;
                boolean bl = skillRequired = process.getInfo().getSkillLevelRequired() <= skill;
                if (!workRequired || !skillRequired) continue;
                result = true;
            }
        }
        return result;
    }

    public void endManufacturingProcess(ManufactureProcess process, boolean premature) {
        Settlement settlement;
        if (!premature) {
            settlement = this.getBuilding().getBuildingManager().getSettlement();
            UnitManager manager = Simulation.instance().getUnitManager();
            Inventory inv = this.getBuilding().getInventory();
            for (ManufactureProcessItem item : process.getInfo().getOutputList()) {
                int x;
                double capacity;
                if (!(ManufactureUtil.getManufactureProcessItemValue(item, settlement) > 0.0)) continue;
                if ("resource".equalsIgnoreCase(item.getType())) {
                    AmountResource resource = AmountResource.findAmountResource(item.getName());
                    double amount = item.getAmount();
                    capacity = inv.getAmountResourceRemainingCapacity(resource, true, false);
                    if (item.getAmount() > capacity) {
                        amount = capacity;
                    }
                    inv.storeAmountResource(resource, amount, true);
                } else if ("part".equalsIgnoreCase(item.getType())) {
                    Part part = (Part)ItemResource.findItemResource(item.getName());
                    double mass = item.getAmount() * part.getMassPerItem();
                    if (mass <= (capacity = inv.getGeneralCapacity())) {
                        inv.storeItemResources(part, (int)item.getAmount());
                    }
                } else if ("equipment".equalsIgnoreCase(item.getType())) {
                    String equipmentType = item.getName();
                    int number = (int)item.getAmount();
                    for (x = 0; x < number; ++x) {
                        Equipment equipment = EquipmentFactory.getEquipment(equipmentType, settlement.getCoordinates(), false);
                        equipment.setName(manager.getNewName("equipment", equipmentType, null));
                        inv.storeUnit(equipment);
                    }
                } else if ("vehicle".equalsIgnoreCase(item.getType())) {
                    String vehicleType = item.getName();
                    int number = (int)item.getAmount();
                    for (x = 0; x < number; ++x) {
                        String name;
                        if ("Light Utility Vehicle".equals(vehicleType)) {
                            name = manager.getNewName("vehicle", "LUV", null);
                            manager.addUnit(new LightUtilityVehicle(name, vehicleType, settlement));
                            continue;
                        }
                        name = manager.getNewName("vehicle", null, null);
                        manager.addUnit(new Rover(name, vehicleType, settlement));
                    }
                } else {
                    throw new IllegalStateException("Manufacture.addProcess(): output: " + item.getType() + " not a valid type.");
                }
                GoodsManager goodsManager = this.getBuilding().getBuildingManager().getSettlement().getGoodsManager();
                goodsManager.updateGoodValue(ManufactureUtil.getGood(item), false);
            }
        }
        this.processes.remove(process);
        if (logger.isLoggable(Level.FINEST)) {
            settlement = this.getBuilding().getBuildingManager().getSettlement();
            logger.finest(this.getBuilding() + " at " + settlement + " ending manufacturing process: " + process.getInfo().getName());
        }
    }

    public void endSalvageProcess(SalvageProcess process, boolean premature) {
        Settlement settlement;
        HashMap<Part, Integer> partsSalvaged = new HashMap<Part, Integer>(0);
        if (!premature) {
            settlement = this.getBuilding().getBuildingManager().getSettlement();
            GoodsManager goodsManager = settlement.getGoodsManager();
            Inventory inv = this.getBuilding().getInventory();
            double salvageChance = 50.0;
            Unit salvagedUnit = process.getSalvagedUnit();
            if (salvagedUnit instanceof Malfunctionable) {
                Malfunctionable malfunctionable = (Malfunctionable)((Object)salvagedUnit);
                double wearCondition = malfunctionable.getMalfunctionManager().getWearCondition();
                salvageChance = wearCondition * 0.25 + 25.0;
            }
            salvageChance += process.getAverageSkillLevel() * 5.0;
            List<PartSalvage> partsToSalvage = process.getInfo().getPartSalvageList();
            for (PartSalvage partSalvage : partsToSalvage) {
                Part part = (Part)ItemResource.findItemResource(partSalvage.getName());
                int totalNumber = 0;
                for (int x = 0; x < partSalvage.getNumber(); ++x) {
                    if (!RandomUtil.lessThanRandPercent(salvageChance)) continue;
                    ++totalNumber;
                }
                if (totalNumber <= 0) continue;
                partsSalvaged.put(part, totalNumber);
                double mass = (double)totalNumber * part.getMassPerItem();
                double capacity = inv.getGeneralCapacity();
                if (mass <= capacity) {
                    inv.storeItemResources(part, totalNumber);
                }
                goodsManager.updateGoodValue(GoodsUtil.getResourceGood(part), false);
            }
        }
        ((Salvagable)((Object)process.getSalvagedUnit())).getSalvageInfo().finishSalvage(partsSalvaged);
        this.salvages.remove(process);
        if (logger.isLoggable(Level.FINEST)) {
            settlement = this.getBuilding().getBuildingManager().getSettlement();
            logger.finest(this.getBuilding() + " at " + settlement + " ending salvage process: " + process.toString());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<ManufactureProcess> i = this.processes.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        Iterator<SalvageProcess> j = this.salvages.iterator();
        while (j.hasNext()) {
            j.next().destroy();
        }
    }
}

