/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.AreothermalPowerSource;
import org.mars_sim.msp.core.structure.building.function.FuelPowerSource;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.PowerSource;
import org.mars_sim.msp.core.structure.building.function.SolarPowerSource;
import org.mars_sim.msp.core.structure.building.function.SolarThermalPowerSource;
import org.mars_sim.msp.core.structure.building.function.StandardPowerSource;
import org.mars_sim.msp.core.structure.building.function.WindPowerSource;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;

public class PowerGeneration
extends Function
implements Serializable {
    public static final String NAME = "Power Generation";
    private List<PowerSource> powerSources;

    public PowerGeneration(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.powerSources = config.getPowerSources(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double demand = settlement.getPowerGrid().getRequiredPower();
        double supply = 0.0;
        boolean removedBuilding = false;
        for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
            if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                removedBuilding = true;
                continue;
            }
            PowerGeneration powerFunction = (PowerGeneration)building.getFunction(NAME);
            double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            supply += PowerGeneration.getPowerSourceSupply(powerFunction.powerSources, settlement) * wearModifier;
        }
        double existingPowerValue = demand / (supply + 1.0);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double powerSupply = PowerGeneration.getPowerSourceSupply(config.getPowerSources(buildingName), settlement);
        return powerSupply * existingPowerValue;
    }

    private static double getPowerSourceSupply(List<PowerSource> powerSources, Settlement settlement) {
        double result = 0.0;
        for (PowerSource source : powerSources) {
            result += source.getAveragePower(settlement);
            if (source instanceof StandardPowerSource) {
                result += source.getMaxPower();
                continue;
            }
            if (source instanceof FuelPowerSource) {
                FuelPowerSource fuelSource = (FuelPowerSource)source;
                double fuelPower = source.getMaxPower();
                AmountResource fuelResource = fuelSource.getFuelResource();
                Good fuelGood = GoodsUtil.getResourceGood(fuelResource);
                double fuelValue = settlement.getGoodsManager().getGoodValuePerItem(fuelGood);
                if ((fuelPower -= (fuelValue *= fuelSource.getFuelConsumptionRate())) < 0.0) {
                    fuelPower = 0.0;
                }
                result += fuelPower;
                continue;
            }
            if (source instanceof SolarPowerSource) {
                result += source.getMaxPower() / 2.0;
                continue;
            }
            if (source instanceof SolarThermalPowerSource) {
                result += source.getMaxPower() / 2.5;
                continue;
            }
            if (source instanceof WindPowerSource) {
                result += source.getMaxPower() / 3.0;
                continue;
            }
            if (!(source instanceof AreothermalPowerSource)) continue;
            double areothermalHeat = Simulation.instance().getMars().getSurfaceFeatures().getAreothermalPotential(settlement.getCoordinates());
            result += source.getMaxPower() * (areothermalHeat / 100.0);
        }
        return result;
    }

    public double getGeneratedPower() {
        double result = 0.0;
        if (!this.getBuilding().getMalfunctionManager().hasMalfunction()) {
            Iterator<PowerSource> i = this.powerSources.iterator();
            while (i.hasNext()) {
                result += i.next().getCurrentPower(this.getBuilding());
            }
        }
        return result;
    }

    @Override
    public void timePassing(double time) {
        for (PowerSource source : this.powerSources) {
            FuelPowerSource fuelSource;
            if (!(source instanceof FuelPowerSource) || !(fuelSource = (FuelPowerSource)source).isToggleON()) continue;
            fuelSource.consumeFuel(time, this.getBuilding().getInventory());
        }
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public String[] getMalfunctionScopeStrings() {
        String[] result = new String[this.powerSources.size() + 1];
        result[0] = this.getName();
        for (int x = 0; x < this.powerSources.size(); ++x) {
            result[x + 1] = this.powerSources.get(x).getType();
        }
        return result;
    }

    public List<PowerSource> getPowerSources() {
        return new ArrayList<PowerSource>(this.powerSources);
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<PowerSource> i = this.powerSources.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
    }
}

