/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;

public class Research
extends Function
implements Lab,
Serializable {
    public static final String NAME = "Research";
    private int techLevel;
    private int researcherCapacity;
    private List<String> researchSpecialities;
    private int researcherNum;

    public Research(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.techLevel = config.getResearchTechLevel(building.getName());
        this.researcherCapacity = config.getResearchCapacity(building.getName());
        this.researchSpecialities = config.getResearchSpecialities(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double result = 0.0;
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        List<String> specialities = config.getResearchSpecialities(buildingName);
        for (String speciality : specialities) {
            int labSize;
            int techLevel;
            double researchDemand = 0.0;
            Iterator<Person> j = settlement.getAllAssociatedPeople().iterator();
            while (j.hasNext()) {
                researchDemand += (double)j.next().getMind().getSkillManager().getSkillLevel(speciality);
            }
            double researchSupply = 0.0;
            boolean removedBuilding = false;
            for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
                if (!newBuilding && building.getName().equalsIgnoreCase(buildingName) && !removedBuilding) {
                    removedBuilding = true;
                    continue;
                }
                Research researchFunction = (Research)building.getFunction(NAME);
                techLevel = researchFunction.techLevel;
                labSize = researchFunction.researcherCapacity;
                double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
                for (int x = 0; x < researchFunction.getTechSpecialities().length; ++x) {
                    String researchSpeciality = researchFunction.getTechSpecialities()[x];
                    if (!speciality.equals(researchSpeciality)) continue;
                    researchSupply += (double)(techLevel * labSize) * wearModifier;
                }
            }
            double existingResearchValue = researchDemand / (researchSupply + 1.0);
            techLevel = config.getResearchTechLevel(buildingName);
            labSize = config.getResearchCapacity(buildingName);
            double buildingResearchSupply = techLevel * labSize;
            result += buildingResearchSupply * existingResearchValue;
        }
        return result;
    }

    @Override
    public int getTechnologyLevel() {
        return this.techLevel;
    }

    @Override
    public int getLaboratorySize() {
        return this.researcherCapacity;
    }

    @Override
    public String[] getTechSpecialities() {
        String[] result = new String[this.researchSpecialities.size()];
        for (int x = 0; x < this.researchSpecialities.size(); ++x) {
            result[x] = this.researchSpecialities.get(x);
        }
        return result;
    }

    @Override
    public boolean hasSpeciality(String speciality) {
        boolean result = false;
        Iterator<String> i = this.researchSpecialities.iterator();
        while (i.hasNext()) {
            if (!i.next().equalsIgnoreCase(speciality)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public int getResearcherNum() {
        return this.researcherNum;
    }

    @Override
    public void addResearcher() {
        ++this.researcherNum;
        if (this.researcherNum > this.researcherCapacity) {
            this.researcherNum = this.researcherCapacity;
            throw new IllegalStateException("Lab already full of researchers.");
        }
    }

    @Override
    public void removeResearcher() {
        --this.researcherNum;
        if (this.researcherNum < 0) {
            this.researcherNum = 0;
            throw new IllegalStateException("Lab is already empty of researchers.");
        }
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.researchSpecialities.clear();
        this.researchSpecialities = null;
    }
}

