/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.resource.AmountResource;

public class ResourceProcess
implements Serializable {
    private static Logger logger = Logger.getLogger(ResourceProcess.class.getName());
    public static final double TOGGLE_RUNNING_WORK_TIME_REQUIRED = 10.0;
    private String name;
    private Map<AmountResource, Double> maxInputResourceRates;
    private Map<AmountResource, Double> maxAmbientInputResourceRates;
    private Map<AmountResource, Double> maxOutputResourceRates;
    private Map<AmountResource, Double> maxWasteOutputResourceRates;
    private boolean runningProcess;
    private double currentProductionLevel;
    private double toggleRunningWorkTime;
    private double powerRequired;

    public ResourceProcess(String name, double powerRequired, boolean defaultOn) {
        this.name = name;
        this.maxInputResourceRates = new HashMap<AmountResource, Double>();
        this.maxAmbientInputResourceRates = new HashMap<AmountResource, Double>();
        this.maxOutputResourceRates = new HashMap<AmountResource, Double>();
        this.maxWasteOutputResourceRates = new HashMap<AmountResource, Double>();
        this.runningProcess = defaultOn;
        this.currentProductionLevel = 1.0;
        this.powerRequired = powerRequired;
    }

    public String getProcessName() {
        return this.name;
    }

    public void addMaxInputResourceRate(AmountResource resource, double rate, boolean ambient) {
        if (ambient) {
            if (!this.maxAmbientInputResourceRates.containsKey(resource)) {
                this.maxAmbientInputResourceRates.put(resource, rate);
            }
        } else if (!this.maxInputResourceRates.containsKey(resource)) {
            this.maxInputResourceRates.put(resource, rate);
        }
    }

    public void addMaxOutputResourceRate(AmountResource resource, double rate, boolean waste) {
        if (waste) {
            if (!this.maxWasteOutputResourceRates.containsKey(resource)) {
                this.maxWasteOutputResourceRates.put(resource, rate);
            }
        } else if (!this.maxOutputResourceRates.containsKey(resource)) {
            this.maxOutputResourceRates.put(resource, rate);
        }
    }

    public double getCurrentProductionLevel() {
        return this.currentProductionLevel;
    }

    public boolean isProcessRunning() {
        return this.runningProcess;
    }

    public void setProcessRunning(boolean runningProcess) {
        this.runningProcess = runningProcess;
    }

    public void addToggleWorkTime(double time) {
        this.toggleRunningWorkTime += time;
        if (this.toggleRunningWorkTime >= 10.0) {
            this.toggleRunningWorkTime = 0.0;
            boolean bl = this.runningProcess = !this.runningProcess;
            if (this.runningProcess) {
                logger.info(this.name + " turned on.");
            } else {
                logger.info(this.name + " turned off.");
            }
        }
    }

    public Set<AmountResource> getInputResources() {
        HashSet<AmountResource> results = new HashSet<AmountResource>();
        results.addAll(this.maxInputResourceRates.keySet());
        results.addAll(this.maxAmbientInputResourceRates.keySet());
        return results;
    }

    public double getMaxInputResourceRate(AmountResource resource) {
        double result = 0.0;
        if (this.maxInputResourceRates.containsKey(resource)) {
            result = this.maxInputResourceRates.get(resource);
        } else if (this.maxAmbientInputResourceRates.containsKey(resource)) {
            result = this.maxAmbientInputResourceRates.get(resource);
        }
        return result;
    }

    public boolean isAmbientInputResource(AmountResource resource) {
        return this.maxAmbientInputResourceRates.containsKey(resource);
    }

    public Set<AmountResource> getOutputResources() {
        HashSet<AmountResource> results = new HashSet<AmountResource>();
        results.addAll(this.maxOutputResourceRates.keySet());
        results.addAll(this.maxWasteOutputResourceRates.keySet());
        return results;
    }

    public double getMaxOutputResourceRate(AmountResource resource) {
        double result = 0.0;
        if (this.maxOutputResourceRates.containsKey(resource)) {
            result = this.maxOutputResourceRates.get(resource);
        } else if (this.maxWasteOutputResourceRates.containsKey(resource)) {
            result = this.maxWasteOutputResourceRates.get(resource);
        }
        return result;
    }

    public boolean isWasteOutputResource(AmountResource resource) {
        return this.maxWasteOutputResourceRates.containsKey(resource);
    }

    public void processResources(double time, double productionLevel, Inventory inventory) {
        if (productionLevel < 0.0 || productionLevel > 1.0 || time < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.runningProcess) {
            double bottleneck = this.getInputBottleneck(time, inventory);
            if (productionLevel > bottleneck) {
                productionLevel = bottleneck;
            }
            for (AmountResource resource : this.maxInputResourceRates.keySet()) {
                double remainingAmount;
                double maxRate = this.maxInputResourceRates.get(resource);
                double resourceRate = maxRate * productionLevel;
                double resourceAmount = resourceRate * time;
                if (resourceAmount > (remainingAmount = inventory.getAmountResourceStored(resource, false))) {
                    resourceAmount = remainingAmount;
                }
                try {
                    inventory.retrieveAmountResource(resource, resourceAmount);
                }
                catch (Exception e) {}
            }
            for (AmountResource resource : this.maxOutputResourceRates.keySet()) {
                double remainingCapacity;
                double maxRate = this.maxOutputResourceRates.get(resource);
                double resourceRate = maxRate * productionLevel;
                double resourceAmount = resourceRate * time;
                if (resourceAmount > (remainingCapacity = inventory.getAmountResourceRemainingCapacity(resource, false, false))) {
                    resourceAmount = remainingCapacity;
                }
                try {
                    inventory.storeAmountResource(resource, resourceAmount, false);
                }
                catch (Exception e) {}
            }
        } else {
            productionLevel = 0.0;
        }
        this.currentProductionLevel = productionLevel;
    }

    private double getInputBottleneck(double time, Inventory inventory) {
        if (time < 0.0) {
            throw new IllegalArgumentException("time must be > 0D");
        }
        double bottleneck = 1.0;
        for (AmountResource resource : this.maxInputResourceRates.keySet()) {
            double maxRate = this.maxInputResourceRates.get(resource);
            double desiredResourceAmount = maxRate * time;
            double inventoryResourceAmount = inventory.getAmountResourceStored(resource, false);
            double proportionAvailable = 1.0;
            if (desiredResourceAmount > 0.0) {
                proportionAvailable = inventoryResourceAmount / desiredResourceAmount;
            }
            if (!(bottleneck > proportionAvailable)) continue;
            bottleneck = proportionAvailable;
        }
        return bottleneck;
    }

    public String toString() {
        return this.name;
    }

    public double getPowerRequired() {
        return this.powerRequired;
    }

    public void destroy() {
        this.name = null;
        this.maxInputResourceRates.clear();
        this.maxInputResourceRates = null;
        this.maxAmbientInputResourceRates.clear();
        this.maxAmbientInputResourceRates = null;
        this.maxOutputResourceRates.clear();
        this.maxOutputResourceRates = null;
        this.maxWasteOutputResourceRates.clear();
        this.maxWasteOutputResourceRates = null;
    }
}

