/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class ResourceProcessing
extends Function
implements Serializable {
    public static final String NAME = "Resource Processing";
    private static final double PROCESS_MAX_VALUE = 100.0;
    private double powerDownProcessingLevel;
    private List<ResourceProcess> resourceProcesses;

    public ResourceProcessing(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        this.powerDownProcessingLevel = config.getResourceProcessingPowerDown(building.getName());
        this.resourceProcesses = config.getResourceProcesses(building.getName());
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        double result = 0.0;
        List<ResourceProcess> processes = config.getResourceProcesses(buildingName);
        for (ResourceProcess process : processes) {
            double processValue = 0.0;
            for (AmountResource resource : process.getOutputResources()) {
                if (process.isWasteOutputResource(resource)) continue;
                Good resourceGood = GoodsUtil.getResourceGood(resource);
                double rate = process.getMaxOutputResourceRate(resource) * 1000.0;
                processValue += settlement.getGoodsManager().getGoodValuePerItem(resourceGood) * rate;
            }
            for (AmountResource resource : process.getInputResources()) {
                if (process.isAmbientInputResource(resource)) continue;
                Good resourceGood = GoodsUtil.getResourceGood(resource);
                double rate = process.getMaxInputResourceRate(resource) * 1000.0;
                processValue -= settlement.getGoodsManager().getGoodValuePerItem(resourceGood) * rate;
            }
            double hoursInSol = MarsClock.convertMillisolsToSeconds(1000.0) / 60.0 / 60.0;
            double powerHrsRequiredPerSol = process.getPowerRequired() * hoursInSol;
            double powerValue = powerHrsRequiredPerSol * settlement.getPowerGrid().getPowerValue();
            if ((processValue -= powerValue) < 0.0) {
                processValue = 0.0;
            }
            if (processValue > 100.0) {
                processValue = 100.0;
            }
            result += processValue;
        }
        return result;
    }

    public List<ResourceProcess> getProcesses() {
        return this.resourceProcesses;
    }

    public double getPowerDownResourceProcessingLevel() {
        return this.powerDownProcessingLevel;
    }

    @Override
    public void timePassing(double time) {
        double productionLevel = 0.0;
        if (this.getBuilding().getPowerMode().equals("Full Power")) {
            productionLevel = 1.0;
        } else if (this.getBuilding().getPowerMode().equals("Power Down")) {
            productionLevel = this.powerDownProcessingLevel;
        }
        Iterator<ResourceProcess> i = this.resourceProcesses.iterator();
        while (i.hasNext()) {
            i.next().processResources(time, productionLevel, this.getBuilding().getInventory());
        }
    }

    @Override
    public double getFullPowerRequired() {
        double result = 0.0;
        for (ResourceProcess process : this.resourceProcesses) {
            if (!process.isProcessRunning()) continue;
            result += process.getPowerRequired();
        }
        return result;
    }

    @Override
    public double getPowerDownPowerRequired() {
        double result = 0.0;
        for (ResourceProcess process : this.resourceProcesses) {
            if (!process.isProcessRunning()) continue;
            result += process.getPowerRequired();
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<ResourceProcess> i = this.resourceProcesses.iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
        this.resourceProcesses.clear();
        this.resourceProcesses = null;
    }
}

