/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.mars.SurfaceFeatures;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.PowerSource;

public class SolarPowerSource
extends PowerSource
implements Serializable {
    private static final String TYPE = "Solar Power Source";

    public SolarPowerSource(double maxPower) {
        super(TYPE, maxPower);
    }

    @Override
    public double getCurrentPower(Building building) {
        BuildingManager manager = building.getBuildingManager();
        Coordinates location = manager.getSettlement().getCoordinates();
        SurfaceFeatures surface = Simulation.instance().getMars().getSurfaceFeatures();
        double sunlight = surface.getSurfaceSunlight(location);
        return sunlight * this.getMaxPower();
    }

    @Override
    public double getAveragePower(Settlement settlement) {
        return this.getMaxPower() / 2.0;
    }
}

