/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.io.Serializable;
import java.util.Map;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingConfig;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;

public class Storage
extends Function
implements Serializable {
    public static final String NAME = "Storage";
    private Map<AmountResource, Double> storageCapacity;

    public Storage(Building building) {
        super(NAME, building);
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        Inventory inventory = building.getInventory();
        this.storageCapacity = config.getStorageCapacities(building.getName());
        for (AmountResource resource : this.storageCapacity.keySet()) {
            double currentCapacity = inventory.getAmountResourceCapacity(resource, false);
            double buildingCapacity = this.storageCapacity.get(resource);
            inventory.addAmountResourceTypeCapacity(resource, currentCapacity + buildingCapacity);
        }
        Map<AmountResource, Double> initialResources = config.getInitialStorage(building.getName());
        for (AmountResource resource : initialResources.keySet()) {
            double resourceCapacity;
            double initialResource = initialResources.get(resource);
            if (initialResource > (resourceCapacity = inventory.getAmountResourceRemainingCapacity(resource, true, false))) {
                initialResource = resourceCapacity;
            }
            inventory.storeAmountResource(resource, initialResource, true);
        }
    }

    public static double getFunctionValue(String buildingName, boolean newBuilding, Settlement settlement) {
        double result = 0.0;
        BuildingConfig config = SimulationConfig.instance().getBuildingConfiguration();
        Map<AmountResource, Double> storageMap = config.getStorageCapacities(buildingName);
        for (AmountResource resource : storageMap.keySet()) {
            double buildingStorageNeeded;
            double resourceStored;
            double existingStorage = 0.0;
            for (Building building : settlement.getBuildingManager().getBuildings(NAME)) {
                Storage storageFunction = (Storage)building.getFunction(NAME);
                double wearModifier = building.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
                if (!storageFunction.storageCapacity.containsKey(resource)) continue;
                existingStorage += storageFunction.storageCapacity.get(resource) * wearModifier;
            }
            double storageAmount = storageMap.get(resource);
            if (!newBuilding && (existingStorage -= storageAmount) < 0.0) {
                existingStorage = 0.0;
            }
            Good resourceGood = GoodsUtil.getResourceGood(resource);
            double resourceValue = settlement.getGoodsManager().getGoodValuePerItem(resourceGood);
            double resourceDemand = resourceValue * ((resourceStored = settlement.getInventory().getAmountResourceStored(resource, false)) + 1.0);
            double currentStorageDemand = resourceDemand - existingStorage;
            if (currentStorageDemand < 0.0) {
                currentStorageDemand = 0.0;
            }
            if ((buildingStorageNeeded = currentStorageDemand) > storageAmount) {
                buildingStorageNeeded = storageAmount;
            }
            result += buildingStorageNeeded / 1000.0;
        }
        return result;
    }

    public Map<AmountResource, Double> getResourceStorageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public void timePassing(double time) {
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    @Override
    public void removeFromSettlement() {
        for (AmountResource resource : this.storageCapacity.keySet()) {
            double totalStoredAmount;
            double storageCapacityAmount = this.storageCapacity.get(resource);
            Inventory inv = this.getBuilding().getInventory();
            double totalStorageCapacityAmount = inv.getAmountResourceCapacity(resource, false);
            double remainingStorageCapacityAmount = totalStorageCapacityAmount - storageCapacityAmount;
            if (!(remainingStorageCapacityAmount < (totalStoredAmount = inv.getAmountResourceStored(resource, false)))) continue;
            double resourceAmountRemoved = totalStoredAmount - remainingStorageCapacityAmount;
            inv.retrieveAmountResource(resource, resourceAmountRemoved);
        }
        for (AmountResource resource : this.storageCapacity.keySet()) {
            double storageCapacityAmount = this.storageCapacity.get(resource);
            Inventory inv = this.getBuilding().getInventory();
            inv.removeAmountResourceTypeCapacity(resource, storageCapacityAmount);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.storageCapacity.clear();
        this.storageCapacity = null;
    }
}

