/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.building.function;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Function;
import org.mars_sim.msp.core.vehicle.Vehicle;

public abstract class VehicleMaintenance
extends Function
implements Serializable {
    private static Logger logger = Logger.getLogger(VehicleMaintenance.class.getName());
    protected int vehicleCapacity;
    protected List<ParkingLocation> parkingLocations;
    private Collection<Vehicle> vehicles = new ConcurrentLinkedQueue<Vehicle>();

    public VehicleMaintenance(String name, Building building) {
        super(name, building);
        this.parkingLocations = new ArrayList<ParkingLocation>();
    }

    public int getVehicleCapacity() {
        return this.vehicleCapacity;
    }

    public int getCurrentVehicleNumber() {
        return this.vehicles.size();
    }

    public void addVehicle(Vehicle vehicle) {
        if (this.vehicles.contains(vehicle)) {
            throw new IllegalStateException("Building already contains vehicle.");
        }
        if (this.vehicles.size() >= this.vehicleCapacity) {
            throw new IllegalStateException("Building is full of vehicles.");
        }
        for (Building building : this.getBuilding().getBuildingManager().getBuildings(this.getName())) {
            VehicleMaintenance garage = (VehicleMaintenance)building.getFunction(this.getName());
            if (!garage.containsVehicle(vehicle)) continue;
            garage.removeVehicle(vehicle);
        }
        this.vehicles.add(vehicle);
        ParkingLocation location = this.getEmptyParkingLocation();
        double newXLoc = 0.0;
        double newYLoc = 0.0;
        if (location != null) {
            Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(location.getXLocation(), location.getYLocation(), this.getBuilding());
            newXLoc = settlementLoc.getX();
            newYLoc = settlementLoc.getY();
            location.parkVehicle(vehicle);
        } else {
            newXLoc = this.getBuilding().getXLocation();
            newYLoc = this.getBuilding().getYLocation();
        }
        double newFacing = this.getBuilding().getFacing();
        vehicle.setParkedLocation(newXLoc, newYLoc, newFacing);
        logger.info("Adding " + vehicle.getName());
    }

    public void removeVehicle(Vehicle vehicle) {
        if (!this.containsVehicle(vehicle)) {
            throw new IllegalStateException("Vehicle not in building.");
        }
        this.vehicles.remove(vehicle);
        ParkingLocation parkedLoc = this.getVehicleParkedLocation(vehicle);
        if (parkedLoc != null) {
            parkedLoc.clearParking();
        }
        vehicle.determinedSettlementParkedLocationAndFacing();
        logger.info("Removing " + vehicle.getName());
    }

    public boolean containsVehicle(Vehicle vehicle) {
        return this.vehicles.contains(vehicle);
    }

    public Collection<Vehicle> getVehicles() {
        return this.vehicles;
    }

    @Override
    public void timePassing(double time) {
        for (Vehicle vehicle : this.vehicles) {
            if (vehicle.isReserved()) continue;
            this.removeVehicle(vehicle);
        }
    }

    @Override
    public double getFullPowerRequired() {
        return 0.0;
    }

    @Override
    public double getPowerDownPowerRequired() {
        return 0.0;
    }

    protected void addParkingLocation(double xLocation, double yLocation) {
        this.parkingLocations.add(new ParkingLocation(xLocation, yLocation));
    }

    public ParkingLocation getVehicleParkedLocation(Vehicle vehicle) {
        ParkingLocation result = null;
        for (ParkingLocation parkingLocation : this.parkingLocations) {
            if (!vehicle.equals(parkingLocation.getParkedVehicle())) continue;
            result = parkingLocation;
        }
        return result;
    }

    public ParkingLocation getEmptyParkingLocation() {
        ParkingLocation result = null;
        ArrayList<ParkingLocation> emptyLocations = new ArrayList<ParkingLocation>(this.parkingLocations.size());
        for (ParkingLocation parkingLocation : this.parkingLocations) {
            if (parkingLocation.hasParkedVehicle()) continue;
            emptyLocations.add(parkingLocation);
        }
        if (emptyLocations.size() > 0) {
            Collections.shuffle(emptyLocations);
            result = (ParkingLocation)emptyLocations.get(0);
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.vehicles.clear();
        this.vehicles = null;
        this.parkingLocations.clear();
        this.parkingLocations = null;
    }

    public class ParkingLocation
    implements Serializable {
        private double xLocation;
        private double yLocation;
        private Vehicle parkedVehicle;

        protected ParkingLocation(double xLocation, double yLocation) {
            this.xLocation = xLocation;
            this.yLocation = yLocation;
            this.parkedVehicle = null;
        }

        public double getXLocation() {
            return this.xLocation;
        }

        public double getYLocation() {
            return this.yLocation;
        }

        public Vehicle getParkedVehicle() {
            return this.parkedVehicle;
        }

        public boolean hasParkedVehicle() {
            return this.parkedVehicle != null;
        }

        protected void parkVehicle(Vehicle vehicle) {
            this.parkedVehicle = vehicle;
        }

        protected void clearParking() {
            this.parkedVehicle = null;
        }
    }
}

