/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionVehicleType;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Rover;

public class ConstructionConfig
implements Serializable {
    private static final String NAME = "name";
    private static final String WIDTH = "width";
    private static final String LENGTH = "length";
    private static final String CONSTRUCTABLE = "constructable";
    private static final String SALVAGABLE = "salvagable";
    private static final String WORK_TIME = "work-time";
    private static final String SKILL_REQUIRED = "skill-required";
    private static final String PART = "part";
    private static final String NUMBER = "number";
    private static final String RESOURCE = "resource";
    private static final String AMOUNT = "amount";
    private static final String VEHICLE = "vehicle";
    private static final String TYPE = "type";
    private static final String ATTACHMENT_PART = "attachment-part";
    private Document constructionDoc;
    private List<ConstructionStageInfo> foundationStageInfoList;
    private List<ConstructionStageInfo> frameStageInfoList;
    private List<ConstructionStageInfo> buildingStageInfoList;

    public ConstructionConfig(Document constructionDoc) {
        this.constructionDoc = constructionDoc;
    }

    public List<ConstructionStageInfo> getConstructionStageInfoList(String stageType) {
        List<ConstructionStageInfo> stageInfo = null;
        if ("foundation".equals(stageType)) {
            if (this.foundationStageInfoList == null) {
                this.createConstructionStageInfoList("foundation");
            }
            stageInfo = this.foundationStageInfoList;
        } else if ("frame".equals(stageType)) {
            if (this.frameStageInfoList == null) {
                this.createConstructionStageInfoList("frame");
            }
            stageInfo = this.frameStageInfoList;
        } else if ("building".equals(stageType)) {
            if (this.buildingStageInfoList == null) {
                this.createConstructionStageInfoList("building");
            }
            stageInfo = this.buildingStageInfoList;
        } else {
            throw new IllegalStateException("stageType: " + stageType + " is invalid.");
        }
        return new ArrayList<ConstructionStageInfo>(stageInfo);
    }

    private List<ConstructionStageInfo> createConstructionStageInfoList(String stageType) {
        List<ConstructionStageInfo> stageInfoList = null;
        if ("foundation".equals(stageType)) {
            stageInfoList = this.foundationStageInfoList = new ArrayList<ConstructionStageInfo>();
        } else if ("frame".equals(stageType)) {
            this.frameStageInfoList = new ArrayList<ConstructionStageInfo>();
            stageInfoList = this.frameStageInfoList;
        } else if ("building".equals(stageType)) {
            this.buildingStageInfoList = new ArrayList<ConstructionStageInfo>();
            stageInfoList = this.buildingStageInfoList;
        } else {
            throw new IllegalStateException("stageType: " + stageType + " not valid.");
        }
        Element root = this.constructionDoc.getRootElement();
        Element stageInfoListElement = root.getChild(stageType + "-list");
        List stageInfoNodes = stageInfoListElement.getChildren(stageType);
        for (Element stageInfoElement : stageInfoNodes) {
            String name = "";
            try {
                name = stageInfoElement.getAttributeValue(NAME);
                String widthStr = stageInfoElement.getAttributeValue(WIDTH);
                double width = Double.parseDouble(widthStr);
                String lengthStr = stageInfoElement.getAttributeValue(LENGTH);
                double length = Double.parseDouble(lengthStr);
                boolean unsetDimensions = false;
                if (width == -1.0 || length == -1.0) {
                    unsetDimensions = true;
                }
                boolean constructable = Boolean.parseBoolean(stageInfoElement.getAttributeValue(CONSTRUCTABLE));
                boolean salvagable = Boolean.parseBoolean(stageInfoElement.getAttributeValue(SALVAGABLE));
                double workTime = Double.parseDouble(stageInfoElement.getAttributeValue(WORK_TIME));
                workTime *= 1000.0;
                int skillRequired = Integer.parseInt(stageInfoElement.getAttributeValue(SKILL_REQUIRED));
                String prerequisiteStage = null;
                String prerequisiteStageType = null;
                if ("frame".equals(stageType)) {
                    prerequisiteStageType = "foundation";
                } else if ("building".equals(stageType)) {
                    prerequisiteStageType = "frame";
                }
                if (prerequisiteStageType != null) {
                    prerequisiteStage = stageInfoElement.getAttributeValue(prerequisiteStageType);
                }
                List partList = stageInfoElement.getChildren(PART);
                HashMap<Part, Integer> parts = new HashMap<Part, Integer>(partList.size());
                for (Element partElement : partList) {
                    String partName = partElement.getAttributeValue(NAME);
                    int partNum = Integer.parseInt(partElement.getAttributeValue(NUMBER));
                    Part part = (Part)ItemResource.findItemResource(partName);
                    parts.put(part, partNum);
                }
                List resourceList = stageInfoElement.getChildren(RESOURCE);
                HashMap<AmountResource, Double> resources = new HashMap<AmountResource, Double>(resourceList.size());
                for (Element resourceElement : resourceList) {
                    String resourceName = resourceElement.getAttributeValue(NAME);
                    double resourceAmount = Double.parseDouble(resourceElement.getAttributeValue(AMOUNT));
                    AmountResource resource = AmountResource.findAmountResource(resourceName);
                    resources.put(resource, resourceAmount);
                }
                List vehicleList = stageInfoElement.getChildren(VEHICLE);
                ArrayList<ConstructionVehicleType> vehicles = new ArrayList<ConstructionVehicleType>(vehicleList.size());
                for (Element vehicleElement : vehicleList) {
                    String vehicleType = vehicleElement.getAttributeValue(TYPE);
                    Class vehicleClass = null;
                    if (vehicleType.toLowerCase().indexOf("rover") > -1) {
                        vehicleClass = Rover.class;
                    } else if (vehicleType.equalsIgnoreCase("light utility vehicle")) {
                        vehicleClass = LightUtilityVehicle.class;
                    } else {
                        throw new IllegalStateException("Unknown vehicle type: " + vehicleType);
                    }
                    List attachmentPartList = vehicleElement.getChildren(ATTACHMENT_PART);
                    ArrayList<Part> attachmentParts = new ArrayList<Part>(attachmentPartList.size());
                    for (Element attachmentPartElement : attachmentPartList) {
                        String partName = attachmentPartElement.getAttributeValue(NAME);
                        Part attachmentPart = (Part)ItemResource.findItemResource(partName);
                        attachmentParts.add(attachmentPart);
                    }
                    vehicles.add(new ConstructionVehicleType(vehicleType, vehicleClass, attachmentParts));
                }
                ConstructionStageInfo stageInfo = new ConstructionStageInfo(name, stageType, width, length, unsetDimensions, constructable, salvagable, workTime, skillRequired, prerequisiteStage, parts, resources, vehicles);
                stageInfoList.add(stageInfo);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error reading construction stage " + name + ": " + e.getMessage());
            }
        }
        return stageInfoList;
    }

    public void destroy() {
        this.constructionDoc = null;
        if (this.foundationStageInfoList != null) {
            Iterator<ConstructionStageInfo> i = this.foundationStageInfoList.iterator();
            while (i.hasNext()) {
                i.next().destroy();
            }
        }
        if (this.frameStageInfoList != null) {
            Iterator<ConstructionStageInfo> j = this.frameStageInfoList.iterator();
            while (j.hasNext()) {
                j.next().destroy();
            }
        }
        if (this.buildingStageInfoList != null) {
            Iterator<ConstructionStageInfo> k = this.buildingStageInfoList.iterator();
            while (k.hasNext()) {
                k.next().destroy();
            }
        }
    }
}

