/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.building.function.LifeSupport;
import org.mars_sim.msp.core.structure.construction.ConstructedBuildingLogEntry;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.construction.ConstructionValues;
import org.mars_sim.msp.core.structure.construction.SalvageValues;
import org.mars_sim.msp.core.time.MarsClock;

public class ConstructionManager
implements Serializable {
    public static final String START_CONSTRUCTION_SITE_EVENT = "start construction site";
    public static final String FINISH_BUILDING_EVENT = "finish building";
    public static final String FINISH_SALVAGE_EVENT = "salvage building";
    private Settlement settlement;
    private List<ConstructionSite> sites;
    private ConstructionValues values;
    private SalvageValues salvageValues;
    private List<ConstructedBuildingLogEntry> constructedBuildingLog;

    public ConstructionManager(Settlement settlement) {
        this.settlement = settlement;
        this.sites = new ArrayList<ConstructionSite>();
        this.values = new ConstructionValues(settlement);
        this.salvageValues = new SalvageValues(settlement);
        this.constructedBuildingLog = new ArrayList<ConstructedBuildingLogEntry>();
    }

    public List<ConstructionSite> getConstructionSites() {
        return new ArrayList<ConstructionSite>(this.sites);
    }

    public List<ConstructionSite> getConstructionSitesNeedingConstructionMission() {
        ArrayList<ConstructionSite> result = new ArrayList<ConstructionSite>();
        for (ConstructionSite site : this.sites) {
            if (site.isUndergoingConstruction() || site.isUndergoingSalvage() || site.isAllConstructionComplete() || site.isAllSalvageComplete()) continue;
            ConstructionStage currentStage = site.getCurrentConstructionStage();
            if (currentStage != null) {
                if (currentStage.isComplete()) {
                    result.add(site);
                    continue;
                }
                if (currentStage.isSalvaging()) continue;
                result.add(site);
                continue;
            }
            result.add(site);
        }
        return result;
    }

    public List<ConstructionSite> getConstructionSitesNeedingSalvageMission() {
        ArrayList<ConstructionSite> result = new ArrayList<ConstructionSite>();
        for (ConstructionSite site : this.sites) {
            ConstructionStage currentStage;
            if (site.isUndergoingConstruction() || site.isUndergoingSalvage() || site.isAllConstructionComplete() || site.isAllSalvageComplete() || (currentStage = site.getCurrentConstructionStage()) == null) continue;
            if (currentStage.isComplete()) {
                result.add(site);
                continue;
            }
            if (!currentStage.isSalvaging()) continue;
            result.add(site);
        }
        return result;
    }

    public ConstructionSite createNewConstructionSite() {
        ConstructionSite result = new ConstructionSite();
        this.sites.add(result);
        this.settlement.fireUnitUpdate(START_CONSTRUCTION_SITE_EVENT, result);
        return result;
    }

    public void removeConstructionSite(ConstructionSite site) {
        if (!this.sites.contains(site)) {
            throw new IllegalStateException("Construction site doesn't exist.");
        }
        this.sites.remove(site);
    }

    public ConstructionValues getConstructionValues() {
        return this.values;
    }

    public SalvageValues getSalvageValues() {
        return this.salvageValues;
    }

    void addConstructedBuildingLogEntry(String buildingName, MarsClock builtTime) {
        if (buildingName == null) {
            throw new IllegalArgumentException("buildingName is null");
        }
        if (builtTime == null) {
            throw new IllegalArgumentException("builtTime is null");
        }
        ConstructedBuildingLogEntry logEntry = new ConstructedBuildingLogEntry(buildingName, builtTime);
        this.constructedBuildingLog.add(logEntry);
    }

    public List<ConstructedBuildingLogEntry> getConstructedBuildingLog() {
        return new ArrayList<ConstructedBuildingLogEntry>(this.constructedBuildingLog);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstructionSite createNewSalvageConstructionSite(Building salvagedBuilding) {
        BuildingManager buildingManager = salvagedBuilding.getBuildingManager();
        buildingManager.removeBuilding(salvagedBuilding);
        if (salvagedBuilding.hasFunction("Life Support")) {
            LifeSupport lifeSupport = (LifeSupport)salvagedBuilding.getFunction("Life Support");
            for (Person occupant : lifeSupport.getOccupants()) {
                BuildingManager.removePersonFromBuilding(occupant, salvagedBuilding);
                BuildingManager.addToRandomBuilding(occupant, buildingManager.getSettlement());
            }
        }
        ConstructionSite site = this.createNewConstructionSite();
        site.setXLocation(salvagedBuilding.getXLocation());
        site.setYLocation(salvagedBuilding.getYLocation());
        site.setFacing(salvagedBuilding.getFacing());
        ConstructionStageInfo buildingStageInfo = ConstructionUtil.getConstructionStageInfo(salvagedBuilding.getName());
        if (buildingStageInfo == null) throw new IllegalStateException("Could not find building construction stage for building: " + salvagedBuilding.getName());
        String frameName = buildingStageInfo.getPrerequisiteStage();
        ConstructionStageInfo frameStageInfo = ConstructionUtil.getConstructionStageInfo(frameName);
        if (frameStageInfo == null) throw new IllegalStateException("Could not find frame construction stage for building: " + salvagedBuilding.getName());
        String foundationName = frameStageInfo.getPrerequisiteStage();
        ConstructionStageInfo foundationStageInfo = ConstructionUtil.getConstructionStageInfo(foundationName);
        if (foundationStageInfo == null) {
            throw new IllegalStateException("Could not find foundation construction stage for building: " + salvagedBuilding.getName());
        }
        ConstructionStage foundationStage = new ConstructionStage(foundationStageInfo, site);
        foundationStage.setCompletedWorkTime(foundationStageInfo.getWorkTime());
        site.addNewStage(foundationStage);
        ConstructionStage frameStage = new ConstructionStage(frameStageInfo, site);
        frameStage.setCompletedWorkTime(frameStageInfo.getWorkTime());
        site.addNewStage(frameStage);
        ConstructionStage buildingStage = new ConstructionStage(buildingStageInfo, site);
        buildingStage.setSalvaging(true);
        site.addNewStage(buildingStage);
        this.values.clearCache();
        return site;
    }

    public void destroy() {
        this.settlement = null;
        this.sites.clear();
        this.sites = null;
        this.values.destroy();
        this.values = null;
        this.salvageValues.destroy();
        this.salvageValues = null;
        this.constructedBuildingLog.clear();
        this.constructedBuildingLog = null;
    }
}

