/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.BuildingManager;
import org.mars_sim.msp.core.structure.construction.ConstructionEvent;
import org.mars_sim.msp.core.structure.construction.ConstructionListener;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.time.MarsClock;

public class ConstructionSite
implements Serializable,
LocalBoundedObject {
    public static final String START_UNDERGOING_CONSTRUCTION_EVENT = "start undergoing construction";
    public static final String END_UNDERGOING_CONSTRUCTION_EVENT = "end undergoing construction";
    public static final String START_UNDERGOING_SALVAGE_EVENT = "start undergoing salvage";
    public static final String END_UNDERGOING_SALVAGE_EVENT = "end undergoing salvage";
    public static final String ADD_CONSTRUCTION_STAGE_EVENT = "adding construction stage";
    public static final String REMOVE_CONSTRUCTION_STAGE_EVENT = "removing construction stage";
    public static final String CREATE_BUILDING_EVENT = "creating new building";
    public static final String REMOVE_BUILDING_EVENT = "removing old building";
    private double width = 0.0;
    private double length = 0.0;
    private double xLocation = 0.0;
    private double yLocation = 0.0;
    private double facing = 0.0;
    private ConstructionStage foundationStage = null;
    private ConstructionStage frameStage = null;
    private ConstructionStage buildingStage = null;
    private boolean undergoingConstruction = false;
    private boolean undergoingSalvage = false;
    private transient List<ConstructionListener> listeners = Collections.synchronizedList(new ArrayList());

    ConstructionSite() {
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public double getXLocation() {
        return this.xLocation;
    }

    public void setXLocation(double xLocation) {
        this.xLocation = xLocation;
    }

    @Override
    public double getYLocation() {
        return this.yLocation;
    }

    public void setYLocation(double yLocation) {
        this.yLocation = yLocation;
    }

    @Override
    public double getFacing() {
        return this.facing;
    }

    public void setFacing(double facing) {
        this.facing = facing;
    }

    public boolean isAllConstructionComplete() {
        if (this.buildingStage != null && !this.undergoingSalvage) {
            return this.buildingStage.isComplete();
        }
        return false;
    }

    public boolean isAllSalvageComplete() {
        if (this.undergoingSalvage) {
            if (this.foundationStage == null) {
                return true;
            }
            return this.foundationStage.isComplete();
        }
        return false;
    }

    public boolean isUndergoingConstruction() {
        return this.undergoingConstruction;
    }

    public boolean isUndergoingSalvage() {
        return this.undergoingSalvage;
    }

    public void setUndergoingConstruction(boolean undergoingConstruction) {
        this.undergoingConstruction = undergoingConstruction;
        if (undergoingConstruction) {
            this.fireConstructionUpdate(START_UNDERGOING_CONSTRUCTION_EVENT);
        } else {
            this.fireConstructionUpdate(END_UNDERGOING_CONSTRUCTION_EVENT);
        }
    }

    public void setUndergoingSalvage(boolean undergoingSalvage) {
        this.undergoingSalvage = undergoingSalvage;
        if (undergoingSalvage) {
            this.fireConstructionUpdate(START_UNDERGOING_SALVAGE_EVENT);
        } else {
            this.fireConstructionUpdate(END_UNDERGOING_SALVAGE_EVENT);
        }
    }

    public ConstructionStage getCurrentConstructionStage() {
        ConstructionStage result = null;
        if (this.buildingStage != null) {
            result = this.buildingStage;
        } else if (this.frameStage != null) {
            result = this.frameStage;
        } else if (this.foundationStage != null) {
            result = this.foundationStage;
        }
        return result;
    }

    public String getNextStageType() {
        String result = null;
        result = this.buildingStage != null ? null : (this.frameStage != null ? "building" : (this.foundationStage != null ? "frame" : "foundation"));
        return result;
    }

    public void addNewStage(ConstructionStage stage) {
        if ("foundation".equals(stage.getInfo().getType())) {
            if (this.foundationStage != null) {
                throw new IllegalStateException("Foundation stage already exists.");
            }
            this.foundationStage = stage;
        } else if ("frame".equals(stage.getInfo().getType())) {
            if (this.frameStage != null) {
                throw new IllegalStateException("Frame stage already exists");
            }
            if (this.foundationStage == null) {
                throw new IllegalStateException("Foundation stage hasn't been added yet.");
            }
            this.frameStage = stage;
        } else if ("building".equals(stage.getInfo().getType())) {
            if (this.buildingStage != null) {
                throw new IllegalStateException("Building stage already exists");
            }
            if (this.frameStage == null) {
                throw new IllegalStateException("Frame stage hasn't been added yet.");
            }
            this.buildingStage = stage;
        } else {
            throw new IllegalStateException("Stage type: " + stage.getInfo().getType() + " not valid");
        }
        this.updateDimensions(stage);
        this.fireConstructionUpdate(ADD_CONSTRUCTION_STAGE_EVENT, stage);
    }

    private void updateDimensions(ConstructionStage stage) {
        if (!stage.getInfo().isUnsetDimensions()) {
            if (stage.getInfo().getWidth() != this.width) {
                this.width = stage.getInfo().getWidth();
            }
            if (stage.getInfo().getLength() != this.length) {
                this.length = stage.getInfo().getLength();
            }
        }
    }

    public void removeSalvagedStage(ConstructionStage stage) {
        if ("building".equals(stage.getInfo().getType())) {
            this.buildingStage = null;
        } else if ("frame".equals(stage.getInfo().getType())) {
            this.frameStage = null;
        } else if ("foundation".equals(stage.getInfo().getType())) {
            this.foundationStage = null;
        } else {
            throw new IllegalStateException("Stage type: " + stage.getInfo().getType() + " not valid");
        }
        this.fireConstructionUpdate(REMOVE_CONSTRUCTION_STAGE_EVENT, stage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeSalvagedStage() {
        if (!this.undergoingSalvage) throw new IllegalStateException("Construction site is not undergoing salvage");
        if (this.buildingStage != null) {
            this.buildingStage = null;
            return;
        } else if (this.frameStage != null) {
            this.frameStage = null;
            return;
        } else {
            if (this.foundationStage == null) throw new IllegalStateException("Construction site has no stage to remove");
            this.foundationStage = null;
        }
    }

    public Building createBuilding(BuildingManager manager) {
        if (this.buildingStage == null) {
            throw new IllegalStateException("Building stage doesn't exist");
        }
        Building newBuilding = new Building(this.buildingStage.getInfo().getName(), this.xLocation, this.yLocation, this.facing, manager);
        manager.addBuilding(newBuilding);
        ConstructionManager constructionManager = manager.getSettlement().getConstructionManager();
        MarsClock timeStamp = (MarsClock)Simulation.instance().getMasterClock().getMarsClock().clone();
        constructionManager.addConstructedBuildingLogEntry(this.buildingStage.getInfo().getName(), timeStamp);
        constructionManager.getConstructionValues().clearCache();
        this.fireConstructionUpdate(CREATE_BUILDING_EVENT, newBuilding);
        return newBuilding;
    }

    public String getBuildingName() {
        if (this.buildingStage != null) {
            return this.buildingStage.getInfo().getName();
        }
        return null;
    }

    public boolean hasUnfinishedStage() {
        ConstructionStage currentStage = this.getCurrentConstructionStage();
        return currentStage != null && !currentStage.isComplete();
    }

    public boolean hasStage(ConstructionStageInfo stage) {
        if (stage == null) {
            throw new IllegalArgumentException("stage cannot be null");
        }
        boolean result = false;
        if (this.foundationStage != null && this.foundationStage.getInfo().equals(stage)) {
            result = true;
        } else if (this.frameStage != null && this.frameStage.getInfo().equals(stage)) {
            result = true;
        } else if (this.buildingStage != null && this.buildingStage.getInfo().equals(stage)) {
            result = true;
        }
        return result;
    }

    public final void addConstructionListener(ConstructionListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public final void removeConstructionListener(ConstructionListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    final void fireConstructionUpdate(String updateType) {
        this.fireConstructionUpdate(updateType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireConstructionUpdate(String updateType, Object target) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        List<ConstructionListener> list = this.listeners;
        synchronized (list) {
            Iterator<ConstructionListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().constructionUpdate(new ConstructionEvent(this, updateType, target));
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Site");
        ConstructionStage stage = this.getCurrentConstructionStage();
        if (stage != null) {
            result.append(": ").append(stage.getInfo().getName());
            if (this.undergoingConstruction) {
                result.append(" - under construction");
            } else if (this.undergoingSalvage) {
                result.append(" - under salvage");
            } else if (this.hasUnfinishedStage()) {
                if (stage.isSalvaging()) {
                    result.append(" - salvage unfinished");
                } else {
                    result.append(" - construction unfinished");
                }
            }
        }
        return result.toString();
    }
}

