/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.structure.construction.ConstructionConfig;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;

public class ConstructionUtil {
    private ConstructionUtil() {
    }

    public static ConstructionStageInfo getConstructionStageInfo(String stageName) {
        ConstructionStageInfo result = null;
        for (ConstructionStageInfo stageInfo : ConstructionUtil.getAllConstructionStageInfoList()) {
            if (!stageInfo.getName().equalsIgnoreCase(stageName.trim())) continue;
            result = stageInfo;
        }
        return result;
    }

    public static List<ConstructionStageInfo> getConstructionStageInfoList(String stageType) {
        return ConstructionUtil.getConstructionStageInfoList(stageType, Integer.MAX_VALUE);
    }

    public static List<ConstructionStageInfo> getConstructionStageInfoList(String stageType, int constructionSkill) {
        ConstructionConfig config = SimulationConfig.instance().getConstructionConfiguration();
        ArrayList<ConstructionStageInfo> result = new ArrayList<ConstructionStageInfo>(config.getConstructionStageInfoList(stageType));
        Iterator i = result.iterator();
        while (i.hasNext()) {
            if (((ConstructionStageInfo)i.next()).getArchitectConstructionSkill() <= constructionSkill) continue;
            i.remove();
        }
        return result;
    }

    public static List<ConstructionStageInfo> getFoundationConstructionStageInfoList() {
        return ConstructionUtil.getFoundationConstructionStageInfoList(Integer.MAX_VALUE);
    }

    public static List<ConstructionStageInfo> getFoundationConstructionStageInfoList(int constructionSkill) {
        return ConstructionUtil.getConstructionStageInfoList("foundation", constructionSkill);
    }

    public static List<ConstructionStageInfo> getFrameConstructionStageInfoList() {
        return ConstructionUtil.getFrameConstructionStageInfoList(Integer.MAX_VALUE);
    }

    public static List<ConstructionStageInfo> getFrameConstructionStageInfoList(int constructionSkill) {
        return ConstructionUtil.getConstructionStageInfoList("frame", constructionSkill);
    }

    public static List<ConstructionStageInfo> getBuildingConstructionStageInfoList() {
        return ConstructionUtil.getBuildingConstructionStageInfoList(Integer.MAX_VALUE);
    }

    public static List<ConstructionStageInfo> getBuildingConstructionStageInfoList(int constructionSkill) {
        return ConstructionUtil.getConstructionStageInfoList("building", constructionSkill);
    }

    public static List<ConstructionStageInfo> getAllConstructionStageInfoList() {
        ConstructionConfig config = SimulationConfig.instance().getConstructionConfiguration();
        List<ConstructionStageInfo> foundations = config.getConstructionStageInfoList("foundation");
        List<ConstructionStageInfo> frames = config.getConstructionStageInfoList("frame");
        List<ConstructionStageInfo> buildings = config.getConstructionStageInfoList("building");
        int resultSize = foundations.size() + frames.size() + buildings.size();
        ArrayList<ConstructionStageInfo> result = new ArrayList<ConstructionStageInfo>(resultSize);
        result.addAll(foundations);
        result.addAll(frames);
        result.addAll(buildings);
        return result;
    }

    public static List<String> getConstructableBuildingNames(ConstructionStageInfo stageInfo) {
        ArrayList<String> result = new ArrayList<String>();
        if ("foundation".equals(stageInfo.getType())) {
            Iterator<ConstructionStageInfo> i = ConstructionUtil.getNextPossibleStages(stageInfo).iterator();
            while (i.hasNext()) {
                result.addAll(ConstructionUtil.getConstructableBuildingNames(i.next()));
            }
        } else if ("frame".equals(stageInfo.getType())) {
            Iterator<ConstructionStageInfo> i = ConstructionUtil.getNextPossibleStages(stageInfo).iterator();
            while (i.hasNext()) {
                result.add(i.next().getName());
            }
        } else if ("building".equals(stageInfo.getType())) {
            result.add(stageInfo.getName());
        } else {
            throw new IllegalStateException("Unknown stage type: " + stageInfo.getType());
        }
        return result;
    }

    public static List<ConstructionStageInfo> getNextPossibleStages(ConstructionStageInfo stageInfo) {
        ArrayList<ConstructionStageInfo> result = new ArrayList<ConstructionStageInfo>();
        String nextStageName = null;
        if ("foundation".equals(stageInfo.getType())) {
            nextStageName = "frame";
        } else if ("frame".equals(stageInfo.getType())) {
            nextStageName = "building";
        }
        if (nextStageName != null) {
            ConstructionConfig config = SimulationConfig.instance().getConstructionConfiguration();
            for (ConstructionStageInfo buildingStage : config.getConstructionStageInfoList(nextStageName)) {
                if (!stageInfo.getName().equals(buildingStage.getPrerequisiteStage()) || !buildingStage.isConstructable()) continue;
                result.add(buildingStage);
            }
        }
        return result;
    }

    public static ConstructionStageInfo getPrerequisiteStage(ConstructionStageInfo stageInfo) {
        ConstructionStageInfo result = null;
        String prerequisiteStageName = stageInfo.getPrerequisiteStage();
        if (prerequisiteStageName != null) {
            for (ConstructionStageInfo info : ConstructionUtil.getAllConstructionStageInfoList()) {
                if (!info.getName().equals(prerequisiteStageName)) continue;
                result = info;
            }
        }
        return result;
    }
}

