/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.construction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.construction.ConstructionManager;
import org.mars_sim.msp.core.structure.construction.ConstructionSite;
import org.mars_sim.msp.core.structure.construction.ConstructionStage;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsManager;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;

public class ConstructionValues
implements Serializable {
    public static final double LOWER_STAGE_VALUE_MODIFIER = 0.75;
    private Settlement settlement;
    private Map<Integer, Double> settlementConstructionValueCache;
    private MarsClock settlementConstructionValueCacheTime;
    private Map<ConstructionStageInfo, Double> stageInfoValueCache;
    private MarsClock stageInfoValueCacheTime;
    private Map<ConstructionStageInfo, Double> allStageInfoValueCache;
    private MarsClock allStageInfoValueCacheTime;

    ConstructionValues(Settlement settlement) {
        this.settlement = settlement;
    }

    public double getSettlementConstructionProfit() {
        return this.getSettlementConstructionProfit(Integer.MAX_VALUE);
    }

    public double getSettlementConstructionProfit(int constructionSkill) {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.settlementConstructionValueCacheTime == null || MarsClock.getTimeDiff(currentTime, this.settlementConstructionValueCacheTime) > 1000.0) {
            if (this.settlementConstructionValueCache == null) {
                this.settlementConstructionValueCache = new HashMap<Integer, Double>();
            }
            this.settlementConstructionValueCache.clear();
            this.settlementConstructionValueCacheTime = (MarsClock)currentTime.clone();
        }
        if (!this.settlementConstructionValueCache.containsKey(constructionSkill)) {
            double newSiteProfit;
            double profit = 0.0;
            double existingSitesProfit = this.getAllConstructionSitesProfit(constructionSkill);
            if (existingSitesProfit > profit) {
                profit = existingSitesProfit;
            }
            if ((newSiteProfit = this.getNewConstructionSiteProfit(constructionSkill)) > profit) {
                profit = newSiteProfit;
            }
            this.settlementConstructionValueCache.put(constructionSkill, profit);
        }
        return this.settlementConstructionValueCache.get(constructionSkill);
    }

    public double getAllConstructionSitesProfit(int constructionSkill) {
        double result = 0.0;
        ConstructionManager manager = this.settlement.getConstructionManager();
        Iterator<ConstructionSite> i = manager.getConstructionSitesNeedingConstructionMission().iterator();
        while (i.hasNext()) {
            double profit = this.getConstructionSiteProfit(i.next(), constructionSkill);
            if (!(profit > result)) continue;
            result = profit;
        }
        return result;
    }

    public double getConstructionSiteProfit(ConstructionSite site) {
        return this.getConstructionSiteProfit(site, Integer.MAX_VALUE);
    }

    public double getConstructionSiteProfit(ConstructionSite site, int constructionSkill) {
        double result = 0.0;
        if (!site.isUndergoingConstruction()) {
            if (site.hasUnfinishedStage()) {
                ConstructionStage stage = site.getCurrentConstructionStage();
                if (stage.getInfo().getArchitectConstructionSkill() <= constructionSkill) {
                    result = this.getConstructionStageValue(stage.getInfo());
                }
            } else {
                List<ConstructionStageInfo> nextStageInfos = null;
                ConstructionStage lastStage = site.getCurrentConstructionStage();
                nextStageInfos = lastStage != null ? ConstructionUtil.getNextPossibleStages(lastStage.getInfo()) : ConstructionUtil.getConstructionStageInfoList("foundation", constructionSkill);
                if (nextStageInfos != null) {
                    for (ConstructionStageInfo stageInfo : nextStageInfos) {
                        double profit = this.getConstructionStageProfit(stageInfo, true);
                        if (!(profit > result)) continue;
                        result = profit;
                    }
                }
            }
        }
        return result;
    }

    public double getNewConstructionSiteProfit(int constructionSkill) {
        double result = 0.0;
        Map<ConstructionStageInfo, Double> stageProfits = this.getConstructionStageProfit("foundation", constructionSkill, true);
        for (ConstructionStageInfo foundationStage : stageProfits.keySet()) {
            double profit = stageProfits.get(foundationStage);
            int numSites = 0;
            ConstructionManager manager = this.settlement.getConstructionManager();
            Iterator<ConstructionSite> j = manager.getConstructionSites().iterator();
            while (j.hasNext()) {
                if (!j.next().hasStage(foundationStage)) continue;
                ++numSites;
            }
            if (!((profit /= (double)numSites * 10.0 + 1.0) > result)) continue;
            result = profit;
        }
        return result;
    }

    public Map<ConstructionStageInfo, Double> getNewConstructionStageProfits(ConstructionSite site, int constructionSkill) {
        HashMap<ConstructionStageInfo, Double> result = new HashMap();
        ConstructionStage lastStage = site.getCurrentConstructionStage();
        if (lastStage != null) {
            ConstructionStageInfo lastStageInfo = lastStage.getInfo();
            for (ConstructionStageInfo stageInfo : ConstructionUtil.getNextPossibleStages(lastStageInfo)) {
                double profit = this.getConstructionStageProfit(stageInfo, true);
                result.put(stageInfo, profit);
            }
        } else {
            result = this.getConstructionStageProfit("foundation", constructionSkill, true);
        }
        return result;
    }

    public Map<ConstructionStageInfo, Double> getConstructionStageProfit(String stageType, int constructionSkill, boolean checkMaterials) {
        HashMap<ConstructionStageInfo, Double> result = new HashMap<ConstructionStageInfo, Double>();
        List<ConstructionStageInfo> nextStages = ConstructionUtil.getConstructionStageInfoList(stageType, constructionSkill);
        for (ConstructionStageInfo stageInfo : nextStages) {
            double profit = this.getConstructionStageProfit(stageInfo, checkMaterials);
            result.put(stageInfo, profit);
        }
        return result;
    }

    public Map<ConstructionStageInfo, Double> getAllConstructionStageValues() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.allStageInfoValueCacheTime == null || MarsClock.getTimeDiff(currentTime, this.allStageInfoValueCacheTime) > 1000.0) {
            if (this.allStageInfoValueCache == null) {
                this.allStageInfoValueCache = new HashMap<ConstructionStageInfo, Double>();
            }
            this.allStageInfoValueCache.clear();
            for (ConstructionStageInfo stageInfo : ConstructionUtil.getAllConstructionStageInfoList()) {
                this.allStageInfoValueCache.put(stageInfo, this.getConstructionStageValue(stageInfo));
            }
            this.allStageInfoValueCacheTime = (MarsClock)currentTime.clone();
        }
        return this.allStageInfoValueCache;
    }

    public double getConstructionStageValue(ConstructionStageInfo stageInfo) {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.stageInfoValueCacheTime == null || MarsClock.getTimeDiff(currentTime, this.stageInfoValueCacheTime) > 1000.0) {
            if (this.stageInfoValueCache == null) {
                this.stageInfoValueCache = new HashMap<ConstructionStageInfo, Double>();
            }
            this.stageInfoValueCache.clear();
            this.stageInfoValueCacheTime = (MarsClock)currentTime.clone();
        }
        if (!this.stageInfoValueCache.containsKey(stageInfo)) {
            double result = 0.0;
            if ("building".equals(stageInfo.getType())) {
                result = this.getBuildingConstructionValue(stageInfo.getName());
            } else {
                for (ConstructionStageInfo nextStageInfo : ConstructionUtil.getNextPossibleStages(stageInfo)) {
                    double stageValue = this.getConstructionStageProfit(nextStageInfo, true) * 0.75;
                    if (!(stageValue > result)) continue;
                    result = stageValue;
                }
            }
            this.stageInfoValueCache.put(stageInfo, result);
        }
        return this.stageInfoValueCache.get(stageInfo);
    }

    private double getConstructionStageCost(ConstructionStageInfo stageInfo) {
        double cost = 0.0;
        GoodsManager manager = this.settlement.getGoodsManager();
        Map<AmountResource, Double> resources = stageInfo.getResources();
        for (AmountResource resource : resources.keySet()) {
            Good resourceGood = GoodsUtil.getResourceGood(resource);
            double amount = resources.get(resource);
            double value = manager.getGoodValuePerItem(resourceGood) * amount;
            cost += value;
        }
        Map<Part, Integer> parts = stageInfo.getParts();
        for (Part part : parts.keySet()) {
            Good partGood = GoodsUtil.getResourceGood(part);
            int number = parts.get(part);
            double value = manager.getGoodValuePerItem(partGood) * (double)number;
            cost += value;
        }
        return cost;
    }

    private double getConstructionStageProfit(ConstructionStageInfo stageInfo, boolean checkMaterials) {
        double result = this.getConstructionStageValue(stageInfo) - this.getConstructionStageCost(stageInfo);
        if (checkMaterials && !this.hasConstructionMaterials(stageInfo)) {
            result = 0.0;
        }
        return result;
    }

    private double getBuildingConstructionValue(String buildingName) {
        return this.settlement.getBuildingManager().getBuildingValue(buildingName, true);
    }

    private boolean hasConstructionMaterials(ConstructionStageInfo stageInfo) {
        boolean result = true;
        Map<AmountResource, Double> resources = stageInfo.getResources();
        for (AmountResource resource : resources.keySet()) {
            double amount = resources.get(resource);
            double stored = this.settlement.getInventory().getAmountResourceStored(resource, false);
            if (!(stored < amount)) continue;
            result = false;
            break;
        }
        Map<Part, Integer> parts = stageInfo.getParts();
        for (Part part : parts.keySet()) {
            int number = parts.get(part);
            int stored = this.settlement.getInventory().getItemResourceNum(part);
            if (stored >= number) continue;
            result = false;
            break;
        }
        return result;
    }

    public void clearCache() {
        MarsClock currentTime = Simulation.instance().getMasterClock().getMarsClock();
        if (this.settlementConstructionValueCache == null) {
            this.settlementConstructionValueCache = new HashMap<Integer, Double>();
        }
        this.settlementConstructionValueCache.clear();
        this.settlementConstructionValueCacheTime = (MarsClock)currentTime.clone();
        if (this.stageInfoValueCache == null) {
            this.stageInfoValueCache = new HashMap<ConstructionStageInfo, Double>();
        }
        this.stageInfoValueCache.clear();
        this.stageInfoValueCacheTime = (MarsClock)currentTime.clone();
        if (this.allStageInfoValueCache == null) {
            this.allStageInfoValueCache = new HashMap<ConstructionStageInfo, Double>();
        }
        this.allStageInfoValueCache.clear();
    }

    public void destroy() {
        this.settlement = null;
        if (this.settlementConstructionValueCache != null) {
            this.settlementConstructionValueCache.clear();
            this.settlementConstructionValueCache = null;
            this.settlementConstructionValueCacheTime = null;
        }
        if (this.stageInfoValueCache != null) {
            this.stageInfoValueCache.clear();
            this.stageInfoValueCache = null;
            this.stageInfoValueCacheTime = null;
        }
        if (this.allStageInfoValueCache != null) {
            this.allStageInfoValueCache.clear();
            this.allStageInfoValueCache = null;
            this.allStageInfoValueCacheTime = null;
        }
    }
}

