/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.goods;

import com.phoenixst.plexus.DefaultGraph;
import com.phoenixst.plexus.EdgePredicate;
import com.phoenixst.plexus.EdgePredicateFactory;
import com.phoenixst.plexus.Graph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.goods.CreditEvent;
import org.mars_sim.msp.core.structure.goods.CreditListener;

public class CreditManager
implements Serializable {
    private Graph creditGraph = new DefaultGraph();
    private transient List<CreditListener> listeners;

    public CreditManager() {
        this(Simulation.instance().getUnitManager().getSettlements());
    }

    public CreditManager(Collection<Settlement> settlements) {
        Iterator<Settlement> i = settlements.iterator();
        while (i.hasNext()) {
            this.creditGraph.addNode((Object)i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredit(Settlement settlement1, Settlement settlement2, double amount) {
        if (!this.creditGraph.containsNode((Object)settlement1)) {
            throw new IllegalArgumentException("settlement: " + settlement1 + " is invalid");
        }
        if (!this.creditGraph.containsNode((Object)settlement2)) {
            throw new IllegalArgumentException("settlement: " + settlement2 + " is invalid");
        }
        EdgePredicate edgePredicate = EdgePredicateFactory.createEqualsNodes((Object)settlement1, (Object)settlement2, (int)7);
        Graph.Edge existingEdge = this.creditGraph.getEdge((Predicate)edgePredicate);
        if (existingEdge != null) {
            this.creditGraph.removeEdge(existingEdge);
        }
        if (amount >= 0.0) {
            this.creditGraph.addEdge((Object)Math.abs(amount), (Object)settlement1, (Object)settlement2, true);
        } else {
            this.creditGraph.addEdge((Object)Math.abs(amount), (Object)settlement2, (Object)settlement1, true);
        }
        List<CreditListener> list = this.getListeners();
        synchronized (list) {
            Iterator<CreditListener> i = this.getListeners().iterator();
            while (i.hasNext()) {
                i.next().creditUpdate(new CreditEvent(settlement1, settlement2, amount));
            }
        }
    }

    public double getCredit(Settlement settlement1, Settlement settlement2) {
        double result = 0.0;
        EdgePredicate edgePredicate = EdgePredicateFactory.createEqualsNodes((Object)settlement1, (Object)settlement2, (int)7);
        Graph.Edge existingEdge = this.creditGraph.getEdge((Predicate)edgePredicate);
        if (existingEdge != null) {
            result = (Double)existingEdge.getUserObject();
            if (existingEdge.getHead() == settlement1) {
                result *= -1.0;
            }
        }
        return result;
    }

    public void addSettlement(Settlement newSettlement) {
        if (newSettlement == null) {
            throw new IllegalArgumentException("Settlement is null");
        }
        if (this.creditGraph.containsNode((Object)newSettlement)) {
            throw new IllegalArgumentException("Settlement: " + newSettlement + " already exists in credit graph.");
        }
        this.creditGraph.addNode((Object)newSettlement);
    }

    private List<CreditListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        return this.listeners;
    }

    public void addListener(CreditListener newListener) {
        if (!this.getListeners().contains(newListener)) {
            this.getListeners().add(newListener);
        }
    }

    public void removeListener(CreditListener oldListener) {
        if (this.getListeners().contains(oldListener)) {
            this.getListeners().remove(oldListener);
        }
    }

    public void destroy() {
        this.creditGraph = null;
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }
}

