/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.structure.goods;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.equipment.Bag;
import org.mars_sim.msp.core.equipment.Container;
import org.mars_sim.msp.core.equipment.EVASuit;
import org.mars_sim.msp.core.equipment.Equipment;
import org.mars_sim.msp.core.equipment.SpecimenContainer;
import org.mars_sim.msp.core.malfunction.Malfunction;
import org.mars_sim.msp.core.malfunction.MalfunctionFactory;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.manufacture.ManufactureProcessInfo;
import org.mars_sim.msp.core.manufacture.ManufactureProcessItem;
import org.mars_sim.msp.core.manufacture.ManufactureUtil;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.person.ai.job.Architect;
import org.mars_sim.msp.core.person.ai.job.Areologist;
import org.mars_sim.msp.core.person.ai.job.Biologist;
import org.mars_sim.msp.core.person.ai.job.Driver;
import org.mars_sim.msp.core.person.ai.job.Trader;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.MissionManager;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.ItemResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.Farming;
import org.mars_sim.msp.core.structure.building.function.ResourceProcess;
import org.mars_sim.msp.core.structure.building.function.ResourceProcessing;
import org.mars_sim.msp.core.structure.construction.ConstructionStageInfo;
import org.mars_sim.msp.core.structure.construction.ConstructionUtil;
import org.mars_sim.msp.core.structure.construction.ConstructionValues;
import org.mars_sim.msp.core.structure.goods.Good;
import org.mars_sim.msp.core.structure.goods.GoodsUtil;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleConfig;

public class GoodsManager
implements Serializable {
    public static final String GOODS_VALUE_EVENT = "goods values";
    private static final String TRAVEL_TO_SETTLEMENT_MISSION = "travel to settlement";
    private static final String EXPLORATION_MISSION = "exploration";
    private static final String COLLECT_ICE_MISSION = "collect ice";
    private static final String RESCUE_SALVAGE_MISSION = "rescue/salvage mission";
    private static final String TRADE_MISSION = "trade";
    private static final String COLLECT_REGOLITH_MISSION = "collect regolith";
    private static final String MINING_MISSION = "mining";
    private static final String CONSTRUCTION_MISSION = "construction";
    private static final String AREOLOGY_STUDY_FIELD_MISSION = "areology field study";
    private static final String BIOLOGY_STUDY_FIELD_MISSION = "biology field study";
    private static final int OUTSTANDING_REPAIR_PART_MODIFIER = 100;
    private static final int OUTSTANDING_MAINT_PART_MODIFIER = 10;
    private static final double EVA_SUIT_FACTOR = 100.0;
    private static final double VEHICLE_FACTOR = 10000.0;
    private static final double LIFE_SUPPORT_FACTOR = 4.0;
    private static final double VEHICLE_FUEL_FACTOR = 10.0;
    private static final double RESOURCE_PROCESSING_INPUT_FACTOR = 0.75;
    private static final double MANUFACTURING_INPUT_FACTOR = 0.75;
    private static final double CONSTRUCTING_INPUT_FACTOR = 0.75;
    private Settlement settlement;
    private Map<Good, Double> goodsValues;
    private Map<Good, Double> goodsDemandCache;
    private Map<Good, Double> goodsTradeCache;
    private Map<AmountResource, Double> resourceProcessingCache;
    private Map<String, Double> vehicleBuyValueCache;
    private Map<String, Double> vehicleSellValueCache;
    private Map<Part, Double> partsDemandCache;
    private boolean initialized = false;

    public GoodsManager(Settlement settlement) {
        this.settlement = settlement;
        this.populateGoodsValues();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void populateGoodsValues() {
        List<Good> goods = GoodsUtil.getGoodsList();
        this.goodsValues = new HashMap<Good, Double>(goods.size());
        this.goodsDemandCache = new HashMap<Good, Double>(goods.size());
        this.goodsTradeCache = new HashMap<Good, Double>(goods.size());
        for (Good good : goods) {
            this.goodsValues.put(good, 0.0);
            this.goodsDemandCache.put(good, 0.0);
            this.goodsTradeCache.put(good, 0.0);
        }
        Set<AmountResource> amountResources = AmountResource.getAmountResources();
        this.resourceProcessingCache = new HashMap<AmountResource, Double>(amountResources.size());
        Iterator<AmountResource> j = amountResources.iterator();
        while (j.hasNext()) {
            this.resourceProcessingCache.put(j.next(), 0.0);
        }
        this.partsDemandCache = new HashMap<Part, Double>(ItemResource.getItemResources().size());
        this.vehicleBuyValueCache = new HashMap<String, Double>();
        this.vehicleSellValueCache = new HashMap<String, Double>();
    }

    public double getGoodValuePerItem(Good good) {
        if (this.goodsValues.containsKey(good)) {
            return this.goodsValues.get(good);
        }
        throw new IllegalArgumentException("Good: " + good + " not valid.");
    }

    public double getGoodValuePerItem(Good good, double supply) {
        if (this.goodsValues.containsKey(good)) {
            return this.determineGoodValue(good, supply, true);
        }
        throw new IllegalArgumentException("Good: " + good + " not valid.");
    }

    public void timePassing(double time) {
        this.updateGoodsValues();
    }

    public void updateGoodsValues() {
        this.partsDemandCache.clear();
        this.vehicleBuyValueCache.clear();
        this.vehicleSellValueCache.clear();
        Iterator<Good> i = this.goodsValues.keySet().iterator();
        while (i.hasNext()) {
            this.updateGoodValue(i.next(), true);
        }
        this.settlement.fireUnitUpdate(GOODS_VALUE_EVENT);
        this.initialized = true;
    }

    public void updateGoodValue(Good good, boolean collectiveUpdate) {
        if (good != null) {
            this.goodsValues.put(good, this.determineGoodValue(good, this.getNumberOfGoodForSettlement(good), false));
            if (!collectiveUpdate) {
                this.settlement.fireUnitUpdate(GOODS_VALUE_EVENT, good);
            }
        } else {
            throw new IllegalArgumentException("Good is null.");
        }
    }

    private double determineGoodValue(Good good, double supply, boolean useCache) {
        if (good != null) {
            double value = 0.0;
            if ("amount resource".equals(good.getCategory())) {
                value = this.determineAmountResourceGoodValue(good, supply, useCache);
            }
            if ("item resource".equals(good.getCategory())) {
                value = this.determineItemResourceGoodValue(good, supply, useCache);
            }
            if ("equipment".equals(good.getCategory())) {
                value = this.determineEquipmentGoodValue(good, supply, useCache);
            }
            if ("vehicle".equals(good.getCategory())) {
                value = this.determineVehicleGoodValue(good, supply, useCache);
            }
            return value;
        }
        throw new IllegalArgumentException("Good is null.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double determineAmountResourceGoodValue(Good resourceGood, double supply, boolean useCache) {
        double value = 0.0;
        supply += 1.0;
        double demand = 0.0;
        AmountResource resource = (AmountResource)resourceGood.getObject();
        if (useCache) {
            if (!this.goodsDemandCache.containsKey(resourceGood)) throw new IllegalArgumentException("Good: " + resourceGood + " not valid.");
            demand = this.goodsDemandCache.get(resourceGood);
        } else {
            double capacity;
            demand += this.getLifeSupportDemand(resource);
            demand += this.getPotableWaterUsageDemand(resource);
            demand += this.getVehicleDemand(resource);
            demand += this.getFarmingDemand(resource);
            demand += this.getResourceManufacturingDemand(resource);
            demand += this.getResourceConstructionDemand(resource);
            if ((demand += this.determineTradeDemand(resourceGood, useCache)) > (capacity = this.settlement.getInventory().getAmountResourceCapacity(resource, false))) {
                demand = capacity;
            }
            this.goodsDemandCache.put(resourceGood, demand);
        }
        value = demand / supply;
        double resourceProcessingValue = this.getResourceProcessingValue(resource, useCache);
        if (!(resourceProcessingValue > value)) return value;
        return resourceProcessingValue;
    }

    private double getLifeSupportDemand(AmountResource resource) {
        if (resource.isLifeSupport()) {
            AmountResource food;
            AmountResource water;
            double amountNeededSol = 0.0;
            PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
            AmountResource oxygen = AmountResource.findAmountResource("oxygen");
            if (resource.equals(oxygen)) {
                amountNeededSol = config.getOxygenConsumptionRate();
            }
            if (resource.equals(water = AmountResource.findAmountResource("water"))) {
                amountNeededSol = config.getWaterConsumptionRate();
            }
            if (resource.equals(food = AmountResource.findAmountResource("food"))) {
                amountNeededSol = config.getFoodConsumptionRate();
            }
            double amountNeededOrbit = amountNeededSol * 668.0;
            int numPeople = this.settlement.getAllAssociatedPeople().size();
            return (double)numPeople * amountNeededOrbit * 4.0;
        }
        return 0.0;
    }

    private double getPotableWaterUsageDemand(AmountResource resource) {
        AmountResource water = AmountResource.findAmountResource("water");
        if (resource.equals(water)) {
            double amountNeededSol = 26.0;
            double amountNeededOrbit = amountNeededSol * 668.0;
            int numPeople = this.settlement.getCurrentPopulationNum();
            return (double)numPeople * amountNeededOrbit * 4.0;
        }
        return 0.0;
    }

    private double getVehicleDemand(AmountResource resource) {
        double demand = 0.0;
        AmountResource methane = AmountResource.findAmountResource("methane");
        if (resource.isLifeSupport() || resource.equals(methane)) {
            Iterator<Vehicle> i = this.getAssociatedVehicles().iterator();
            while (i.hasNext()) {
                double fuelDemand = i.next().getInventory().getAmountResourceCapacity(resource, false);
                demand += fuelDemand * 10.0;
            }
        }
        return demand;
    }

    private Collection<Vehicle> getAssociatedVehicles() {
        Collection<Vehicle> vehicles = this.settlement.getParkedVehicles();
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(this.settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || vehicles.contains(vehicle)) continue;
            vehicles.add(vehicle);
        }
        return vehicles;
    }

    private double getFarmingDemand(AmountResource resource) {
        double demand = 0.0;
        AmountResource wasteWater = AmountResource.findAmountResource("waste water");
        AmountResource carbonDioxide = AmountResource.findAmountResource("carbon dioxide");
        AmountResource food = AmountResource.findAmountResource("food");
        if (resource.equals(wasteWater) || resource.equals(carbonDioxide)) {
            double foodValue = this.getGoodValuePerItem(GoodsUtil.getResourceGood(food));
            for (Building building : this.settlement.getBuildingManager().getBuildings()) {
                if (!building.hasFunction("Farming")) continue;
                Farming farm = (Farming)building.getFunction("Farming");
                double amountNeeded = 0.0;
                if (resource.equals(wasteWater)) {
                    amountNeeded = 5.0;
                } else if (resource.equals(carbonDioxide)) {
                    amountNeeded = 2.0;
                }
                demand += farm.getEstimatedHarvestPerOrbit() * foodValue / amountNeeded;
            }
        }
        return demand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getResourceProcessingValue(AmountResource resource, boolean useProcessingCache) {
        double value = 0.0;
        if (useProcessingCache) {
            if (!this.resourceProcessingCache.containsKey(resource)) throw new IllegalArgumentException("Amount Resource: " + resource + " not valid.");
            return this.resourceProcessingCache.get(resource);
        }
        for (ResourceProcess process : this.getResourceProcesses()) {
            double processValue = this.getResourceProcessValue(process, resource);
            if (!(processValue > value)) continue;
            value = processValue;
        }
        this.resourceProcessingCache.put(resource, value);
        return value;
    }

    private double getResourceProcessValue(ResourceProcess process, AmountResource resource) {
        double value = 0.0;
        Set<AmountResource> inputResources = process.getInputResources();
        Set<AmountResource> outputResources = process.getOutputResources();
        if (inputResources.contains(resource) && !process.isAmbientInputResource(resource)) {
            double outputValue = 0.0;
            for (AmountResource output : outputResources) {
                double outputRate = process.getMaxOutputResourceRate(output);
                if (process.isWasteOutputResource(resource)) continue;
                outputValue += this.getGoodValuePerItem(GoodsUtil.getResourceGood(output)) * outputRate;
            }
            double totalInputRate = 0.0;
            for (AmountResource inputResource : process.getInputResources()) {
                if (process.isAmbientInputResource(inputResource)) continue;
                totalInputRate += process.getMaxInputResourceRate(inputResource);
            }
            double resourceRate = process.getMaxInputResourceRate(resource);
            double totalInputsValue = outputValue * 0.75;
            value = resourceRate / totalInputRate * totalInputsValue;
        }
        return value;
    }

    private List<ResourceProcess> getResourceProcesses() {
        ArrayList<ResourceProcess> processes = new ArrayList<ResourceProcess>(0);
        for (Building building : this.settlement.getBuildingManager().getBuildings()) {
            if (!building.hasFunction("Resource Processing")) continue;
            ResourceProcessing processing = (ResourceProcessing)building.getFunction("Resource Processing");
            processes.addAll(processing.getProcesses());
        }
        return processes;
    }

    private double getResourceManufacturingDemand(AmountResource resource) {
        double demand = 0.0;
        if (ManufactureUtil.doesSettlementHaveManufacturing(this.settlement)) {
            int techLevel = ManufactureUtil.getHighestManufacturingTechLevel(this.settlement);
            Iterator<ManufactureProcessInfo> i = ManufactureUtil.getManufactureProcessesForTechLevel(techLevel).iterator();
            while (i.hasNext()) {
                double manufacturingDemand = this.getResourceManufacturingProcessDemand(resource, i.next());
                demand += manufacturingDemand;
            }
        }
        return demand;
    }

    private double getResourceManufacturingProcessDemand(AmountResource resource, ManufactureProcessInfo process) {
        double demand = 0.0;
        ManufactureProcessItem resourceInput = null;
        for (ManufactureProcessItem item : process.getInputList()) {
            if (!"resource".equalsIgnoreCase(item.getType()) || !resource.getName().equalsIgnoreCase(item.getName())) continue;
            resourceInput = item;
            break;
        }
        if (resourceInput != null) {
            double outputsValue = 0.0;
            Iterator<ManufactureProcessItem> j = process.getOutputList().iterator();
            while (j.hasNext()) {
                outputsValue += ManufactureUtil.getManufactureProcessItemValue(j.next(), this.settlement);
            }
            double totalItems = 0.0;
            Iterator<ManufactureProcessItem> k = process.getInputList().iterator();
            while (k.hasNext()) {
                totalItems += k.next().getAmount();
            }
            double resourceItems = resourceInput.getAmount();
            double totalInputsValue = outputsValue * 0.75;
            demand = resourceItems / totalItems * totalInputsValue;
        }
        return demand;
    }

    private double getResourceConstructionDemand(AmountResource resource) {
        double demand = 0.0;
        ConstructionValues values = this.settlement.getConstructionManager().getConstructionValues();
        Map<ConstructionStageInfo, Double> stageValues = values.getAllConstructionStageValues();
        for (ConstructionStageInfo stage : stageValues.keySet()) {
            double stageValue = stageValues.get(stage);
            if (!(stageValue > 0.0) || !"building".equals(stage.getType()) || !this.isLocallyConstructable(stage)) continue;
            double constructionDemand = this.getResourceConstructionStageDemand(resource, stage, stageValue);
            demand += constructionDemand;
        }
        return demand;
    }

    private boolean isLocallyConstructable(ConstructionStageInfo buildingStage) {
        ConstructionStageInfo foundationStage;
        ConstructionStageInfo frameStage;
        boolean result = false;
        if (buildingStage.isConstructable() && (frameStage = ConstructionUtil.getPrerequisiteStage(buildingStage)) != null && (foundationStage = ConstructionUtil.getPrerequisiteStage(frameStage)) != null) {
            if (frameStage.isConstructable() && foundationStage.isConstructable()) {
                result = true;
            } else {
                Iterator<Building> i = this.settlement.getBuildingManager().getBuildings().iterator();
                while (i.hasNext()) {
                    ConstructionStageInfo tempFrameStage;
                    ConstructionStageInfo tempBuildingStage = ConstructionUtil.getConstructionStageInfo(i.next().getName());
                    if (tempBuildingStage == null || !frameStage.equals(tempFrameStage = ConstructionUtil.getPrerequisiteStage(tempBuildingStage))) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    private double getResourceConstructionStageDemand(AmountResource resource, ConstructionStageInfo stage, double stageValue) {
        double demand = 0.0;
        Map<AmountResource, Double> resources = this.getAllPrerequisiteConstructionResources(stage);
        Map<Part, Integer> parts = this.getAllPrerequisiteConstructionParts(stage);
        if (resources.containsKey(resource)) {
            double totalItems = 0.0;
            Iterator<AmountResource> i = resources.keySet().iterator();
            while (i.hasNext()) {
                totalItems += resources.get(i.next()).doubleValue();
            }
            Iterator<Part> j = parts.keySet().iterator();
            while (j.hasNext()) {
                totalItems += (double)parts.get(j.next()).intValue();
            }
            double resourceItems = resources.get(resource);
            double totalInputsValue = stageValue * 0.75;
            demand = resourceItems / totalItems * totalInputsValue;
        }
        return demand;
    }

    private Map<AmountResource, Double> getAllPrerequisiteConstructionResources(ConstructionStageInfo stage) {
        HashMap<AmountResource, Double> result = new HashMap<AmountResource, Double>(stage.getResources());
        ConstructionStageInfo preStage1 = ConstructionUtil.getPrerequisiteStage(stage);
        if (preStage1 != null && preStage1.isConstructable()) {
            for (AmountResource resource : preStage1.getResources().keySet()) {
                double amount = preStage1.getResources().get(resource);
                if (result.containsKey(resource)) {
                    double totalAmount = (Double)result.get(resource) + amount;
                    result.put(resource, totalAmount);
                    continue;
                }
                result.put(resource, amount);
            }
            ConstructionStageInfo preStage2 = ConstructionUtil.getPrerequisiteStage(preStage1);
            if (preStage2 != null && preStage2.isConstructable()) {
                for (AmountResource resource : preStage2.getResources().keySet()) {
                    double amount = preStage2.getResources().get(resource);
                    if (result.containsKey(resource)) {
                        double totalAmount = (Double)result.get(resource) + amount;
                        result.put(resource, totalAmount);
                        continue;
                    }
                    result.put(resource, amount);
                }
            }
        }
        return result;
    }

    private Map<Part, Integer> getAllPrerequisiteConstructionParts(ConstructionStageInfo stage) {
        HashMap<Part, Integer> result = new HashMap<Part, Integer>(stage.getParts());
        ConstructionStageInfo preStage1 = ConstructionUtil.getPrerequisiteStage(stage);
        if (preStage1 != null && preStage1.isConstructable()) {
            for (Part part : preStage1.getParts().keySet()) {
                int number = preStage1.getParts().get(part);
                if (result.containsKey(part)) {
                    int totalNumber = (Integer)result.get(part) + number;
                    result.put(part, totalNumber);
                    continue;
                }
                result.put(part, number);
            }
            ConstructionStageInfo preStage2 = ConstructionUtil.getPrerequisiteStage(preStage1);
            if (preStage2 != null && preStage2.isConstructable()) {
                for (Part part : preStage2.getParts().keySet()) {
                    int number = preStage2.getParts().get(part);
                    if (result.containsKey(part)) {
                        int totalNumber = (Integer)result.get(part) + number;
                        result.put(part, totalNumber);
                        continue;
                    }
                    result.put(part, number);
                }
            }
        }
        return result;
    }

    public double getNumberOfGoodForSettlement(Good good) {
        if (good != null) {
            double result = 0.0;
            if ("amount resource".equals(good.getCategory())) {
                result = this.getAmountOfResourceForSettlement((AmountResource)good.getObject());
            } else if ("item resource".equals(good.getCategory())) {
                result = this.getNumberOfResourceForSettlement((ItemResource)good.getObject());
            } else if ("equipment".equals(good.getCategory())) {
                result = this.getNumberOfEquipmentForSettlement(good.getClassType());
            } else if ("vehicle".equals(good.getCategory())) {
                result = this.getNumberOfVehiclesForSettlement(good.getName());
            }
            return result;
        }
        throw new IllegalArgumentException("Good is null.");
    }

    private double getAmountOfResourceForSettlement(AmountResource resource) {
        double amount = 0.0;
        amount += this.settlement.getInventory().getAmountResourceStored(resource, false);
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(this.settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || this.settlement.equals(vehicle.getSettlement())) continue;
            amount += vehicle.getInventory().getAmountResourceStored(resource, false);
        }
        for (Person person : this.settlement.getAllAssociatedPeople()) {
            if (!person.getLocationSituation().equals("Outside")) continue;
            amount += person.getInventory().getAmountResourceStored(resource, false);
        }
        return amount;
    }

    private double determineItemResourceGoodValue(Good resourceGood, double supply, boolean useCache) {
        double value = 0.0;
        ItemResource resource = (ItemResource)resourceGood.getObject();
        double demand = 0.0;
        if (useCache) {
            if (!this.goodsDemandCache.containsKey(resourceGood)) {
                throw new IllegalArgumentException("Good: " + resourceGood + " not valid.");
            }
            demand = this.goodsDemandCache.get(resourceGood);
            this.partsDemandCache.clear();
        } else {
            if (resource instanceof Part) {
                Part part = (Part)resource;
                if (this.partsDemandCache.size() == 0) {
                    this.determinePartsDemand();
                }
                if (this.partsDemandCache.containsKey(part)) {
                    demand = this.partsDemandCache.get(part);
                }
                demand += this.getPartManufacturingDemand(part);
                demand += this.getPartConstructionDemand(part);
            }
            this.goodsDemandCache.put(resourceGood, demand += this.determineTradeDemand(resourceGood, useCache));
        }
        value = demand / (supply + 1.0);
        return value;
    }

    private void determinePartsDemand() {
        HashMap<Part, Double> partsProbDemand = new HashMap<Part, Double>(ItemResource.getItemResources().size());
        for (Malfunctionable entity : MalfunctionFactory.getAssociatedMalfunctionables(this.settlement)) {
            double wearModifier = entity.getMalfunctionManager().getWearCondition() / 100.0 * 0.75 + 0.25;
            this.sumPartsDemand(partsProbDemand, this.getEstimatedOrbitRepairParts(entity), wearModifier);
            this.sumPartsDemand(partsProbDemand, this.getOutstandingRepairParts(entity), wearModifier);
            this.sumPartsDemand(partsProbDemand, this.getEstimatedOrbitMaintenanceParts(entity), wearModifier);
            this.sumPartsDemand(partsProbDemand, this.getOutstandingMaintenanceParts(entity), wearModifier);
        }
        this.sumPartsDemand(partsProbDemand, this.getVehicleAttachmentParts(), 1.0);
        for (Part part : partsProbDemand.keySet()) {
            this.partsDemandCache.put(part, (Double)partsProbDemand.get(part));
        }
    }

    private void sumPartsDemand(Map<Part, Double> totalPartsDemand, Map<Part, Number> additionalPartsDemand, double multiplier) {
        for (Part part : additionalPartsDemand.keySet()) {
            double number = additionalPartsDemand.get(part).doubleValue() * multiplier;
            if (totalPartsDemand.containsKey(part)) {
                number += totalPartsDemand.get(part).doubleValue();
            }
            totalPartsDemand.put(part, number);
        }
    }

    private Map<Part, Number> getEstimatedOrbitRepairParts(Malfunctionable entity) {
        HashMap<Part, Number> result = new HashMap<Part, Number>();
        MalfunctionManager manager = entity.getMalfunctionManager();
        double orbitMalfunctions = manager.getEstimatedNumberOfMalfunctionsPerOrbit();
        Map<Part, Double> partsPerMalfunction = manager.getRepairPartProbabilities();
        for (Part part : partsPerMalfunction.keySet()) {
            result.put(part, partsPerMalfunction.get(part) * orbitMalfunctions);
        }
        return result;
    }

    private Map<Part, Number> getOutstandingRepairParts(Malfunctionable entity) {
        HashMap<Part, Number> result = new HashMap<Part, Number>(0);
        for (Malfunction malfunction : entity.getMalfunctionManager().getMalfunctions()) {
            Map<Part, Integer> repairParts = malfunction.getRepairParts();
            for (Part part : repairParts.keySet()) {
                int number = repairParts.get(part) * 100;
                if (result.containsKey(part)) {
                    number += ((Number)result.get(part)).intValue();
                }
                result.put(part, number);
            }
        }
        return result;
    }

    private Map<Part, Number> getEstimatedOrbitMaintenanceParts(Malfunctionable entity) {
        HashMap<Part, Number> result = new HashMap<Part, Number>();
        MalfunctionManager manager = entity.getMalfunctionManager();
        double orbitMaintenances = manager.getEstimatedNumberOfMaintenancesPerOrbit();
        Map<Part, Double> partsPerMaintenance = manager.getMaintenancePartProbabilities();
        for (Part part : partsPerMaintenance.keySet()) {
            result.put(part, partsPerMaintenance.get(part) * orbitMaintenances);
        }
        return result;
    }

    private Map<Part, Number> getOutstandingMaintenanceParts(Malfunctionable entity) {
        HashMap<Part, Number> result = new HashMap<Part, Number>();
        Map<Part, Integer> maintParts = entity.getMalfunctionManager().getMaintenanceParts();
        for (Part part : maintParts.keySet()) {
            int number = maintParts.get(part) * 10;
            result.put(part, number);
        }
        return result;
    }

    private Map<Part, Number> getVehicleAttachmentParts() {
        HashMap<Part, Number> result = new HashMap<Part, Number>();
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        Iterator<Vehicle> i = this.settlement.getAllAssociatedVehicles().iterator();
        while (i.hasNext()) {
            String type = i.next().getDescription().toLowerCase();
            if (!config.hasPartAttachments(type)) continue;
            for (Part part : config.getAttachableParts(type)) {
                int demand = 1;
                if (result.containsKey(part)) {
                    demand += ((Number)result.get(part)).intValue();
                }
                result.put(part, demand);
            }
        }
        return result;
    }

    private double getPartManufacturingDemand(Part part) {
        double demand = 0.0;
        if (ManufactureUtil.doesSettlementHaveManufacturing(this.settlement)) {
            int techLevel = ManufactureUtil.getHighestManufacturingTechLevel(this.settlement);
            Iterator<ManufactureProcessInfo> i = ManufactureUtil.getManufactureProcessesForTechLevel(techLevel).iterator();
            while (i.hasNext()) {
                double manufacturingDemand = this.getPartManufacturingProcessDemand(part, i.next());
                demand += manufacturingDemand;
            }
        }
        return demand;
    }

    private double getPartManufacturingProcessDemand(Part part, ManufactureProcessInfo process) {
        double demand = 0.0;
        double totalInputNum = 0.0;
        ManufactureProcessItem partInput = null;
        for (ManufactureProcessItem item : process.getInputList()) {
            if ("part".equalsIgnoreCase(item.getType()) && part.getName().equalsIgnoreCase(item.getName())) {
                partInput = item;
            }
            totalInputNum += item.getAmount();
        }
        if (partInput != null) {
            double outputsValue = 0.0;
            for (ManufactureProcessItem item : process.getOutputList()) {
                outputsValue += ManufactureUtil.getManufactureProcessItemValue(item, this.settlement);
            }
            double totalInputsValue = outputsValue * 0.75;
            double partNum = partInput.getAmount();
            demand = totalInputsValue * (partNum / totalInputNum);
        }
        return demand;
    }

    private double getPartConstructionDemand(Part part) {
        double demand = 0.0;
        ConstructionValues values = this.settlement.getConstructionManager().getConstructionValues();
        Map<ConstructionStageInfo, Double> stageValues = values.getAllConstructionStageValues();
        for (ConstructionStageInfo stage : stageValues.keySet()) {
            double stageValue = stageValues.get(stage);
            if (!(stageValue > 0.0) || !"building".equals(stage.getType()) || !this.isLocallyConstructable(stage)) continue;
            double constructionStageDemand = this.getPartConstructionStageDemand(part, stage, stageValue);
            demand += constructionStageDemand;
        }
        return demand;
    }

    private double getPartConstructionStageDemand(Part part, ConstructionStageInfo stage, double stageValue) {
        double demand = 0.0;
        Map<AmountResource, Double> resources = this.getAllPrerequisiteConstructionResources(stage);
        Map<Part, Integer> parts = this.getAllPrerequisiteConstructionParts(stage);
        if (parts.containsKey(part)) {
            double totalNumber = 0.0;
            Iterator<AmountResource> i = resources.keySet().iterator();
            while (i.hasNext()) {
                totalNumber += resources.get(i.next()).doubleValue();
            }
            Iterator<Part> j = parts.keySet().iterator();
            while (j.hasNext()) {
                totalNumber += (double)parts.get(j.next()).intValue();
            }
            double partNumber = parts.get(part).intValue();
            double totalInputsValue = stageValue * 0.75;
            demand = totalInputsValue * (partNumber / totalNumber);
        }
        return demand;
    }

    private double getNumberOfResourceForSettlement(ItemResource resource) {
        double number = 0.0;
        number += (double)this.settlement.getInventory().getItemResourceNum(resource);
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(this.settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || this.settlement.equals(vehicle.getSettlement())) continue;
            number += (double)vehicle.getInventory().getItemResourceNum(resource);
        }
        for (Person person : this.settlement.getAllAssociatedPeople()) {
            if (!person.getLocationSituation().equals("Outside")) continue;
            number += (double)person.getInventory().getItemResourceNum(resource);
        }
        return number;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double determineEquipmentGoodValue(Good equipmentGood, double supply, boolean useCache) {
        double value = 0.0;
        double demand = 0.0;
        if (useCache) {
            if (!this.goodsDemandCache.containsKey(equipmentGood)) throw new IllegalArgumentException("Good: " + equipmentGood + " not valid.");
            demand = this.goodsDemandCache.get(equipmentGood);
            return demand / (supply + 1.0);
        } else {
            demand = this.determineEquipmentDemand(equipmentGood.getClassType());
            this.goodsDemandCache.put(equipmentGood, demand += this.determineTradeDemand(equipmentGood, useCache));
        }
        return demand / (supply + 1.0);
    }

    private double determineEquipmentDemand(Class<? extends Equipment> equipmentClass) {
        double numDemand = 0.0;
        if (EVASuit.class.equals(equipmentClass)) {
            numDemand += 2.0 * (double)this.settlement.getAllAssociatedPeople().size() * 100.0;
        }
        if (Container.class.isAssignableFrom(equipmentClass)) {
            numDemand = 10.0 * (double)this.settlement.getBuildingManager().getBuildingNum();
            numDemand += (double)this.getNonEmptyContainers(equipmentClass);
        }
        int areologistNum = this.getAreologistNum();
        if (Bag.class.equals(equipmentClass)) {
            AmountResource ice = AmountResource.findAmountResource("ice");
            double iceValue = this.getGoodValuePerItem(GoodsUtil.getResourceGood(ice));
            AmountResource regolith = AmountResource.findAmountResource("regolith");
            double regolithValue = this.getGoodValuePerItem(GoodsUtil.getResourceGood(regolith));
            numDemand += (double)(20 * areologistNum) * iceValue;
            numDemand += (double)(10 * areologistNum) * regolithValue;
        }
        if (SpecimenContainer.class.equals(equipmentClass)) {
            numDemand += (double)(20 * areologistNum);
        }
        return numDemand;
    }

    private int getNonEmptyContainers(Class<? extends Equipment> equipmentClass) {
        int result = 0;
        Inventory inv = this.settlement.getInventory();
        Collection<Unit> equipmentList = inv.findAllUnitsOfClass(equipmentClass);
        MissionManager missionManager = Simulation.instance().getMissionManager();
        for (Mission mission : missionManager.getMissionsForSettlement(this.settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || vehicle.getSettlement() != null) continue;
            Inventory vehicleInv = vehicle.getInventory();
            for (Unit equipment : vehicleInv.findAllUnitsOfClass(equipmentClass)) {
                if (equipmentList.contains(equipment)) continue;
                equipmentList.add(equipment);
            }
        }
        Iterator<Unit> k = equipmentList.iterator();
        while (k.hasNext()) {
            if (!((double)k.next().getInventory().getAllAmountResourcesStored(false).size() > 0.0)) continue;
            ++result;
        }
        return result;
    }

    private int getAreologistNum() {
        int result = 0;
        Iterator<Person> i = this.settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            if (!(i.next().getMind().getJob() instanceof Areologist)) continue;
            ++result;
        }
        return result;
    }

    private int getBiologistNum() {
        int result = 0;
        Iterator<Person> i = this.settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            if (!(i.next().getMind().getJob() instanceof Biologist)) continue;
            ++result;
        }
        return result;
    }

    private int getArchitectNum() {
        int result = 0;
        Iterator<Person> i = this.settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            if (!(i.next().getMind().getJob() instanceof Architect)) continue;
            ++result;
        }
        return result;
    }

    private int getDriverNum() {
        int result = 0;
        Iterator<Person> i = this.settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            if (!(i.next().getMind().getJob() instanceof Driver)) continue;
            ++result;
        }
        return result;
    }

    private int getTraderNum() {
        int result = 0;
        Iterator<Person> i = this.settlement.getAllAssociatedPeople().iterator();
        while (i.hasNext()) {
            if (!(i.next().getMind().getJob() instanceof Trader)) continue;
            ++result;
        }
        return result;
    }

    private double getNumberOfEquipmentForSettlement(Class<? extends Equipment> equipmentClass) {
        double number = 0.0;
        number += (double)this.settlement.getInventory().findNumEmptyUnitsOfClass(equipmentClass, false);
        for (Mission mission : Simulation.instance().getMissionManager().getMissionsForSettlement(this.settlement)) {
            Vehicle vehicle;
            if (!(mission instanceof VehicleMission) || (vehicle = ((VehicleMission)mission).getVehicle()) == null || this.settlement.equals(vehicle.getSettlement())) continue;
            number += (double)vehicle.getInventory().findNumEmptyUnitsOfClass(equipmentClass, false);
        }
        for (Person person : this.settlement.getAllAssociatedPeople()) {
            if (!person.getLocationSituation().equals("Outside")) continue;
            number += (double)person.getInventory().findNumEmptyUnitsOfClass(equipmentClass, false);
        }
        return number;
    }

    private double determineVehicleGoodValue(Good vehicleGood, double supply, boolean useCache) {
        double value = 0.0;
        String vehicleType = vehicleGood.getName();
        boolean buy = false;
        double currentNum = this.getNumberOfVehiclesForSettlement(vehicleType);
        if (supply == currentNum) {
            buy = true;
        }
        if (this.vehicleBuyValueCache == null) {
            this.vehicleBuyValueCache = new HashMap<String, Double>();
        }
        if (this.vehicleSellValueCache == null) {
            this.vehicleSellValueCache = new HashMap<String, Double>();
        }
        if (useCache) {
            value = buy ? (this.vehicleBuyValueCache.containsKey(vehicleType) ? this.vehicleBuyValueCache.get(vehicleType).doubleValue() : this.determineVehicleGoodValue(vehicleGood, supply, false)) : (this.vehicleSellValueCache.containsKey(vehicleType) ? this.vehicleSellValueCache.get(vehicleType).doubleValue() : this.determineVehicleGoodValue(vehicleGood, supply, false));
        } else {
            if (vehicleType.equalsIgnoreCase("light utility vehicle")) {
                value = this.determineLUVValue(buy);
            } else {
                double biologyFieldMissionValue;
                double areologyFieldMissionValue;
                double constructionMissionValue;
                double miningMissionValue;
                double collectRegolithMissionValue;
                double tradeMissionValue;
                double rescueMissionValue;
                double collectIceMissionValue;
                double explorationMissionValue;
                double travelToSettlementMissionValue = this.determineMissionVehicleValue(TRAVEL_TO_SETTLEMENT_MISSION, vehicleType, buy);
                if (travelToSettlementMissionValue > value) {
                    value = travelToSettlementMissionValue;
                }
                if ((explorationMissionValue = this.determineMissionVehicleValue(EXPLORATION_MISSION, vehicleType, buy)) > value) {
                    value = explorationMissionValue;
                }
                if ((collectIceMissionValue = this.determineMissionVehicleValue(COLLECT_ICE_MISSION, vehicleType, buy)) > value) {
                    value = collectIceMissionValue;
                }
                if ((rescueMissionValue = this.determineMissionVehicleValue(RESCUE_SALVAGE_MISSION, vehicleType, buy)) > value) {
                    value = rescueMissionValue;
                }
                if ((tradeMissionValue = this.determineMissionVehicleValue(TRADE_MISSION, vehicleType, buy)) > value) {
                    value = tradeMissionValue;
                }
                if ((collectRegolithMissionValue = this.determineMissionVehicleValue(COLLECT_REGOLITH_MISSION, vehicleType, buy)) > value) {
                    value = collectRegolithMissionValue;
                }
                if ((miningMissionValue = this.determineMissionVehicleValue(MINING_MISSION, vehicleType, buy)) > value) {
                    value = miningMissionValue;
                }
                if ((constructionMissionValue = this.determineMissionVehicleValue(CONSTRUCTION_MISSION, vehicleType, buy)) > value) {
                    value = constructionMissionValue;
                }
                if ((areologyFieldMissionValue = this.determineMissionVehicleValue(AREOLOGY_STUDY_FIELD_MISSION, vehicleType, buy)) > value) {
                    value = areologyFieldMissionValue;
                }
                if ((biologyFieldMissionValue = this.determineMissionVehicleValue(BIOLOGY_STUDY_FIELD_MISSION, vehicleType, buy)) > value) {
                    value = biologyFieldMissionValue;
                }
            }
            value *= 10000.0;
            double tradeValue = this.determineTradeVehicleValue(vehicleGood, useCache);
            if (tradeValue > value) {
                value = tradeValue;
            }
            if (buy) {
                this.vehicleBuyValueCache.put(vehicleType, value);
            } else {
                this.vehicleSellValueCache.put(vehicleType, value);
            }
        }
        return value;
    }

    private double determineTradeVehicleValue(Good vehicleGood, boolean useCache) {
        double tradeDemand = this.determineTradeDemand(vehicleGood, useCache);
        double supply = this.getNumberOfVehiclesForSettlement(vehicleGood.getName());
        return tradeDemand / (supply + 1.0);
    }

    private double determineLUVValue(boolean buy) {
        double demand = 0.0;
        demand += (double)this.getAreologistNum();
        demand += (double)this.getArchitectNum();
        double supply = this.getNumberOfVehiclesForSettlement("light utility vehicle");
        if (!buy) {
            supply -= 1.0;
        }
        if (supply < 0.0) {
            supply = 0.0;
        }
        return demand / (supply + 1.0);
    }

    private double determineMissionVehicleValue(String missionType, String vehicleType, boolean buy) {
        double demand = this.determineMissionVehicleDemand(missionType);
        double currentCapacity = 0.0;
        boolean soldFlag = false;
        Iterator<Vehicle> i = this.settlement.getAllAssociatedVehicles().iterator();
        while (i.hasNext()) {
            String type = i.next().getDescription().toLowerCase();
            if (!buy && !soldFlag && type.equalsIgnoreCase(vehicleType)) {
                soldFlag = true;
                continue;
            }
            currentCapacity += this.determineMissionVehicleCapacity(missionType, type);
        }
        double vehicleCapacity = this.determineMissionVehicleCapacity(missionType, vehicleType);
        double baseValue = demand / (currentCapacity + 1.0) * vehicleCapacity;
        return baseValue;
    }

    private double determineMissionVehicleDemand(String missionType) {
        double demand = 0.0;
        if (TRAVEL_TO_SETTLEMENT_MISSION.equals(missionType)) {
            demand = this.getDriverNum();
            demand *= (double)this.settlement.getAllAssociatedPeople().size() / (double)this.settlement.getPopulationCapacity();
        } else if (EXPLORATION_MISSION.equals(missionType)) {
            demand = this.getAreologistNum();
        } else if (COLLECT_ICE_MISSION.equals(missionType)) {
            AmountResource ice = AmountResource.findAmountResource("ice");
            demand = this.getGoodValuePerItem(GoodsUtil.getResourceGood(ice));
            if (demand > 10.0) {
                demand = 10.0;
            }
        } else if (RESCUE_SALVAGE_MISSION.equals(missionType)) {
            demand = this.getDriverNum();
        } else if (TRADE_MISSION.equals(missionType)) {
            demand = this.getTraderNum();
        } else if (COLLECT_REGOLITH_MISSION.equals(missionType)) {
            AmountResource regolith = AmountResource.findAmountResource("regolith");
            demand = this.getGoodValuePerItem(GoodsUtil.getResourceGood(regolith));
            if (demand > 10.0) {
                demand = 10.0;
            }
        } else if (MINING_MISSION.equals(missionType)) {
            demand = this.getAreologistNum();
        } else if (!CONSTRUCTION_MISSION.equals(missionType)) {
            if (AREOLOGY_STUDY_FIELD_MISSION.equals(missionType)) {
                demand = this.getAreologistNum();
            } else if (BIOLOGY_STUDY_FIELD_MISSION.equals(missionType)) {
                demand = this.getBiologistNum();
            }
        }
        return demand;
    }

    private double determineMissionVehicleCapacity(String missionType, String vehicleType) {
        double capacity = 0.0;
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        int crewCapacity = config.getCrewSize(vehicleType);
        if (TRAVEL_TO_SETTLEMENT_MISSION.equals(missionType)) {
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            capacity *= (double)crewCapacity / 8.0;
            double range = this.getVehicleRange(vehicleType);
            capacity *= range / 2000.0;
        } else if (EXPLORATION_MISSION.equals(missionType)) {
            double range;
            double cargoCapacity;
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            if ((cargoCapacity = config.getTotalCapacity(vehicleType)) < 500.0) {
                capacity = 0.0;
            }
            boolean hasAreologyLab = false;
            if (config.hasLab(vehicleType) && config.getLabTechSpecialities(vehicleType).contains("Areology")) {
                hasAreologyLab = true;
            }
            if (!hasAreologyLab) {
                capacity /= 2.0;
            }
            if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                capacity = 0.0;
            }
        } else if (COLLECT_ICE_MISSION.equals(missionType)) {
            double range;
            double cargoCapacity;
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            if ((cargoCapacity = config.getTotalCapacity(vehicleType)) < 1250.0) {
                capacity = 0.0;
            }
            if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                capacity = 0.0;
            }
        } else if (RESCUE_SALVAGE_MISSION.equals(missionType)) {
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            double range = this.getVehicleRange(vehicleType);
            capacity *= range / 2000.0;
        } else if (TRADE_MISSION.equals(missionType)) {
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            double cargoCapacity = config.getTotalCapacity(vehicleType);
            capacity *= cargoCapacity / 10000.0;
            double range = this.getVehicleRange(vehicleType);
            capacity *= range / 2000.0;
        } else if (COLLECT_REGOLITH_MISSION.equals(missionType)) {
            double range;
            double cargoCapacity;
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            if ((cargoCapacity = config.getTotalCapacity(vehicleType)) < 1250.0) {
                capacity = 0.0;
            }
            if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                capacity = 0.0;
            }
        } else if (MINING_MISSION.equals(missionType)) {
            double range;
            double cargoCapacity;
            if (crewCapacity >= 2) {
                capacity = 1.0;
            }
            if ((cargoCapacity = config.getTotalCapacity(vehicleType)) < 1000.0) {
                capacity = 0.0;
            }
            if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                capacity = 0.0;
            }
        } else if (!CONSTRUCTION_MISSION.equals(missionType)) {
            if (AREOLOGY_STUDY_FIELD_MISSION.equals(missionType)) {
                double range;
                if (crewCapacity >= 2) {
                    capacity = 1.0;
                }
                if (config.hasLab(vehicleType)) {
                    capacity = config.getLabTechSpecialities(vehicleType).contains("Areology") ? (capacity += (double)config.getLabTechLevel(vehicleType)) : (capacity /= 2.0);
                }
                if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                    capacity = 0.0;
                }
            } else if (BIOLOGY_STUDY_FIELD_MISSION.equals(missionType)) {
                double range;
                if (crewCapacity >= 2) {
                    capacity = 1.0;
                }
                if (config.hasLab(vehicleType)) {
                    capacity = config.getLabTechSpecialities(vehicleType).contains("Biology") ? (capacity += (double)config.getLabTechLevel(vehicleType)) : (capacity /= 2.0);
                }
                if ((range = this.getVehicleRange(vehicleType)) == 0.0) {
                    capacity = 0.0;
                }
            }
        }
        return capacity;
    }

    private double getVehicleRange(String vehicleType) {
        double range = 0.0;
        VehicleConfig vehicleConfig = SimulationConfig.instance().getVehicleConfiguration();
        double fuelCapacity = vehicleConfig.getCargoCapacity(vehicleType, "methane");
        double fuelEfficiency = vehicleConfig.getFuelEfficiency(vehicleType);
        range = fuelCapacity * fuelEfficiency / 1.5;
        double baseSpeed = vehicleConfig.getBaseSpeed(vehicleType);
        double distancePerSol = baseSpeed / 2.0 / 60.0 / 60.0 / MarsClock.convertSecondsToMillisols(1.0) * 1000.0;
        PersonConfig personConfig = SimulationConfig.instance().getPersonConfiguration();
        int crewSize = vehicleConfig.getCrewSize(vehicleType);
        double foodConsumptionRate = personConfig.getFoodConsumptionRate();
        double foodCapacity = vehicleConfig.getCargoCapacity(vehicleType, "food");
        double foodSols = foodCapacity / (foodConsumptionRate * (double)crewSize);
        double foodRange = distancePerSol * foodSols / 3.0;
        if (foodRange < range) {
            range = foodRange;
        }
        double waterConsumptionRate = personConfig.getWaterConsumptionRate();
        double waterCapacity = vehicleConfig.getCargoCapacity(vehicleType, "water");
        double waterSols = waterCapacity / (waterConsumptionRate * (double)crewSize);
        double waterRange = distancePerSol * waterSols / 3.0;
        if (waterRange < range) {
            range = waterRange;
        }
        double oxygenConsumptionRate = personConfig.getOxygenConsumptionRate();
        double oxygenCapacity = vehicleConfig.getCargoCapacity(vehicleType, "oxygen");
        double oxygenSols = oxygenCapacity / (oxygenConsumptionRate * (double)crewSize);
        double oxygenRange = distancePerSol * oxygenSols / 3.0;
        if (oxygenRange < range) {
            range = oxygenRange;
        }
        return range;
    }

    private double getNumberOfVehiclesForSettlement(String vehicleType) {
        double number = 0.0;
        for (Vehicle vehicle : this.settlement.getAllAssociatedVehicles()) {
            if (!vehicleType.equalsIgnoreCase(vehicle.getDescription())) continue;
            number += 1.0;
        }
        return number;
    }

    private double determineTradeDemand(Good good, boolean useTradeCache) {
        if (useTradeCache) {
            if (this.goodsTradeCache.containsKey(good)) {
                return this.goodsTradeCache.get(good);
            }
            throw new IllegalArgumentException("good: " + good + " not valid.");
        }
        double bestTradeValue = 0.0;
        for (Settlement tempSettlement : Simulation.instance().getUnitManager().getSettlements()) {
            double distance;
            double baseValue;
            double tradeValue;
            if (tempSettlement == this.settlement || !((tradeValue = (baseValue = tempSettlement.getGoodsManager().getGoodValuePerItem(good)) / (1.0 + (distance = this.settlement.getCoordinates().getDistance(tempSettlement.getCoordinates())) / 1000.0)) > bestTradeValue)) continue;
            bestTradeValue = tradeValue;
        }
        this.goodsTradeCache.put(good, bestTradeValue);
        return bestTradeValue;
    }

    public void prepareForLoadCalculation() {
        this.vehicleBuyValueCache.clear();
        this.vehicleSellValueCache.clear();
    }

    public void destroy() {
        this.settlement = null;
        this.goodsValues.clear();
        this.goodsValues = null;
        this.goodsDemandCache.clear();
        this.goodsDemandCache = null;
        this.goodsTradeCache.clear();
        this.goodsTradeCache = null;
        this.resourceProcessingCache.clear();
        this.resourceProcessingCache = null;
        if (this.vehicleBuyValueCache != null) {
            this.vehicleBuyValueCache.clear();
            this.vehicleBuyValueCache = null;
        }
        if (this.vehicleSellValueCache != null) {
            this.vehicleSellValueCache.clear();
            this.vehicleSellValueCache = null;
        }
        if (this.partsDemandCache != null) {
            this.partsDemandCache.clear();
            this.partsDemandCache = null;
        }
    }
}

