/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.time;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class EarthClock
implements Serializable {
    private final GregorianCalendar cal = new GregorianCalendar();
    private final SimpleDateFormat formatter;

    public EarthClock(String dateString) {
        SimpleTimeZone zone = new SimpleTimeZone(0, "GMT");
        this.cal.setTimeZone(zone);
        this.formatter = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss 'UT'");
        this.formatter.setTimeZone(zone);
        this.cal.clear();
        SimpleDateFormat tempFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        tempFormatter.setTimeZone(zone);
        try {
            this.cal.setTime(tempFormatter.parse(dateString));
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized String getTimeStamp() {
        return this.formatter.format(this.cal.getTime());
    }

    public synchronized String getDateString() {
        return this.getTimeStamp().substring(0, 10);
    }

    public synchronized void addTime(double seconds) {
        this.cal.add(14, (int)(seconds * 1000.0));
    }

    public synchronized String toString() {
        return this.getTimeStamp();
    }

    public int getDayOfMonth() {
        return this.cal.get(5);
    }

    public int getMonth() {
        return this.cal.get(2);
    }

    public int getYear() {
        return this.cal.get(1);
    }
}

