/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.time;

import java.io.Serializable;
import java.util.Arrays;

public class MarsClock
implements Serializable {
    public static final int SOLS_IN_ORBIT_NON_LEAPYEAR = 668;
    public static final int SOLS_IN_ORBIT_LEAPYEAR = 669;
    private static final int MONTHS_IN_ORBIT = 24;
    private static final int SOLS_IN_MONTH_SHORT = 27;
    public static final int SOLS_IN_MONTH_LONG = 28;
    private static final int SOLS_IN_WEEK_SHORT = 6;
    private static final int SOLS_IN_WEEK_LONG = 7;
    public static final int NORTHERN_HEMISPHERE = 1;
    public static final int SOUTHERN_HEMISPHERE = 2;
    private static final double SECONDS_IN_MILLISOL = 88.775244;
    private static final String[] MONTH_NAMES = new String[]{"Adir", "Bora", "Coan", "Detri", "Edal", "Flo", "Geor", "Heliba", "Idanon", "Jowani", "Kireal", "Larno", "Medior", "Neturima", "Ozulikan", "Pasurabi", "Rudiakel", "Safundo", "Tiunor", "Ulasja", "Vadeun", "Wakumi", "Xetual", "Zungo"};
    private static final String[] WEEK_SOL_NAMES = new String[]{"Solisol", "Phobosol", "Deimosol", "Terrasol", "Hermesol", "Venusol", "Jovisol"};
    private int orbit;
    private int month;
    private int sol;
    private double millisol;

    public MarsClock(String dateString) {
        String orbitStr = dateString.substring(0, dateString.indexOf("-"));
        this.orbit = Integer.parseInt(orbitStr);
        if (this.orbit < 0) {
            throw new IllegalStateException("Invalid orbit number: " + this.orbit);
        }
        String monthStr = dateString.substring(dateString.indexOf("-") + 1, dateString.lastIndexOf("-"));
        this.month = 0;
        for (int x = 0; x < MONTH_NAMES.length; ++x) {
            if (!monthStr.equals(MONTH_NAMES[x])) continue;
            this.month = x + 1;
        }
        if (this.month < 1 || this.month > MONTH_NAMES.length) {
            throw new IllegalStateException("Invalid month: " + monthStr);
        }
        String solStr = dateString.substring(dateString.lastIndexOf("-") + 1, dateString.indexOf(":"));
        this.sol = Integer.parseInt(solStr);
        if (this.sol < 1) {
            throw new IllegalStateException("Invalid sol number: " + this.sol);
        }
        String millisolStr = dateString.substring(dateString.indexOf(":") + 1);
        this.millisol = Double.parseDouble(millisolStr);
        if (this.millisol < 0.0) {
            throw new IllegalStateException("Invalid millisol number: " + this.millisol);
        }
    }

    public MarsClock(int orbit, int month, int sol, double millisol) {
        this.orbit = orbit;
        this.month = month;
        this.sol = sol;
        this.millisol = millisol;
    }

    public static double convertSecondsToMillisols(double seconds) {
        return seconds / 88.775244;
    }

    public static double convertMillisolsToSeconds(double millisols) {
        return millisols * 88.775244;
    }

    public static double getTimeDiff(MarsClock firstTime, MarsClock secondTime) {
        return MarsClock.getTotalMillisols(firstTime) - MarsClock.getTotalMillisols(secondTime);
    }

    public static String[] getMonthNames() {
        return Arrays.copyOf(MONTH_NAMES, MONTH_NAMES.length);
    }

    public static String[] getWeekSolNames() {
        return Arrays.copyOf(WEEK_SOL_NAMES, WEEK_SOL_NAMES.length);
    }

    private static double getTotalMillisols(MarsClock time) {
        int x;
        double result = 0.0;
        for (x = 1; x < time.orbit; ++x) {
            if (MarsClock.isLeapOrbit(x)) {
                result += 669000.0;
                continue;
            }
            result += 668000.0;
        }
        for (x = 1; x < time.month; ++x) {
            result += (double)MarsClock.getSolsInMonth(x, time.orbit) * 1000.0;
        }
        result += (double)(time.sol - 1) * 1000.0;
        return result += time.millisol;
    }

    public static int getSolsInMonth(int month, int orbit) {
        int result = 28;
        if (month % 6 == 0) {
            result = 27;
        }
        if (month == 24 && MarsClock.isLeapOrbit(orbit)) {
            result = 28;
        }
        return result;
    }

    public static boolean isLeapOrbit(int orbit) {
        boolean result = false;
        if (orbit % 10 == 0) {
            result = true;
        }
        if (orbit % 100 == 0) {
            result = false;
        }
        if (orbit % 500 == 0) {
            result = true;
        }
        return result;
    }

    public void addTime(double addedMillisols) {
        block4: {
            block3: {
                this.millisol += addedMillisols;
                if (!(addedMillisols > 0.0)) break block3;
                while (this.millisol >= 1000.0) {
                    this.millisol -= 1000.0;
                    ++this.sol;
                    if (this.sol <= MarsClock.getSolsInMonth(this.month, this.orbit)) continue;
                    this.sol = 1;
                    ++this.month;
                    if (this.month <= 24) continue;
                    this.month = 1;
                    ++this.orbit;
                }
                break block4;
            }
            if (!(addedMillisols < 0.0)) break block4;
            while (this.millisol < 0.0) {
                this.millisol += 1000.0;
                --this.sol;
                if (this.sol >= 1) continue;
                --this.month;
                if (this.month < 1) {
                    this.month = 24;
                    --this.orbit;
                }
                this.sol = MarsClock.getSolsInMonth(this.month, this.orbit);
            }
        }
    }

    public String getTimeStamp() {
        return this.getDateString() + "  " + this.getTimeString();
    }

    public String getDateString() {
        StringBuilder result = new StringBuilder();
        result.append(this.orbit).append("-").append(this.getMonthName()).append("-");
        if (this.sol < 10) {
            result.append("0");
        }
        result.append(this.sol);
        return result.toString();
    }

    public String getTimeString() {
        StringBuilder b = new StringBuilder();
        double tb = Math.floor(this.millisol * 1000.0) / 1000.0;
        b.append(tb);
        if (this.millisol < 100.0) {
            b.insert(0, "0");
        }
        if (this.millisol < 10.0) {
            b.insert(0, "0");
        }
        while (b.length() < 7) {
            b.append("0");
        }
        return b.toString();
    }

    public String getMonthName() {
        return MONTH_NAMES[this.month - 1];
    }

    public int getOrbit() {
        return this.orbit;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSolOfMonth() {
        return this.sol;
    }

    public double getMillisol() {
        return this.millisol;
    }

    public int getWeekOfMonth() {
        return (this.sol - 1) / 7 + 1;
    }

    public int getSolOfWeek() {
        return this.sol - (this.getWeekOfMonth() - 1) * 7;
    }

    public String getSolOfWeekName() {
        return WEEK_SOL_NAMES[this.getSolOfWeek() - 1];
    }

    public int getSolsInWeek() {
        int result = 7;
        if (MarsClock.getSolsInMonth(this.month, this.orbit) == 27 && this.getWeekOfMonth() == 4) {
            result = 6;
        }
        return result;
    }

    public String getSeason(int hemisphere) {
        String season = null;
        if (this.month < 8) {
            if (hemisphere == 1) {
                season = "Spring";
            }
            if (hemisphere == 2) {
                season = "Autumn";
            }
        } else if (this.month < 14) {
            if (hemisphere == 1) {
                season = "Summer";
            }
            if (hemisphere == 2) {
                season = "Winter";
            }
        } else if (this.month < 19) {
            if (hemisphere == 1) {
                season = "Autumn";
            }
            if (hemisphere == 2) {
                season = "Spring";
            }
        } else {
            if (hemisphere == 1) {
                season = "Winter";
            }
            if (hemisphere == 2) {
                season = "Summer";
            }
        }
        return season;
    }

    public Object clone() {
        return new MarsClock(this.orbit, this.month, this.sol, this.millisol);
    }

    public String toString() {
        return this.getTimeStamp();
    }

    public boolean equals(Object object) {
        boolean result = true;
        if (object instanceof MarsClock) {
            MarsClock otherClock = (MarsClock)object;
            if (this.orbit != otherClock.orbit) {
                result = false;
            } else if (this.month != otherClock.month) {
                result = false;
            } else if (this.sol != otherClock.sol) {
                result = false;
            } else if (this.millisol != otherClock.millisol) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return this.orbit * this.month * this.sol + (int)(this.millisol * 1000.0);
    }
}

