/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.time;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.time.ClockListener;
import org.mars_sim.msp.core.time.EarthClock;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.time.UpTimer;

public class MasterClock
implements Runnable,
Serializable {
    private static Logger logger = Logger.getLogger(MasterClock.class.getName());
    private static long SLEEP_TIME = 10L;
    private MarsClock marsTime;
    private MarsClock initialMarsTime;
    private EarthClock earthTime;
    private UpTimer uptimer;
    private volatile transient boolean keepRunning;
    private volatile transient boolean isPaused = false;
    private volatile double timeRatio = 0.0;
    private volatile transient boolean loadSimulation;
    private volatile transient boolean saveSimulation;
    private volatile transient File file;
    private volatile transient boolean exitProgram;
    private transient List<ClockListener> listeners;
    private long totalPulses = 1L;
    private transient long elapsedlast;
    private transient long elapsedMilliseconds;
    static final long serialVersionUID = -1688463735489226494L;
    public static final int secspmin = 60;
    public static final int secsphour = 3600;
    public static final int secspday = 86400;
    public static final int secsperyear = 31536000;

    public MasterClock() {
        SimulationConfig config = SimulationConfig.instance();
        this.marsTime = new MarsClock(config.getMarsStartDateTime());
        this.initialMarsTime = (MarsClock)this.marsTime.clone();
        this.earthTime = new EarthClock(config.getEarthStartDateTime());
        this.uptimer = new UpTimer();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.elapsedlast = this.uptimer.getUptimeMillis();
        this.elapsedMilliseconds = 0L;
    }

    public MarsClock getMarsClock() {
        return this.marsTime;
    }

    public MarsClock getInitialMarsTime() {
        return this.initialMarsTime;
    }

    public EarthClock getEarthClock() {
        return this.earthTime;
    }

    public UpTimer getUpTimer() {
        return this.uptimer;
    }

    public final void addClockListener(ClockListener newListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.listeners.contains(newListener)) {
            this.listeners.add(newListener);
        }
    }

    public final void removeClockListener(ClockListener oldListener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        if (this.listeners.contains(oldListener)) {
            this.listeners.remove(oldListener);
        }
    }

    public void loadSimulation(File file) {
        this.setPaused(false);
        this.loadSimulation = true;
        this.file = file;
    }

    public boolean isLoadingSimulation() {
        return this.loadSimulation;
    }

    public void saveSimulation(File file) {
        this.saveSimulation = true;
        this.file = file;
    }

    public boolean isSavingSimulation() {
        return this.saveSimulation;
    }

    public void exitProgram() {
        this.setPaused(true);
        this.exitProgram = true;
    }

    public double getTimePulse() {
        double timePulse;
        if (this.timeRatio == 0.0) {
            this.setTimeRatio(SimulationConfig.instance().getSimulationTimeRatio());
        }
        if (this.timeRatio > 0.0) {
            double timePulseSeconds = (double)this.getElapsedmillis() * (this.timeRatio / 1000.0);
            timePulse = MarsClock.convertSecondsToMillisols(timePulseSeconds);
        } else {
            timePulse = 1.0;
        }
        ++this.totalPulses;
        return timePulse;
    }

    public long getTotalPulses() {
        return this.totalPulses;
    }

    public void setTimeRatio(double ratio) {
        if (!(ratio >= 1.0E-4) || !(ratio <= 500000.0)) {
            throw new IllegalArgumentException("Time ratio out of bounds ");
        }
        this.timeRatio = ratio;
    }

    public double getTimeRatio() {
        return this.timeRatio;
    }

    @Override
    public void run() {
        this.keepRunning = true;
        this.elapsedlast = this.uptimer.getUptimeMillis();
        while (this.keepRunning) {
            try {
                Thread.yield();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem with Thread.yield() in MasterClock.run() ", e);
            }
            if (!this.isPaused) {
                this.updateElapsedMilliseconds();
                double timePulse = this.getTimePulse();
                long startTime = System.nanoTime();
                double earthTimeDiff = (double)this.getElapsedmillis() * this.timeRatio / 1000.0;
                this.earthTime.addTime(earthTimeDiff);
                this.marsTime.addTime(timePulse);
                this.fireClockPulse(timePulse);
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (Exception e) {
                    logger.fine("Problem with Thread.yield() in MasterClock.run() ");
                }
                long endTime = System.nanoTime();
                long lastTimeDiff = (endTime - startTime) / 1000000L;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("time: " + lastTimeDiff);
                }
                try {
                    Thread.yield();
                }
                catch (Exception e) {
                    logger.fine("Problem with Thread.yield() in MasterClock.run() ");
                }
            }
            if (this.saveSimulation) {
                try {
                    Simulation.instance().saveSimulation(this.file);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Could not save the simulation with file=" + (this.file == null ? "null" : this.file.getPath()), e);
                    e.printStackTrace();
                }
                this.saveSimulation = false;
            } else if (this.loadSimulation) {
                if (this.file.exists() && this.file.canRead()) {
                    Simulation.instance().loadSimulation(this.file);
                    Simulation.instance().start();
                } else {
                    logger.warning("Cannot access file " + this.file.getPath() + ", not reading");
                }
                this.loadSimulation = false;
            }
            if (!this.exitProgram) continue;
            this.exitProgram = false;
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireClockPulse(double time) {
        List<ClockListener> list = this.listeners;
        synchronized (list) {
            for (ClockListener cl : this.listeners) {
                try {
                    cl.clockPulse(time);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error while firing clock pulse", e);
                }
            }
        }
    }

    public void stop() {
        this.keepRunning = false;
    }

    public void setPaused(boolean isPaused) {
        this.uptimer.setPaused(isPaused);
        this.isPaused = isPaused;
        this.firePauseChange();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePauseChange() {
        List<ClockListener> list = this.listeners;
        synchronized (list) {
            for (ClockListener cl : this.listeners) {
                try {
                    cl.pauseChange(this.isPaused);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error while firing pase change", e);
                }
            }
        }
    }

    public double getPulsesPerSecond() {
        return (double)this.totalPulses / ((double)this.uptimer.getUptimeMillis() / 1000.0);
    }

    private void updateElapsedMilliseconds() {
        long tnow = this.uptimer.getUptimeMillis();
        this.elapsedMilliseconds = tnow - this.elapsedlast;
        this.elapsedlast = tnow;
    }

    private long getElapsedmillis() {
        return this.elapsedMilliseconds;
    }

    public String getTimeString(double seconds) {
        long years = (int)Math.floor(seconds / 3.1536E7);
        long days = (int)(seconds % 3.1536E7 / 86400.0);
        long hours = (int)(seconds % 86400.0 / 3600.0);
        long minutes = (int)(seconds % 3600.0 / 60.0);
        double secs = seconds % 60.0;
        StringBuilder b = new StringBuilder();
        b.append(years);
        if (years > 0L) {
            b.append(":");
        }
        if (days > 0L) {
            b.append(String.format("%03d", days)).append(":");
        } else {
            b.append("0:");
        }
        if (hours > 0L) {
            b.append(String.format("%02d", hours)).append(":");
        } else {
            b.append("00:");
        }
        if (minutes > 0L) {
            b.append(String.format("%02d", minutes)).append(":");
        } else {
            b.append("00:");
        }
        b.append(String.format("%5.3f", secs));
        return b.toString();
    }

    public void destroy() {
        this.marsTime = null;
        this.initialMarsTime = null;
        this.earthTime = null;
        this.uptimer = null;
        this.listeners.clear();
        this.listeners = null;
    }
}

