/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class UpTimer
implements Serializable {
    private static final long serialVersionUID = -4992839027918134952L;
    private transient long thiscall = System.currentTimeMillis();
    private transient long lastcall = System.currentTimeMillis();
    private static final int secspmin = 60;
    private static final int secsphour = 3600;
    private static final int secspday = 86400;
    private static final int secsperyear = 31536000;
    private long days;
    private long hours;
    private long minutes;
    private long seconds;
    private long uptime = 1L;
    private long utsec = 0L;
    private transient boolean paused = true;

    public UpTimer() {
        this.setPaused(false);
        this.lastcall = System.currentTimeMillis();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastcall = System.currentTimeMillis();
    }

    public void updateTime() {
        this.utsec = this.getUptimeMillis() / 1000L;
        this.days = (int)(this.utsec % 31536000L / 86400L);
        this.hours = (int)(this.utsec % 86400L / 3600L);
        this.minutes = (int)(this.utsec % 3600L / 60L);
        this.seconds = (int)(this.utsec % 60L);
    }

    public String getUptime() {
        String minstr = "" + this.minutes;
        if (this.minutes < 10L) {
            minstr = "0" + this.minutes;
        }
        String secstr = "" + this.seconds;
        if (this.seconds < 10L) {
            secstr = "0" + this.seconds;
        }
        String daystr = "";
        daystr = this.days == 1L ? "" + this.days + " day " : "" + this.days + " days ";
        String hourstr = "" + this.hours;
        return daystr + hourstr + ":" + minstr + ":" + secstr;
    }

    public long getUptimeMillis() {
        this.thiscall = System.currentTimeMillis();
        if (this.paused) {
            return this.uptime;
        }
        this.uptime += this.thiscall - this.lastcall;
        this.lastcall = this.thiscall;
        return this.uptime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean isPaused) {
        this.paused = isPaused;
        if (!isPaused) {
            this.thiscall = this.lastcall = System.currentTimeMillis();
        }
    }
}

