/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.util.Collection;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.resource.Part;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.VehicleConfig;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public class LightUtilityVehicle
extends GroundVehicle
implements Crewable {
    public static final String NAME = "Light Utility Vehicle";
    private int crewCapacity = 0;
    private Collection<Part> attachments = null;
    private int slotNumber = 0;

    public LightUtilityVehicle(String name, String description, Settlement settlement) {
        super(name, description, settlement);
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        this.malfunctionManager.addScopeString("Crewable");
        this.malfunctionManager.addScopeString(description);
        if (config.hasLab(description)) {
            this.malfunctionManager.addScopeString("Laboratory");
        }
        if (config.hasSickbay(description)) {
            this.malfunctionManager.addScopeString("Sickbay");
        }
        if (config.hasPartAttachments(description)) {
            this.attachments = config.getAttachableParts(description);
            this.slotNumber = config.getPartAttachmentSlotNumber(description);
        }
        this.crewCapacity = config.getCrewSize(description);
        Inventory inv = this.getInventory();
        inv.addGeneralCapacity(config.getTotalCapacity(description));
        this.setTerrainHandlingCapability(0.0);
    }

    @Override
    public AmountResource getFuelType() {
        return null;
    }

    @Override
    public boolean isAppropriateOperator(VehicleOperator operator) {
        return operator instanceof Person && this.getInventory().containsUnit((Unit)((Object)operator));
    }

    @Override
    public Collection<Person> getCrew() {
        return CollectionUtils.getPerson(this.getInventory().getContainedUnits());
    }

    @Override
    public int getCrewCapacity() {
        return this.crewCapacity;
    }

    @Override
    public int getCrewNum() {
        return this.getCrew().size();
    }

    @Override
    public boolean isCrewmember(Person person) {
        return this.getInventory().containsUnit(person);
    }

    public Collection<Part> getPossibleAttachmentParts() {
        return this.attachments;
    }

    public int getAtachmentSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public void timePassing(double time) {
        super.timePassing(time);
        if (this.getCrewNum() > 0) {
            this.malfunctionManager.activeTimePassing(time);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.attachments.clear();
        this.attachments = null;
    }
}

