/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.mars_sim.msp.core.Airlock;
import org.mars_sim.msp.core.CollectionUtils;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Inventory;
import org.mars_sim.msp.core.Lab;
import org.mars_sim.msp.core.LifeSupport;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.PersonConfig;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.Airlockable;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.LightUtilityVehicle;
import org.mars_sim.msp.core.vehicle.Medical;
import org.mars_sim.msp.core.vehicle.MobileLaboratory;
import org.mars_sim.msp.core.vehicle.SickBay;
import org.mars_sim.msp.core.vehicle.Towing;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleAirlock;
import org.mars_sim.msp.core.vehicle.VehicleConfig;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public class Rover
extends GroundVehicle
implements Crewable,
LifeSupport,
Airlockable,
Medical,
Towing {
    private double NORMAL_AIR_PRESSURE = 1.0;
    private double NORMAL_TEMP = 25.0;
    public static final double LIFE_SUPPORT_RANGE_ERROR_MARGIN = 3.0;
    private int crewCapacity = 0;
    private Airlock airlock;
    private Lab lab;
    private SickBay sickbay;
    private Vehicle towedVehicle;

    public Rover(String name, String description, Settlement settlement) {
        super(name, description, settlement);
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        this.malfunctionManager.addScopeString("Rover");
        this.malfunctionManager.addScopeString("Crewable");
        this.malfunctionManager.addScopeString("Life Support");
        this.malfunctionManager.addScopeString(description);
        if (config.hasLab(description)) {
            this.malfunctionManager.addScopeString("Laboratory");
        }
        if (config.hasSickbay(description)) {
            this.malfunctionManager.addScopeString("Sickbay");
        }
        this.crewCapacity = config.getCrewSize(description);
        Inventory inv = this.getInventory();
        inv.addGeneralCapacity(config.getTotalCapacity(description));
        AmountResource methane = AmountResource.findAmountResource("methane");
        inv.addAmountResourceTypeCapacity(methane, config.getCargoCapacity(description, "methane"));
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        inv.addAmountResourceTypeCapacity(oxygen, config.getCargoCapacity(description, "oxygen"));
        AmountResource water = AmountResource.findAmountResource("water");
        inv.addAmountResourceTypeCapacity(water, config.getCargoCapacity(description, "water"));
        AmountResource food = AmountResource.findAmountResource("food");
        inv.addAmountResourceTypeCapacity(food, config.getCargoCapacity(description, "food"));
        AmountResource rockSamples = AmountResource.findAmountResource("rock samples");
        inv.addAmountResourceTypeCapacity(rockSamples, config.getCargoCapacity(description, "rock samples"));
        AmountResource ice = AmountResource.findAmountResource("ice");
        inv.addAmountResourceTypeCapacity(ice, config.getCargoCapacity(description, "ice"));
        if (config.hasSickbay(description)) {
            this.sickbay = new SickBay(this, config.getSickbayTechLevel(description), config.getSickbayBeds(description));
        }
        if (config.hasLab(description)) {
            this.lab = new MobileLaboratory(1, config.getLabTechLevel(description), config.getLabTechSpecialities(description));
        }
        this.setTerrainHandlingCapability(0.0);
        try {
            this.airlock = new VehicleAirlock(this, 2);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void setTowedVehicle(Vehicle towedVehicle) {
        if (this == towedVehicle) {
            throw new IllegalArgumentException("Rover cannot tow itself.");
        }
        this.towedVehicle = towedVehicle;
        this.updatedTowedVehicleSettlementLocation();
    }

    @Override
    public Vehicle getTowedVehicle() {
        return this.towedVehicle;
    }

    @Override
    public int getCrewCapacity() {
        return this.crewCapacity;
    }

    @Override
    public int getCrewNum() {
        return this.getCrew().size();
    }

    @Override
    public Collection<Person> getCrew() {
        return CollectionUtils.getPerson(this.getInventory().getContainedUnits());
    }

    @Override
    public boolean isCrewmember(Person person) {
        return this.getInventory().containsUnit(person);
    }

    @Override
    public boolean lifeSupportCheck() {
        boolean result = true;
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        if (this.getInventory().getAmountResourceStored(oxygen, false) <= 0.0) {
            result = false;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        if (this.getInventory().getAmountResourceStored(water, false) <= 0.0) {
            result = false;
        }
        if (this.malfunctionManager.getOxygenFlowModifier() < 100.0) {
            result = false;
        }
        if (this.malfunctionManager.getWaterFlowModifier() < 100.0) {
            result = false;
        }
        if (this.getAirPressure() != this.NORMAL_AIR_PRESSURE) {
            result = false;
        }
        if (this.getTemperature() != this.NORMAL_TEMP) {
            result = false;
        }
        return result;
    }

    @Override
    public int getLifeSupportCapacity() {
        return this.crewCapacity;
    }

    @Override
    public double provideOxygen(double amountRequested) {
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenTaken = amountRequested;
        double oxygenLeft = this.getInventory().getAmountResourceStored(oxygen, false);
        if (oxygenTaken > oxygenLeft) {
            oxygenTaken = oxygenLeft;
        }
        this.getInventory().retrieveAmountResource(oxygen, oxygenTaken);
        return oxygenTaken * (this.malfunctionManager.getOxygenFlowModifier() / 100.0);
    }

    @Override
    public double provideWater(double amountRequested) {
        AmountResource water = AmountResource.findAmountResource("water");
        double waterTaken = amountRequested;
        double waterLeft = this.getInventory().getAmountResourceStored(water, false);
        if (waterTaken > waterLeft) {
            waterTaken = waterLeft;
        }
        this.getInventory().retrieveAmountResource(water, waterTaken);
        return waterTaken * (this.malfunctionManager.getWaterFlowModifier() / 100.0);
    }

    @Override
    public double getAirPressure() {
        double ambient;
        double result = this.NORMAL_AIR_PRESSURE * (this.malfunctionManager.getAirPressureModifier() / 100.0);
        if (result < (ambient = Simulation.instance().getMars().getWeather().getAirPressure(this.getCoordinates()))) {
            return ambient;
        }
        return result;
    }

    @Override
    public double getTemperature() {
        double ambient;
        double result = this.NORMAL_TEMP * (this.malfunctionManager.getTemperatureModifier() / 100.0);
        if (result < (ambient = Simulation.instance().getMars().getWeather().getTemperature(this.getCoordinates()))) {
            return ambient;
        }
        return result;
    }

    @Override
    public Airlock getAirlock() {
        return this.airlock;
    }

    @Override
    public void timePassing(double time) {
        super.timePassing(time);
        this.airlock.timePassing(time);
    }

    @Override
    public Collection<Person> getAffectedPeople() {
        Collection<Person> people = super.getAffectedPeople();
        Collection<Person> crew = this.getCrew();
        for (Person person : crew) {
            if (people.contains(person)) continue;
            people.add(person);
        }
        return people;
    }

    public boolean hasLab() {
        return this.lab != null;
    }

    public Lab getLab() {
        return this.lab;
    }

    public boolean hasSickBay() {
        return this.sickbay != null;
    }

    @Override
    public SickBay getSickBay() {
        return this.sickbay;
    }

    @Override
    public boolean isAppropriateOperator(VehicleOperator operator) {
        return operator instanceof Person && this.getInventory().containsUnit((Unit)((Object)operator));
    }

    @Override
    public AmountResource getFuelType() {
        try {
            return AmountResource.findAmountResource("methane");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setCoordinates(Coordinates newLocation) {
        super.setCoordinates(newLocation);
        if (this.towedVehicle != null) {
            this.towedVehicle.setCoordinates(newLocation);
        }
    }

    @Override
    public double getRange() {
        double range = super.getRange();
        double distancePerSol = this.getEstimatedTravelDistancePerSol();
        PersonConfig config = SimulationConfig.instance().getPersonConfiguration();
        AmountResource food = AmountResource.findAmountResource("food");
        double foodConsumptionRate = config.getFoodConsumptionRate();
        double foodCapacity = this.getInventory().getAmountResourceCapacity(food, false);
        double foodSols = foodCapacity / (foodConsumptionRate * (double)this.crewCapacity);
        double foodRange = distancePerSol * foodSols / 3.0;
        if (foodRange < range) {
            range = foodRange;
        }
        AmountResource water = AmountResource.findAmountResource("water");
        double waterConsumptionRate = config.getWaterConsumptionRate();
        double waterCapacity = this.getInventory().getAmountResourceCapacity(water, false);
        double waterSols = waterCapacity / (waterConsumptionRate * (double)this.crewCapacity);
        double waterRange = distancePerSol * waterSols / 3.0;
        if (waterRange < range) {
            range = waterRange;
        }
        AmountResource oxygen = AmountResource.findAmountResource("oxygen");
        double oxygenConsumptionRate = config.getOxygenConsumptionRate();
        double oxygenCapacity = this.getInventory().getAmountResourceCapacity(oxygen, false);
        double oxygenSols = oxygenCapacity / (oxygenConsumptionRate * (double)this.crewCapacity);
        double oxygenRange = distancePerSol * oxygenSols / 3.0;
        if (oxygenRange < range) {
            range = oxygenRange;
        }
        return range;
    }

    @Override
    public void setParkedLocation(double xLocation, double yLocation, double facing) {
        super.setParkedLocation(xLocation, yLocation, facing);
        this.updatedTowedVehicleSettlementLocation();
    }

    private void updatedTowedVehicleSettlementLocation() {
        Vehicle towedVehicle = this.getTowedVehicle();
        if (towedVehicle != null) {
            if (towedVehicle instanceof Rover) {
                double distance = (this.getLength() + towedVehicle.getLength()) / 2.0;
                double angle = this.getFacing() + 180.0;
                double radAngle = angle * (Math.PI / 180);
                double towedX = 0.0 - distance * Math.sin(radAngle);
                double towedY = distance * Math.cos(radAngle);
                Point2D.Double towedLoc = LocalAreaUtil.getLocalRelativeLocation(towedX, towedY, this);
                towedVehicle.setParkedLocation(towedLoc.getX(), towedLoc.getY(), this.getFacing());
            } else if (towedVehicle instanceof LightUtilityVehicle) {
                double distance = (this.getLength() + towedVehicle.getWidth()) / 2.0;
                double angle = this.getFacing() + 180.0;
                double radAngle = angle * (Math.PI / 180);
                double towedX = 0.0 - distance * Math.sin(radAngle);
                double towedY = distance * Math.cos(radAngle);
                Point2D.Double towedLoc = LocalAreaUtil.getLocalRelativeLocation(towedX, towedY, this);
                towedVehicle.setParkedLocation(towedLoc.getX(), towedLoc.getY(), this.getFacing() + 90.0);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.airlock != null) {
            this.airlock.destroy();
        }
        this.airlock = null;
        if (this.lab != null) {
            this.lab.destroy();
        }
        this.lab = null;
        if (this.sickbay != null) {
            this.sickbay.destroy();
        }
        this.sickbay = null;
        this.towedVehicle = null;
    }
}

