/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Direction;
import org.mars_sim.msp.core.LocalAreaUtil;
import org.mars_sim.msp.core.LocalBoundedObject;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.SimulationConfig;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.malfunction.MalfunctionManager;
import org.mars_sim.msp.core.malfunction.Malfunctionable;
import org.mars_sim.msp.core.manufacture.Salvagable;
import org.mars_sim.msp.core.manufacture.SalvageInfo;
import org.mars_sim.msp.core.manufacture.SalvageProcessInfo;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.task.Maintenance;
import org.mars_sim.msp.core.person.ai.task.Repair;
import org.mars_sim.msp.core.person.ai.task.Task;
import org.mars_sim.msp.core.resource.AmountResource;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.time.MarsClock;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.VehicleConfig;
import org.mars_sim.msp.core.vehicle.VehicleOperator;

public abstract class Vehicle
extends Unit
implements Serializable,
Malfunctionable,
Salvagable,
LocalBoundedObject {
    private static Logger logger = Logger.getLogger(Vehicle.class.getName());
    public static final String STATUS_EVENT = "vehicle status";
    public static final String SPEED_EVENT = "vehicle speed";
    public static final String OPERATOR_EVENT = "vehicle operator";
    public static final String EMERGENCY_BEACON_EVENT = "vehicle emergency beacon event";
    public static final String RESERVED_EVENT = "vehicle reserved event";
    public static final String PARKED = "Parked";
    public static final String MOVING = "Moving";
    public static final String MALFUNCTION = "Malfunction";
    public static final String MAINTENANCE = "Periodic Maintenance";
    public static final String TOWED = "Towed";
    public static final double RANGE_ERROR_MARGIN = 1.7;
    private static final double WEAR_LIFETIME = 668000.0;
    private static final double MAINTENANCE_TIME = 500.0;
    protected MalfunctionManager malfunctionManager;
    private Direction direction;
    private double speed = 0.0;
    private double baseSpeed = 0.0;
    private VehicleOperator vehicleOperator;
    private double distanceTraveled = 0.0;
    private double distanceMaint = 0.0;
    private double fuelEfficiency;
    private boolean isReservedMission = false;
    private boolean distanceMark = false;
    private ArrayList<Coordinates> trail;
    private boolean reservedForMaintenance = false;
    private boolean emergencyBeacon = false;
    private Vehicle towingVehicle;
    private String status;
    private boolean isSalvaged;
    private SalvageInfo salvageInfo;
    private double width;
    private double length;
    private double xLocParked;
    private double yLocParked;
    private double facingParked;

    protected Vehicle(String name, String description, Settlement settlement, double baseSpeed, double baseMass, double fuelEfficiency) {
        super(name, settlement.getCoordinates());
        settlement.getInventory().storeUnit(this);
        this.setDescription(description);
        this.direction = new Direction(0.0);
        this.trail = new ArrayList();
        this.setBaseSpeed(baseSpeed);
        this.setBaseMass(baseMass);
        this.fuelEfficiency = fuelEfficiency;
        this.status = PARKED;
        this.isSalvaged = false;
        this.salvageInfo = null;
        this.width = 0.0;
        this.length = 0.0;
        this.xLocParked = 0.0;
        this.yLocParked = 0.0;
        this.facingParked = 0.0;
        this.malfunctionManager = new MalfunctionManager(this, 668000.0, 500.0);
        this.malfunctionManager.addScopeString("Vehicle");
    }

    Vehicle(String name, String description, Settlement settlement) {
        super(name, settlement.getCoordinates());
        settlement.getInventory().storeUnit(this);
        this.setDescription(description);
        this.direction = new Direction(0.0);
        this.trail = new ArrayList();
        this.status = PARKED;
        this.malfunctionManager = new MalfunctionManager(this, 668000.0, 500.0);
        this.malfunctionManager.addScopeString("Vehicle");
        VehicleConfig config = SimulationConfig.instance().getVehicleConfiguration();
        this.width = config.getWidth(description);
        this.length = config.getLength(description);
        this.setBaseSpeed(config.getBaseSpeed(description));
        this.setBaseMass(config.getEmptyMass(description));
        this.fuelEfficiency = config.getFuelEfficiency(this.getDescription());
        this.determinedSettlementParkedLocationAndFacing();
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public double getXLocation() {
        return this.xLocParked;
    }

    @Override
    public double getYLocation() {
        return this.yLocParked;
    }

    @Override
    public double getFacing() {
        return this.facingParked;
    }

    public void setParkedLocation(double xLocation, double yLocation, double facing) {
        this.xLocParked = xLocation;
        this.yLocParked = yLocation;
        this.facingParked = facing;
        this.setCrewLocation();
    }

    private void setCrewLocation() {
        if (this instanceof Crewable) {
            for (Person crewmember : ((Crewable)((Object)this)).getCrew()) {
                Point2D.Double vehicleLoc = LocalAreaUtil.getRandomInteriorLocation(this);
                Point2D.Double settlementLoc = LocalAreaUtil.getLocalRelativeLocation(vehicleLoc.getX(), vehicleLoc.getY(), this);
                crewmember.setXLocation(settlementLoc.getX());
                crewmember.setYLocation(settlementLoc.getY());
            }
        }
    }

    public String getStatus() {
        this.updateStatus();
        return this.status;
    }

    private void updateStatus() {
        String newStatus = PARKED;
        if (this.reservedForMaintenance) {
            newStatus = MAINTENANCE;
        } else if (this.towingVehicle != null) {
            newStatus = TOWED;
        } else if (this.malfunctionManager.hasMalfunction()) {
            newStatus = MALFUNCTION;
        } else if (this.speed > 0.0) {
            newStatus = MOVING;
        }
        if (!this.status.equals(newStatus)) {
            this.status = newStatus;
            this.fireUnitUpdate(STATUS_EVENT, newStatus);
        }
    }

    public boolean isReserved() {
        return this.isReservedMission || this.reservedForMaintenance;
    }

    public boolean isReservedForMission() {
        return this.isReservedMission;
    }

    public void setReservedForMission(boolean reserved) {
        if (this.isReservedMission != reserved) {
            this.isReservedMission = reserved;
            this.fireUnitUpdate(RESERVED_EVENT);
        }
    }

    public boolean isReservedForMaintenance() {
        return this.reservedForMaintenance;
    }

    public void setReservedForMaintenance(boolean reserved) {
        if (this.reservedForMaintenance != reserved) {
            this.reservedForMaintenance = reserved;
            this.fireUnitUpdate(RESERVED_EVENT);
        }
    }

    public void setTowingVehicle(Vehicle towingVehicle) {
        if (this == towingVehicle) {
            throw new IllegalArgumentException("Vehicle cannot tow itself.");
        }
        this.towingVehicle = towingVehicle;
    }

    public Vehicle getTowingVehicle() {
        return this.towingVehicle;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Vehicle speed cannot be less than 0 km/hr: " + speed);
        }
        this.speed = speed;
        this.fireUnitUpdate(SPEED_EVENT);
    }

    public double getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Vehicle base speed cannot be less than 0 km/hr");
        }
        this.baseSpeed = speed;
    }

    public double getRange() {
        double fuelCapacity = this.getInventory().getAmountResourceCapacity(this.getFuelType(), false);
        return fuelCapacity * this.fuelEfficiency / 1.7;
    }

    public double getFuelEfficiency() {
        return this.fuelEfficiency;
    }

    public double getTotalDistanceTraveled() {
        return this.distanceTraveled;
    }

    public void addTotalDistanceTraveled(double distance) {
        this.distanceTraveled += distance;
    }

    public double getDistanceLastMaintenance() {
        return this.distanceMaint;
    }

    public void addDistanceLastMaintenance(double distance) {
        this.distanceMaint += distance;
        if (this.distanceMaint > 5000.0 && !this.distanceMark) {
            this.distanceMark = true;
        }
    }

    public void clearDistanceLastMaintenance() {
        this.distanceMaint = 0.0;
    }

    public Direction getDirection() {
        return (Direction)this.direction.clone();
    }

    public void setDirection(Direction direction) {
        this.direction.setDirection(direction.getDirection());
    }

    public VehicleOperator getOperator() {
        return this.vehicleOperator;
    }

    public void setOperator(VehicleOperator vehicleOperator) {
        this.vehicleOperator = vehicleOperator;
        this.fireUnitUpdate(OPERATOR_EVENT, vehicleOperator);
    }

    public abstract boolean isAppropriateOperator(VehicleOperator var1);

    public Settlement getSettlement() {
        Unit topUnit = this.getTopContainerUnit();
        if (topUnit != null && topUnit instanceof Settlement) {
            return (Settlement)topUnit;
        }
        return null;
    }

    @Override
    public MalfunctionManager getMalfunctionManager() {
        return this.malfunctionManager;
    }

    @Override
    public void timePassing(double time) {
        Person personOperator;
        VehicleOperator operator;
        this.updateStatus();
        if (this.getStatus().equals(MOVING)) {
            this.malfunctionManager.activeTimePassing(time);
        }
        this.malfunctionManager.timePassing(time);
        this.addToTrail(this.getCoordinates());
        if (this.getStatus().equals(MAINTENANCE) && this.malfunctionManager.getEffectiveTimeSinceLastMaintenance() <= 0.0) {
            this.setReservedForMaintenance(false);
        }
        if (this.isReservedMission) {
            if (Simulation.instance().getMissionManager().getMissionForVehicle(this) == null) {
                logger.log(Level.SEVERE, this.getName() + " is mission reserved but has no mission.");
                this.setReservedForMission(false);
            }
        } else if (Simulation.instance().getMissionManager().getMissionForVehicle(this) != null) {
            logger.log(Level.SEVERE, this.getName() + " is not mission reserved but is on a mission.");
        }
        if ((operator = this.vehicleOperator) != null && operator instanceof Person && (personOperator = (Person)operator).getPhysicalCondition().isDead()) {
            this.setOperator(null);
            this.setSpeed(0.0);
            this.setParkedLocation(0.0, 0.0, this.getDirection().getDirection());
        }
    }

    @Override
    public Collection<Person> getAffectedPeople() {
        ConcurrentLinkedQueue<Person> people = new ConcurrentLinkedQueue<Person>();
        for (Person person : Simulation.instance().getUnitManager().getPeople()) {
            Task task = person.getMind().getTaskManager().getTask();
            if (task instanceof Maintenance && ((Maintenance)task).getEntity() == this && !people.contains(person)) {
                people.add(person);
            }
            if (!(task instanceof Repair) || ((Repair)((Object)task)).getEntity() != this || people.contains(person)) continue;
            people.add(person);
        }
        return people;
    }

    public Collection<Coordinates> getTrail() {
        return this.trail;
    }

    public void addToTrail(Coordinates location) {
        if (this.getSettlement() != null) {
            if (this.trail.size() > 0) {
                this.trail.clear();
            }
        } else if (this.trail.size() > 0) {
            Coordinates lastLocation = this.trail.get(this.trail.size() - 1);
            if (!lastLocation.equals(location) && lastLocation.getDistance(location) >= 2.0) {
                this.trail.add(new Coordinates(location));
            }
        } else {
            this.trail.add(new Coordinates(location));
        }
    }

    public abstract AmountResource getFuelType();

    public double getEstimatedTravelDistancePerSol() {
        double estSpeed = this.baseSpeed / 2.0;
        return estSpeed / 60.0 / 60.0 / MarsClock.convertSecondsToMillisols(1.0) * 1000.0;
    }

    public boolean isEmergencyBeacon() {
        return this.emergencyBeacon;
    }

    public void setEmergencyBeacon(boolean isOn) {
        if (this.emergencyBeacon != isOn) {
            this.emergencyBeacon = isOn;
            this.fireUnitUpdate(EMERGENCY_BEACON_EVENT);
        }
    }

    @Override
    public boolean isSalvaged() {
        return this.isSalvaged;
    }

    @Override
    public void startSalvage(SalvageProcessInfo info, Settlement settlement) {
        this.salvageInfo = new SalvageInfo(this, info, settlement);
        this.isSalvaged = true;
    }

    @Override
    public SalvageInfo getSalvageInfo() {
        return this.salvageInfo;
    }

    public abstract void determinedSettlementParkedLocationAndFacing();

    @Override
    public void destroy() {
        super.destroy();
        this.malfunctionManager.destroy();
        this.malfunctionManager = null;
        this.direction = null;
        this.vehicleOperator = null;
        this.trail.clear();
        this.trail = null;
        this.towingVehicle = null;
        this.status = null;
        if (this.salvageInfo != null) {
            this.salvageInfo.destroy();
        }
        this.salvageInfo = null;
    }
}

