/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.core.vehicle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.mars_sim.msp.core.resource.Part;

public class VehicleConfig
implements Serializable {
    private static final String VEHICLE = "vehicle";
    private static final String TYPE = "type";
    private static final String WIDTH = "width";
    private static final String LENGTH = "length";
    private static final String FUEL_EFFICIENCY = "fuel-efficiency";
    private static final String BASE_SPEED = "base-speed";
    private static final String EMPTY_MASS = "empty-mass";
    private static final String CREW_SIZE = "crew-size";
    private static final String CARGO = "cargo";
    private static final String TOTAL_CAPACITY = "total-capacity";
    private static final String CAPACITY = "capacity";
    private static final String RESOURCE = "resource";
    private static final String VALUE = "value";
    private static final String SICKBAY = "sickbay";
    private static final String LAB = "lab";
    private static final String TECH_LEVEL = "tech-level";
    private static final String BEDS = "beds";
    private static final String TECH_SPECIALITY = "tech-speciality";
    private static final String PART_ATTACHMENT = "part-attachment";
    private static final String NUMBER_SLOTS = "number-slots";
    private static final String PART = "part";
    private static final String NAME = "name";
    private static final String ROVER_NAME_LIST = "rover-name-list";
    private static final String ROVER_NAME = "rover-name";
    private Document vehicleDoc;
    private List<String> roverNames;

    public VehicleConfig(Document vehicleDoc) {
        this.vehicleDoc = vehicleDoc;
    }

    public Set<String> getVehicleTypes() {
        Element root = this.vehicleDoc.getRootElement();
        List vehicleNodes = root.getChildren(VEHICLE);
        HashSet<String> types = new HashSet<String>(vehicleNodes.size());
        for (Element vehicleElement : vehicleNodes) {
            types.add(vehicleElement.getAttributeValue(TYPE));
        }
        return types;
    }

    private Element getVehicleElement(String vehicleType) {
        Element result = null;
        Element root = this.vehicleDoc.getRootElement();
        List vehicleNodes = root.getChildren(VEHICLE);
        for (Element vehicleElement : vehicleNodes) {
            String type = vehicleElement.getAttributeValue(TYPE);
            if (!vehicleType.equalsIgnoreCase(type)) continue;
            result = vehicleElement;
        }
        if (result == null) {
            throw new IllegalStateException("Vehicle type: " + vehicleType + " could not be found in vehicles.xml.");
        }
        return result;
    }

    public double getWidth(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        String widthString = vehicleElement.getAttributeValue(WIDTH);
        double result = Double.parseDouble(widthString);
        return result;
    }

    public double getLength(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        String lengthString = vehicleElement.getAttributeValue(LENGTH);
        double result = Double.parseDouble(lengthString);
        return result;
    }

    public double getFuelEfficiency(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element fuelEfficiencyElement = vehicleElement.getChild(FUEL_EFFICIENCY);
        return Double.parseDouble(fuelEfficiencyElement.getAttributeValue(VALUE));
    }

    public double getBaseSpeed(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element baseSpeedElement = vehicleElement.getChild(BASE_SPEED);
        return Double.parseDouble(baseSpeedElement.getAttributeValue(VALUE));
    }

    public double getEmptyMass(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element emptyMassElement = vehicleElement.getChild(EMPTY_MASS);
        return Double.parseDouble(emptyMassElement.getAttributeValue(VALUE));
    }

    public int getCrewSize(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element crewSizeElement = vehicleElement.getChild(CREW_SIZE);
        return Integer.parseInt(crewSizeElement.getAttributeValue(VALUE));
    }

    public double getTotalCapacity(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element cargoElement = vehicleElement.getChild(CARGO);
        return Double.parseDouble(cargoElement.getAttributeValue(TOTAL_CAPACITY));
    }

    public double getCargoCapacity(String vehicleType, String resource) {
        double resourceCapacity = 0.0;
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element cargoElement = vehicleElement.getChild(CARGO);
        List capacityList = cargoElement.getChildren(CAPACITY);
        for (Element capacityElement : capacityList) {
            if (!resource.toLowerCase().equals(capacityElement.getAttributeValue(RESOURCE).toLowerCase())) continue;
            resourceCapacity = Double.parseDouble(capacityElement.getAttributeValue(VALUE));
        }
        return resourceCapacity;
    }

    public boolean hasSickbay(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        List sickbayNodes = vehicleElement.getChildren(SICKBAY);
        return sickbayNodes.size() > 0;
    }

    public int getSickbayTechLevel(String vehicleType) {
        int sickbayTechLevel = -1;
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element sickbayElement = vehicleElement.getChild(SICKBAY);
        if (sickbayElement != null) {
            sickbayTechLevel = Integer.parseInt(sickbayElement.getAttributeValue(TECH_LEVEL));
        }
        return sickbayTechLevel;
    }

    public int getSickbayBeds(String vehicleType) {
        int sickbayBeds = -1;
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element sickbayElement = vehicleElement.getChild(SICKBAY);
        if (sickbayElement != null) {
            sickbayBeds = Integer.parseInt(sickbayElement.getAttributeValue(BEDS));
        }
        return sickbayBeds;
    }

    public boolean hasLab(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        List labNodes = vehicleElement.getChildren(LAB);
        return labNodes.size() > 0;
    }

    public int getLabTechLevel(String vehicleType) {
        int labTechLevel = -1;
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element labElement = vehicleElement.getChild(LAB);
        if (labElement != null) {
            labTechLevel = Integer.parseInt(labElement.getAttributeValue(TECH_LEVEL));
        }
        return labTechLevel;
    }

    public List<String> getLabTechSpecialities(String vehicleType) {
        ArrayList<String> specialities = new ArrayList<String>();
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element labElement = vehicleElement.getChild(LAB);
        if (labElement != null) {
            List techSpecialityNodes = labElement.getChildren(TECH_SPECIALITY);
            for (Element techSpecialityElement : techSpecialityNodes) {
                specialities.add(techSpecialityElement.getAttributeValue(VALUE));
            }
        }
        return specialities;
    }

    public boolean hasPartAttachments(String vehicleType) {
        Element vehicleElement = this.getVehicleElement(vehicleType);
        List partAttachmentNodes = vehicleElement.getChildren(PART_ATTACHMENT);
        return partAttachmentNodes.size() > 0;
    }

    public int getPartAttachmentSlotNumber(String vehicleType) {
        int result = 0;
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element partAttachmentElement = vehicleElement.getChild(PART_ATTACHMENT);
        if (partAttachmentElement != null) {
            result = Integer.parseInt(partAttachmentElement.getAttributeValue(NUMBER_SLOTS));
        }
        return result;
    }

    public Collection<Part> getAttachableParts(String vehicleType) {
        ArrayList<Part> result = new ArrayList<Part>();
        Element vehicleElement = this.getVehicleElement(vehicleType);
        Element partAttachmentElement = vehicleElement.getChild(PART_ATTACHMENT);
        if (partAttachmentElement != null) {
            List partNodes = partAttachmentElement.getChildren(PART);
            for (Element partElement : partNodes) {
                String partName = partElement.getAttributeValue(NAME);
                Part part = (Part)Part.findItemResource(partName);
                result.add(part);
            }
        }
        return result;
    }

    public List<String> getRoverNameList() {
        if (this.roverNames == null) {
            this.roverNames = new ArrayList<String>();
            Element root = this.vehicleDoc.getRootElement();
            Element vehicleNameListElement = root.getChild(ROVER_NAME_LIST);
            List vehicleNameNodes = vehicleNameListElement.getChildren(ROVER_NAME);
            for (Element vehicleNameElement : vehicleNameNodes) {
                this.roverNames.add(vehicleNameElement.getAttributeValue(VALUE));
            }
        }
        return this.roverNames;
    }

    public void destroy() {
        this.vehicleDoc = null;
        if (this.roverNames != null) {
            this.roverNames.clear();
            this.roverNames = null;
        }
    }
}

