/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.IteratorChain;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class CompositeCollection
extends AbstractCollection {
    private Collection[] collectionArray;

    public CompositeCollection(Collection[] collections) {
        this.collectionArray = collections;
    }

    public CompositeCollection(Collection collections) {
        this.collectionArray = new Collection[collections.size()];
        this.collectionArray = collections.toArray(this.collectionArray);
    }

    public CompositeCollection(Collection a, Collection b) {
        this.collectionArray = new Collection[]{a, b};
    }

    public int size() {
        int size = 0;
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            size += this.collectionArray[i].size();
        }
        return size;
    }

    public boolean isEmpty() {
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            if (this.collectionArray[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean add(Object object) {
        return this.collectionArray[this.collectionArray.length - 1].add(object);
    }

    public boolean remove(Object object) {
        for (int i = 0; i < this.collectionArray.length; ++i) {
            if (!this.collectionArray[i].remove(object)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            if (!this.collectionArray[i].contains(object)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        Iterator[] iteratorArray = new Iterator[this.collectionArray.length];
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            iteratorArray[i] = this.collectionArray[i].iterator();
        }
        return new IteratorChain(iteratorArray);
    }

    public boolean addAll(Collection c) {
        return this.collectionArray[this.collectionArray.length - 1].addAll(c);
    }

    public boolean removeAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            modified |= this.collectionArray[i].removeAll(c);
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        if (c.isEmpty()) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean modified = false;
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            modified |= this.collectionArray[i].retainAll(c);
        }
        return modified;
    }

    public void clear() {
        for (int i = this.collectionArray.length - 1; i >= 0; --i) {
            this.collectionArray[i].clear();
        }
    }
}

