/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.LoggingIterator;
import com.phoenixst.collections.LoggingSupport;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggingCollection
extends LoggingSupport
implements Collection {
    private static final Logger DEFAULT_LOGGER = Logger.getLogger((Class)(class$com$phoenixst$collections$LoggingCollection == null ? (class$com$phoenixst$collections$LoggingCollection = LoggingCollection.class$("com.phoenixst.collections.LoggingCollection")) : class$com$phoenixst$collections$LoggingCollection));
    private final Collection delegate;
    static /* synthetic */ Class class$com$phoenixst$collections$LoggingCollection;

    public LoggingCollection(Collection delegate) {
        this(delegate, DEFAULT_LOGGER, Level.DEBUG);
    }

    public LoggingCollection(Collection delegate, Logger logger) {
        this(delegate, logger, Level.DEBUG);
    }

    public LoggingCollection(Collection delegate, Logger logger, Level level) {
        super(logger, level);
        this.delegate = delegate;
        if (delegate == null) {
            throw new NullPointerException();
        }
    }

    protected final Collection getDelegate() {
        return this.delegate;
    }

    public int size() {
        if (this.isLoggerEnabled()) {
            this.log("Begin size()");
            int size = this.delegate.size();
            this.log("End size(), returns " + size);
            return size;
        }
        return this.delegate.size();
    }

    public boolean isEmpty() {
        if (this.isLoggerEnabled()) {
            this.log("Begin isEmpty()");
            boolean isEmpty = this.delegate.isEmpty();
            this.log("End isEmpty(), returns " + isEmpty);
            return isEmpty;
        }
        return this.delegate.isEmpty();
    }

    public void clear() {
        if (this.isLoggerEnabled()) {
            this.log("Begin clear()");
            this.delegate.clear();
            this.log("End clear()");
            return;
        }
        this.delegate.clear();
    }

    public boolean add(Object object) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(object);
            this.log("Begin add( " + argString + " )");
            boolean modified = this.delegate.add(object);
            this.log("End add( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.add(object);
    }

    public boolean remove(Object object) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(object);
            this.log("Begin remove( " + argString + " )");
            boolean modified = this.delegate.remove(object);
            this.log("End remove( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.remove(object);
    }

    public boolean contains(Object object) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(object);
            this.log("Begin contains( " + argString + " )");
            boolean contains = this.delegate.contains(object);
            this.log("End contains( " + argString + " ), returns " + contains);
            return contains;
        }
        return this.delegate.contains(object);
    }

    public Iterator iterator() {
        if (this.isLoggerEnabled()) {
            this.log("Begin iterator()");
            Iterator iterator = this.delegate.iterator();
            this.log("End iterator(), returns " + iterator);
            return new LoggingIterator(iterator, this.getLogger(), this.getLevel());
        }
        return new LoggingIterator(this.delegate.iterator(), this.getLogger(), this.getLevel());
    }

    public boolean addAll(Collection c) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(c);
            this.log("Begin addAll( " + argString + " )");
            boolean modified = this.delegate.addAll(c);
            this.log("End addAll( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.addAll(c);
    }

    public boolean containsAll(Collection c) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(c);
            this.log("Begin containsAll( " + argString + " )");
            boolean containsAll = this.delegate.containsAll(c);
            this.log("End containsAll( " + argString + " ), returns " + containsAll);
            return containsAll;
        }
        return this.delegate.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(c);
            this.log("Begin removeAll( " + argString + " )");
            boolean modified = this.delegate.removeAll(c);
            this.log("End removeAll( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(c);
            this.log("Begin retainAll( " + argString + " )");
            boolean modified = this.delegate.retainAll(c);
            this.log("End retainAll( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.retainAll(c);
    }

    public Object[] toArray() {
        if (this.isLoggerEnabled()) {
            this.log("Begin toArray()");
            Object[] array = this.delegate.toArray();
            this.log("End toArray(), returns " + array);
            return array;
        }
        return this.delegate.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.isLoggerEnabled()) {
            this.log("Begin toArray()");
            Object[] array = this.delegate.toArray(a);
            this.log("End toArray(), returns " + array);
            return array;
        }
        return this.delegate.toArray(a);
    }

    public boolean equals(Object object) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(object);
            this.log("Begin equals( " + argString + " )");
            boolean equals = ((Object)this.delegate).equals(object);
            this.log("End equals( " + argString + " ), returns " + equals);
            return equals;
        }
        return ((Object)this.delegate).equals(object);
    }

    public int hashCode() {
        if (this.isLoggerEnabled()) {
            this.log("Begin hashCode()");
            int hashCode = ((Object)this.delegate).hashCode();
            this.log("End hashCode(), returns " + hashCode);
            return hashCode;
        }
        return ((Object)this.delegate).hashCode();
    }

    public String toString() {
        if (this.isLoggerEnabled()) {
            this.log("Begin toString()");
            String string = this.delegate.toString();
            this.log("End toString(), returns " + string);
            return string;
        }
        return this.delegate.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

