/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.AllPredicate;
import com.phoenixst.collections.AndPredicate;
import com.phoenixst.collections.AnyPredicate;
import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.FalsePredicate;
import com.phoenixst.collections.IdentityPredicate;
import com.phoenixst.collections.InstanceofPredicate;
import com.phoenixst.collections.NotPredicate;
import com.phoenixst.collections.OrPredicate;
import com.phoenixst.collections.TruePredicate;
import java.util.Collection;
import org.apache.commons.collections.Predicate;

public class PredicateUtils {
    private PredicateUtils() {
    }

    public static Predicate truePredicate() {
        return TruePredicate.INSTANCE;
    }

    public static Predicate falsePredicate() {
        return FalsePredicate.INSTANCE;
    }

    public static Predicate notPredicate(Predicate pred) {
        return new NotPredicate(pred);
    }

    public static Predicate andPredicate(Predicate left, Predicate right) {
        return new AndPredicate(left, right);
    }

    public static Predicate orPredicate(Predicate left, Predicate right) {
        return new OrPredicate(left, right);
    }

    public static Predicate allPredicate(Predicate[] predicates) {
        return new AllPredicate(predicates);
    }

    public static Predicate allPredicate(Collection predicates) {
        return new AllPredicate(predicates);
    }

    public static Predicate anyPredicate(Predicate[] predicates) {
        return new AnyPredicate(predicates);
    }

    public static Predicate anyPredicate(Collection predicates) {
        return new AnyPredicate(predicates);
    }

    public static Predicate equalPredicate(Object testObject) {
        return new EqualPredicate(testObject);
    }

    public static Predicate identityPredicate(Object testObject) {
        return new IdentityPredicate(testObject);
    }

    public static Predicate instanceofPredicate(Class testClass) {
        return new InstanceofPredicate(testClass);
    }
}

