/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.Reapable;
import com.phoenixst.collections.Reaper;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ReapableCollection
extends AbstractCollection
implements Reapable {
    private Reaper reaper;
    private List list;
    private List backupList;

    public ReapableCollection() {
        this(Reaper.DEFAULT_REAPER);
    }

    public ReapableCollection(Reaper reaper) {
        this.reaper = reaper;
        this.list = new ArrayList();
        this.backupList = new ArrayList();
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("Null elements are not permitted.");
        }
        ReapableCollection reapableCollection = this;
        synchronized (reapableCollection) {
            return this.list.add(this.reaper.createReference(this, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        ReapableCollection reapableCollection = this;
        synchronized (reapableCollection) {
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                WeakReference ref = (WeakReference)this.list.get(i);
                if (!object.equals(ref.get())) continue;
                this.list.remove(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        ReapableCollection reapableCollection = this;
        synchronized (reapableCollection) {
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                WeakReference ref = (WeakReference)this.list.get(i);
                if (!object.equals(ref.get())) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator iterator() {
        return new IteratorImpl(this.list);
    }

    public boolean removeAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            WeakReference ref = (WeakReference)this.list.get(i);
            Object referent = ref.get();
            if (referent == null) continue;
            if (!c.contains(referent)) {
                this.backupList.add(ref);
                continue;
            }
            modified = true;
        }
        List temp = this.list;
        this.list = this.backupList;
        this.backupList = temp;
        this.backupList.clear();
        return modified;
    }

    public synchronized boolean retainAll(Collection c) {
        if (c.isEmpty()) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean modified = false;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            WeakReference ref = (WeakReference)this.list.get(i);
            Object referent = ref.get();
            if (referent == null) continue;
            if (c.contains(referent)) {
                this.backupList.add(ref);
                continue;
            }
            modified = true;
        }
        List temp = this.list;
        this.list = this.backupList;
        this.backupList = temp;
        this.backupList.clear();
        return modified;
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized Object[] toArray() {
        return super.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return super.toArray(a);
    }

    public synchronized String toString() {
        return super.toString();
    }

    public synchronized void reap() {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            WeakReference ref = (WeakReference)this.list.get(i);
            if (ref.get() == null) continue;
            this.backupList.add(ref);
        }
        List temp = this.list;
        this.list = this.backupList;
        this.backupList = temp;
        this.backupList.clear();
    }

    private static class IteratorImpl
    implements Iterator {
        private List list;
        private int currentIndex;
        private int nextIndex;
        private Object current;
        private Object next;

        private IteratorImpl(List list) {
            this.list = list;
            this.currentIndex = list.size();
            this.nextIndex = -1;
            this.current = null;
            this.next = null;
        }

        public boolean hasNext() {
            if (this.next == null) {
                this.nextIndex = this.currentIndex;
                while (this.nextIndex > 0) {
                    --this.nextIndex;
                    WeakReference ref = (WeakReference)this.list.get(this.nextIndex);
                    Object referent = ref.get();
                    if (referent == null) continue;
                    this.next = referent;
                    break;
                }
            }
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.currentIndex = this.nextIndex;
            this.next = null;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.list.remove(this.currentIndex);
            this.current = null;
        }
    }
}

