/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.collections;

import com.phoenixst.collections.Reapable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Reaper
extends Thread {
    private static final long DEFAULT_SLEEP = 100L;
    public static final Reaper DEFAULT_REAPER = new Reaper("DefaultReaper");
    ReferenceQueue refQueue;
    private long sleepTime;
    private Set reapableSet;

    public Reaper(String name) {
        this(name, 100L, 1);
    }

    public Reaper(String name, long sleepTime, int priority) {
        super(name);
        this.sleepTime = sleepTime;
        this.setPriority(priority);
        this.setDaemon(true);
        this.refQueue = new ReferenceQueue();
        this.reapableSet = new HashSet();
    }

    public WeakReference createReference(Reapable reapable, Object referent) {
        return new ReferenceImpl(reapable, referent);
    }

    public void run() {
        while (true) {
            Reference reference = null;
            try {
                reference = this.refQueue.remove();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (reference != null) {
                this.reapableSet.add(((ReferenceImpl)reference).reapable);
                reference = this.refQueue.poll();
            }
            Iterator i = this.reapableSet.iterator();
            while (i.hasNext()) {
                ((Reapable)i.next()).reap();
            }
            this.reapableSet.clear();
            try {
                Reaper.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        DEFAULT_REAPER.start();
    }

    private class ReferenceImpl
    extends WeakReference {
        Reapable reapable;

        public ReferenceImpl(Reapable reapable, Object referent) {
            super(referent, Reaper.this.refQueue);
            this.reapable = reapable;
        }
    }
}

