/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.DepthFirstTraverser;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.OrientedForestView;
import java.util.ArrayList;

public abstract class AbstractOrientedForestView
implements OrientedForestView {
    protected AbstractOrientedForestView() {
    }

    public Object getParent(Object node) {
        Graph.Edge edge = this.getParentEdge(node);
        return edge != null ? edge.getOtherEndpoint(node) : null;
    }

    public boolean isForestEdge(Graph.Edge edge) {
        return ((Object)edge).equals(this.getParentEdge(edge.getTail())) || ((Object)edge).equals(this.getParentEdge(edge.getHead()));
    }

    public Object getParentEndpoint(Graph.Edge edge) {
        Object tail = edge.getTail();
        Object head = edge.getHead();
        if (((Object)edge).equals(this.getParentEdge(tail))) {
            return head;
        }
        if (((Object)edge).equals(this.getParentEdge(head))) {
            return tail;
        }
        throw new IllegalArgumentException("Edge is not a forest edge: " + edge);
    }

    public Object getRoot(Object node) {
        Graph.Edge edge = this.getParentEdge(node);
        while (edge != null) {
            node = edge.getOtherEndpoint(node);
            edge = this.getParentEdge(node);
        }
        return node;
    }

    public boolean isLeaf(Object node) {
        return !this.childTraverser(node).hasNext();
    }

    public boolean isAncestor(Object ancestor, Object descendant) {
        this.getParentEdge(ancestor);
        while (true) {
            if (GraphUtils.equals(ancestor, descendant)) {
                return true;
            }
            Graph.Edge edge = this.getParentEdge(descendant);
            if (edge == null) break;
            descendant = edge.getOtherEndpoint(descendant);
        }
        return false;
    }

    public Object getLeastCommonAncestor(Object aNode, Object bNode) {
        ArrayList<Object> aList = new ArrayList<Object>();
        aList.add(aNode);
        Graph.Edge edge = this.getParentEdge(aNode);
        while (edge != null) {
            aNode = edge.getOtherEndpoint(aNode);
            aList.add(aNode);
            edge = this.getParentEdge(aNode);
        }
        aList.add(null);
        ArrayList<Object> bList = new ArrayList<Object>();
        bList.add(bNode);
        edge = this.getParentEdge(bNode);
        while (edge != null) {
            bNode = edge.getOtherEndpoint(bNode);
            bList.add(bNode);
            edge = this.getParentEdge(bNode);
        }
        bList.add(null);
        int aIndex = aList.size() - 1;
        int bIndex = bList.size() - 1;
        while (--aIndex >= 0 && --bIndex >= 0) {
            if (GraphUtils.equals(aList.get(aIndex), bList.get(bIndex))) continue;
            return aList.get(aIndex + 1);
        }
        return aIndex < 0 ? aList.get(0) : bList.get(0);
    }

    public int getDepth(Object node) {
        int depth = 0;
        Graph.Edge edge = this.getParentEdge(node);
        while (edge != null) {
            node = edge.getOtherEndpoint(node);
            edge = this.getParentEdge(node);
            ++depth;
        }
        return depth;
    }

    public int getHeight(Object node) {
        int maxHeight = 0;
        int height = 0;
        DepthFirstTraverser t = new DepthFirstTraverser(node, this);
        while (t.hasNext()) {
            t.next();
            if (t.isDescending()) {
                if (maxHeight >= ++height) continue;
                maxHeight = height;
                continue;
            }
            --height;
        }
        return maxHeight;
    }
}

