/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.PruningTraverser;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.ChildTraverserFactory;
import com.phoenixst.plexus.util.DefaultTraverserFactory;
import com.phoenixst.plexus.util.SingletonTraverser;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public class BreadthFirstTraverser
implements PruningTraverser {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$BreadthFirstTraverser == null ? (class$com$phoenixst$plexus$BreadthFirstTraverser = BreadthFirstTraverser.class$("com.phoenixst.plexus.BreadthFirstTraverser")) : class$com$phoenixst$plexus$BreadthFirstTraverser));
    private Transformer traverserFactory;
    private LinkedList traverserQueue;
    private Traverser current;
    static /* synthetic */ Class class$com$phoenixst$plexus$BreadthFirstTraverser;

    public BreadthFirstTraverser(Object startNode, Graph graph, Predicate traverserPredicate) {
        this(startNode, graph, new DefaultTraverserFactory(graph, traverserPredicate));
    }

    public BreadthFirstTraverser(Object startNode, OrientedForestView forestView) {
        this(startNode, forestView.getGraph(), new ChildTraverserFactory(forestView));
    }

    public BreadthFirstTraverser(Object startNode, Transformer traverserFactory) {
        this(startNode, null, traverserFactory);
    }

    private BreadthFirstTraverser(Object startNode, Graph graph, Transformer traverserFactory) {
        this.traverserFactory = traverserFactory;
        if (traverserFactory == null) {
            throw new NullPointerException("Traverser Factory is null.");
        }
        if (graph == null) {
            traverserFactory.transform(startNode);
        } else if (!graph.containsNode(startNode)) {
            throw new NoSuchNodeException("Graph does not contain start node: " + startNode);
        }
        this.current = null;
        this.traverserQueue = new LinkedList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Constructor: Adding trivial Traverser to " + startNode + " to end of queue."));
        }
        this.traverserQueue.addLast(new SingletonTraverser(graph, startNode, null));
    }

    public boolean hasNext() {
        if (this.traverserQueue.isEmpty()) {
            return false;
        }
        if (this.traverserQueue.size() > 1) {
            return true;
        }
        LOGGER.debug((Object)"hasNext(): Calling hasNext() on last created Traverser.");
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        LOGGER.debug((Object)"  Calling hasNext() on first Traverser in queue.");
        return ((Traverser)this.traverserQueue.getFirst()).hasNext();
    }

    public Object next() {
        LOGGER.debug((Object)"next():");
        if (this.current != null && this.current.hasNext()) {
            LOGGER.debug((Object)"  Adding last created Traverser to end of queue.");
            this.traverserQueue.addLast(this.current);
        }
        this.current = null;
        while (!this.traverserQueue.isEmpty()) {
            Traverser t = (Traverser)this.traverserQueue.getFirst();
            LOGGER.debug((Object)"  Calling hasNext() on first Traverser in queue.");
            if (t.hasNext()) {
                Object node = t.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("  Creating new Traverser for " + node + "."));
                }
                this.current = (Traverser)this.traverserFactory.transform(node);
                return node;
            }
            LOGGER.debug((Object)"  Removing first Traverser in queue.");
            this.traverserQueue.removeFirst();
        }
        throw new NoSuchElementException();
    }

    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"remove(): Calling remove() on first Traverser in queue.");
        ((Traverser)this.traverserQueue.getFirst()).remove();
        this.current = null;
    }

    public Graph.Edge getEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"getEdge(): Calling getEdge() on first Traverser in queue.");
        return ((Traverser)this.traverserQueue.getFirst()).getEdge();
    }

    public void removeEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"removeEdge(): Calling removeEdge() on first Traverser in queue.");
        ((Traverser)this.traverserQueue.getFirst()).removeEdge();
        this.current = null;
    }

    public void prune() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"prune(): Setting last created Traverser to null.");
        this.current = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

