/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.AbstractOrientedForestView;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.Traverser;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.Predicate;

public class DefaultOrientedForestView
extends AbstractOrientedForestView
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Graph graph;
    private Predicate parentPredicate;
    private Predicate childPredicate;

    public DefaultOrientedForestView(Graph graph, Predicate parentPredicate, Predicate childPredicate) {
        this.graph = graph;
        this.parentPredicate = parentPredicate;
        this.childPredicate = childPredicate;
        if (graph == null) {
            throw new NullPointerException();
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Object getParent(Object node) {
        return this.graph.getAdjacentNode(node, this.parentPredicate);
    }

    public Graph.Edge getParentEdge(Object node) {
        return this.graph.getIncidentEdge(node, this.parentPredicate);
    }

    public Traverser childTraverser(Object node) {
        return this.graph.traverser(node, this.childPredicate);
    }

    public boolean isLeaf(Object node) {
        return this.graph.degree(node, this.childPredicate) == 0;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.graph == null) {
            throw new InvalidObjectException("Graph is null.");
        }
    }
}

