/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.EqualPredicate;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.EdgePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.Predicate;

public class EdgePredicateFactory {
    private EdgePredicateFactory() {
    }

    public static final EdgePredicate create(Graph.Edge edge) {
        int directionFlags = edge.isDirected() ? 2 : 1;
        return new EqualsUserNodesPredicate(edge.getUserObject(), edge.getTail(), edge.getHead(), directionFlags);
    }

    public static final EdgePredicate createEqualsNodes(Object firstNode, Object secondNode, int directionFlags) {
        return new EqualsNodesPredicate(firstNode, secondNode, directionFlags);
    }

    public static final EdgePredicate createEqualsUser(Object userObject, int directionFlags) {
        return new EqualsUserPredicate(userObject, directionFlags);
    }

    public static final EdgePredicate createEquals(Object userObject, Object firstNode, Object secondNode, int directionFlags) {
        return new EqualsUserNodesPredicate(userObject, firstNode, secondNode, directionFlags);
    }

    public static final EdgePredicate createPredicated(Predicate userObjectPredicate, Predicate firstNodePredicate, Predicate secondNodePredicate, int directionFlags) {
        return new PredicatedUserNodesPredicate(userObjectPredicate, firstNodePredicate, secondNodePredicate, directionFlags);
    }

    static Object escapePredicate(Object object) {
        return object instanceof Predicate ? new EqualPredicate(object) : object;
    }

    private static final class PredicatedUserNodesPredicate
    extends AbstractEdgePredicate {
        private static final long serialVersionUID = 1L;
        private final Predicate userObjectPredicate;
        private final Predicate firstNodePredicate;
        private final Predicate secondNodePredicate;

        PredicatedUserNodesPredicate(Predicate userObjectPredicate, Predicate firstNodePredicate, Predicate secondNodePredicate, int directionFlags) {
            super(directionFlags);
            this.userObjectPredicate = userObjectPredicate;
            this.firstNodePredicate = firstNodePredicate;
            this.secondNodePredicate = secondNodePredicate;
            if (userObjectPredicate == null) {
                throw new NullPointerException("User object Predicate is null.");
            }
            if (firstNodePredicate == null) {
                throw new NullPointerException("First node Predicate is null.");
            }
            if (secondNodePredicate == null) {
                throw new NullPointerException("Second node Predicate is null.");
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            if (this.userObjectPredicate == null) {
                throw new InvalidObjectException("User object Predicate is null.");
            }
            if (this.firstNodePredicate == null) {
                throw new InvalidObjectException("First node Predicate is null.");
            }
            if (this.secondNodePredicate == null) {
                throw new InvalidObjectException("Second node Predicate is null.");
            }
        }

        public Object getFirstNodeSpecification() {
            return this.firstNodePredicate;
        }

        public Object getSecondNodeSpecification() {
            return this.secondNodePredicate;
        }

        public Object getUserObjectSpecification() {
            return this.userObjectPredicate;
        }

        boolean evaluateUserObject(Object targetUserObject) {
            return this.userObjectPredicate.evaluate(targetUserObject);
        }

        boolean evaluateNodes(Object targetFirstNode, Object targetSecondNode) {
            return this.firstNodePredicate.evaluate(targetFirstNode) && this.secondNodePredicate.evaluate(targetSecondNode);
        }
    }

    private static final class EqualsUserNodesPredicate
    extends AbstractEdgePredicate {
        private static final long serialVersionUID = 1L;
        private final Object userObject;
        private final Object firstNode;
        private final Object secondNode;

        EqualsUserNodesPredicate(Object userObject, Object firstNode, Object secondNode, int directionFlags) {
            super(directionFlags);
            this.userObject = userObject;
            this.firstNode = firstNode;
            this.secondNode = secondNode;
        }

        public Object getUserObjectSpecification() {
            return EdgePredicateFactory.escapePredicate(this.userObject);
        }

        public Object getFirstNodeSpecification() {
            return EdgePredicateFactory.escapePredicate(this.firstNode);
        }

        public Object getSecondNodeSpecification() {
            return EdgePredicateFactory.escapePredicate(this.secondNode);
        }

        boolean evaluateUserObject(Object targetUserObject) {
            return GraphUtils.equals(this.userObject, targetUserObject);
        }

        boolean evaluateNodes(Object targetFirstNode, Object targetSecondNode) {
            return GraphUtils.equals(this.firstNode, targetFirstNode) && GraphUtils.equals(this.secondNode, targetSecondNode);
        }
    }

    private static final class EqualsUserPredicate
    extends AbstractEdgePredicate {
        private static final long serialVersionUID = 1L;
        private final Object userObject;

        EqualsUserPredicate(Object userObject, int directionFlags) {
            super(directionFlags);
            this.userObject = userObject;
        }

        public Object getUserObjectSpecification() {
            return EdgePredicateFactory.escapePredicate(this.userObject);
        }

        boolean evaluateUserObject(Object targetUserObject) {
            return GraphUtils.equals(this.userObject, targetUserObject);
        }

        boolean evaluateNodes(Object targetFirstNode, Object targetSecondNode) {
            return true;
        }
    }

    private static final class EqualsNodesPredicate
    extends AbstractEdgePredicate {
        private static final long serialVersionUID = 1L;
        private final Object firstNode;
        private final Object secondNode;

        EqualsNodesPredicate(Object firstNode, Object secondNode, int directionFlags) {
            super(directionFlags);
            this.firstNode = firstNode;
            this.secondNode = secondNode;
        }

        public Object getFirstNodeSpecification() {
            return EdgePredicateFactory.escapePredicate(this.firstNode);
        }

        public Object getSecondNodeSpecification() {
            return EdgePredicateFactory.escapePredicate(this.secondNode);
        }

        boolean evaluateUserObject(Object targetUserObject) {
            return true;
        }

        boolean evaluateNodes(Object targetFirstNode, Object targetSecondNode) {
            return GraphUtils.equals(this.firstNode, targetFirstNode) && GraphUtils.equals(this.secondNode, targetSecondNode);
        }
    }

    private static abstract class AbstractEdgePredicate
    implements EdgePredicate,
    Serializable {
        private static final long serialVersionUID = 1L;
        final int directionFlags;

        AbstractEdgePredicate(int directionFlags) {
            this.directionFlags = directionFlags & 7;
            if (this.directionFlags == 0) {
                throw new IllegalArgumentException("Direction flags are invalid: " + directionFlags);
            }
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            if ((this.directionFlags & 7) == 0) {
                throw new InvalidObjectException("No direction flags set: " + this.directionFlags);
            }
            if ((this.directionFlags & 7) != this.directionFlags) {
                throw new InvalidObjectException("Direction flags not valid: " + this.directionFlags);
            }
        }

        public Object getFirstNodeSpecification() {
            return TruePredicate.INSTANCE;
        }

        public Object getSecondNodeSpecification() {
            return TruePredicate.INSTANCE;
        }

        public Object getUserObjectSpecification() {
            return TruePredicate.INSTANCE;
        }

        public int getDirectionFlags() {
            return this.directionFlags;
        }

        abstract boolean evaluateUserObject(Object var1);

        abstract boolean evaluateNodes(Object var1, Object var2);

        public boolean evaluate(Object object) {
            Graph.Edge edge = (Graph.Edge)object;
            if (!this.evaluateUserObject(edge.getUserObject())) {
                return false;
            }
            Object tail = edge.getTail();
            Object head = edge.getHead();
            if (edge.isDirected()) {
                return (this.directionFlags & 2) != 0 && this.evaluateNodes(tail, head) || (this.directionFlags & 4) != 0 && this.evaluateNodes(head, tail);
            }
            if ((this.directionFlags & 1) == 0) {
                return false;
            }
            return this.evaluateNodes(tail, head) || this.evaluateNodes(head, tail);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!this.getClass().equals(object.getClass())) {
                return false;
            }
            EdgePredicate pred = (EdgePredicate)object;
            return this.getDirectionFlags() == pred.getDirectionFlags() && this.getUserObjectSpecification().equals(pred.getUserObjectSpecification()) && this.getFirstNodeSpecification().equals(pred.getFirstNodeSpecification()) && this.getSecondNodeSpecification().equals(pred.getSecondNodeSpecification());
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.getUserObjectSpecification().hashCode();
            result = 37 * result + this.getFirstNodeSpecification().hashCode();
            result = 37 * result + this.getSecondNodeSpecification().hashCode();
            result = 37 * result + this.getDirectionFlags();
            return result;
        }
    }
}

