/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.RootedTreeView;
import com.phoenixst.plexus.Traverser;

public class ForestTreeAdapter
implements RootedTreeView {
    private Object root;
    private OrientedForestView forestView;
    private boolean isStrict;

    public ForestTreeAdapter(Object root, OrientedForestView forestView, boolean isStrict) {
        this.root = root;
        this.forestView = forestView;
        this.isStrict = isStrict;
        forestView.getParentEdge(root);
    }

    public Graph getGraph() {
        return this.forestView.getGraph();
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.forestView.getParentEdge(root);
        this.root = root;
    }

    public Object getParent(Object node) {
        if (this.isStrict && !this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        if (GraphUtils.equals(this.root, node)) {
            return null;
        }
        return this.forestView.getParent(node);
    }

    public Traverser childTraverser(Object node) {
        if (this.isStrict && !this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return this.forestView.childTraverser(node);
    }

    public Graph.Edge getParentEdge(Object node) {
        if (this.isStrict && !this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        if (GraphUtils.equals(this.root, node)) {
            return null;
        }
        return this.forestView.getParentEdge(node);
    }

    public boolean isForestEdge(Graph.Edge edge) {
        return this.forestView.isForestEdge(edge) && this.isTreeNode(this.forestView.getParentEndpoint(edge));
    }

    public Object getParentEndpoint(Graph.Edge edge) {
        Object parent = this.forestView.getParentEndpoint(edge);
        if (!this.isTreeNode(parent)) {
            throw new IllegalArgumentException("Edge is not a tree edge: " + edge);
        }
        return parent;
    }

    public Object getRoot(Object node) {
        if (!this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return this.root;
    }

    public boolean isLeaf(Object node) {
        if (this.isStrict && !this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return this.forestView.isLeaf(node);
    }

    public boolean isAncestor(Object ancestor, Object descendant) {
        boolean isAncestor = this.forestView.isAncestor(ancestor, descendant);
        if (this.isStrict) {
            if (!this.isTreeNode(ancestor)) {
                throw new NoSuchNodeException("Node is not in this tree: " + ancestor);
            }
            if (!isAncestor && !this.isTreeNode(descendant)) {
                throw new NoSuchNodeException("Node is not in this tree: " + descendant);
            }
        }
        return isAncestor;
    }

    public Object getLeastCommonAncestor(Object aNode, Object bNode) {
        Object ancestor = this.forestView.getLeastCommonAncestor(aNode, bNode);
        if (this.isStrict) {
            if (ancestor != null) {
                if (!this.isTreeNode(ancestor)) {
                    throw new NoSuchNodeException("Node is not in this tree: " + ancestor);
                }
            } else {
                if (!this.isTreeNode(aNode)) {
                    throw new NoSuchNodeException("Node is not in this tree: " + aNode);
                }
                if (!this.isTreeNode(bNode)) {
                    throw new NoSuchNodeException("Node is not in this tree: " + bNode);
                }
            }
        }
        return ancestor;
    }

    public int getDepth(Object node) {
        if (GraphUtils.equals(this.root, node)) {
            return 0;
        }
        Object testNode = node;
        Graph.Edge edge = this.forestView.getParentEdge(testNode);
        int depth = 0;
        while (edge != null) {
            if (GraphUtils.equals(this.root, testNode)) {
                return depth;
            }
            testNode = edge.getOtherEndpoint(testNode);
            edge = this.forestView.getParentEdge(testNode);
            ++depth;
        }
        throw new NoSuchNodeException("Node is not in this tree: " + node);
    }

    public int getHeight(Object node) {
        if (this.isStrict && !this.isTreeNode(node)) {
            throw new NoSuchNodeException("Node is not in this tree: " + node);
        }
        return this.forestView.getHeight(node);
    }

    public boolean isTreeNode(Object node) {
        return this.forestView.isAncestor(this.root, node);
    }
}

