/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.LoggingCollection;
import com.phoenixst.collections.LoggingSupport;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphEvent;
import com.phoenixst.plexus.GraphListener;
import com.phoenixst.plexus.ObservableGraph;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.LoggingTraverser;
import com.phoenixst.plexus.util.ObservableGraphDelegate;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggingGraph
extends LoggingSupport
implements ObservableGraph {
    private static final Logger DEFAULT_LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$LoggingGraph == null ? (class$com$phoenixst$plexus$LoggingGraph = LoggingGraph.class$("com.phoenixst.plexus.LoggingGraph")) : class$com$phoenixst$plexus$LoggingGraph));
    private final Graph delegate;
    transient ObservableGraphDelegate observableDelegate;
    private transient GraphListener delegateListener;
    static /* synthetic */ Class class$com$phoenixst$plexus$LoggingGraph;

    public LoggingGraph(Graph delegate) {
        this(delegate, DEFAULT_LOGGER, Level.DEBUG);
    }

    public LoggingGraph(Graph delegate, Logger logger) {
        this(delegate, logger, Level.DEBUG);
    }

    public LoggingGraph(Graph delegate, Logger logger, Level level) {
        super(logger, level);
        this.delegate = delegate;
        if (delegate == null) {
            throw new NullPointerException();
        }
    }

    protected final Graph getDelegate() {
        return this.delegate;
    }

    public boolean addNode(Object node) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(node);
            this.log("Begin addNode( " + argString + " )");
            boolean modified = this.delegate.addNode(node);
            this.log("End addNode( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.addNode(node);
    }

    public boolean removeNode(Object node) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(node);
            this.log("Begin removeNode( " + argString + " )");
            boolean modified = this.delegate.removeNode(node);
            this.log("End removeNode( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.removeNode(node);
    }

    public boolean containsNode(Object node) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(node);
            this.log("Begin containsNode( " + argString + " )");
            boolean contains = this.delegate.containsNode(node);
            this.log("End containsNode( " + argString + " ), returns " + contains);
            return contains;
        }
        return this.delegate.containsNode(node);
    }

    public Graph.Edge addEdge(Object object, Object tail, Object head, boolean isDirected) {
        if (this.isLoggerEnabled()) {
            String argString = object + ", " + tail + ", " + head + ", " + isDirected;
            this.log("Begin addEdge( " + argString + " )");
            Graph.Edge edge = this.delegate.addEdge(object, tail, head, isDirected);
            this.log("End addEdge( " + argString + " ), returns " + edge);
            return edge;
        }
        return this.delegate.addEdge(object, tail, head, isDirected);
    }

    public boolean removeEdge(Graph.Edge edge) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(edge);
            this.log("Begin removeEdge( " + argString + " )");
            boolean modified = this.delegate.removeEdge(edge);
            this.log("End removeEdge( " + argString + " ), returns " + modified);
            return modified;
        }
        return this.delegate.removeEdge(edge);
    }

    public boolean containsEdge(Graph.Edge edge) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(edge);
            this.log("Begin containsEdge( " + argString + " )");
            boolean contains = this.delegate.containsEdge(edge);
            this.log("End containsEdge( " + argString + " ), returns " + contains);
            return contains;
        }
        return this.delegate.containsEdge(edge);
    }

    public int degree(Object node) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(node);
            this.log("Begin degree( " + argString + " )");
            int degree = this.delegate.degree(node);
            this.log("End degree( " + argString + " ), returns " + degree);
            return degree;
        }
        return this.delegate.degree(node);
    }

    public int degree(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin degree( " + argString + " )");
            int degree = this.delegate.degree(node, traverserPredicate);
            this.log("End degree( " + argString + " ), returns " + degree);
            return degree;
        }
        return this.delegate.degree(node, traverserPredicate);
    }

    public Collection nodes(Predicate nodePredicate) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(nodePredicate);
            this.log("Begin nodes( " + argString + " )");
            Collection nodes = this.delegate.nodes(nodePredicate);
            this.log("End nodes( " + argString + " ), returns " + nodes);
            return new LoggingCollection(nodes, this.getLogger(), this.getLevel());
        }
        return new LoggingCollection(this.delegate.nodes(nodePredicate), this.getLogger(), this.getLevel());
    }

    public Collection edges(Predicate edgePredicate) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(edgePredicate);
            this.log("Begin edges( " + argString + " )");
            Collection edges = this.delegate.edges(edgePredicate);
            this.log("End edges( " + argString + " ), returns " + edges);
            return new LoggingCollection(edges, this.getLogger(), this.getLevel());
        }
        return new LoggingCollection(this.delegate.edges(edgePredicate), this.getLogger(), this.getLevel());
    }

    public Collection adjacentNodes(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin adjacentNodes( " + argString + " )");
            Collection adjNodes = this.delegate.adjacentNodes(node, traverserPredicate);
            this.log("End adjacentNodes( " + argString + " ), returns " + adjNodes);
            return new LoggingCollection(adjNodes, this.getLogger(), this.getLevel());
        }
        return new LoggingCollection(this.delegate.adjacentNodes(node, traverserPredicate), this.getLogger(), this.getLevel());
    }

    public Collection incidentEdges(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin incidentEdges( " + argString + " )");
            Collection incEdges = this.delegate.incidentEdges(node, traverserPredicate);
            this.log("End incidentEdges( " + argString + " ), returns " + incEdges);
            return new LoggingCollection(incEdges, this.getLogger(), this.getLevel());
        }
        return new LoggingCollection(this.delegate.incidentEdges(node, traverserPredicate), this.getLogger(), this.getLevel());
    }

    public Object getNode(Predicate nodePredicate) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(nodePredicate);
            this.log("Begin getNode( " + argString + " )");
            Object node = this.delegate.getNode(nodePredicate);
            this.log("End getNode( " + argString + " ), returns " + node);
            return node;
        }
        return this.delegate.getNode(nodePredicate);
    }

    public Graph.Edge getEdge(Predicate edgePredicate) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(edgePredicate);
            this.log("Begin getEdge( " + argString + " )");
            Graph.Edge edge = this.delegate.getEdge(edgePredicate);
            this.log("End getEdge( " + argString + " ), returns " + edge);
            return edge;
        }
        return this.delegate.getEdge(edgePredicate);
    }

    public Object getAdjacentNode(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin getAdjacentNode( " + argString + " )");
            Object adjNode = this.delegate.getAdjacentNode(node, traverserPredicate);
            this.log("End getAdjacentNode( " + argString + " ), returns " + adjNode);
            return adjNode;
        }
        return this.delegate.getAdjacentNode(node, traverserPredicate);
    }

    public Graph.Edge getIncidentEdge(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin getIncidentEdge( " + argString + " )");
            Graph.Edge incEdge = this.delegate.getIncidentEdge(node, traverserPredicate);
            this.log("End getIncidentEdge( " + argString + " ), returns " + incEdge);
            return incEdge;
        }
        return this.delegate.getIncidentEdge(node, traverserPredicate);
    }

    public Traverser traverser(Object node, Predicate traverserPredicate) {
        if (this.isLoggerEnabled()) {
            String argString = node + ", " + traverserPredicate;
            this.log("Begin traverser( " + argString + " )");
            Traverser traverser = this.delegate.traverser(node, traverserPredicate);
            this.log("End traverser( " + argString + " ), returns " + traverser);
            return new LoggingTraverser(traverser, this.getLogger(), this.getLevel());
        }
        return new LoggingTraverser(this.delegate.traverser(node, traverserPredicate), this.getLogger(), this.getLevel());
    }

    public void addGraphListener(GraphListener listener) {
        if (this.isLoggerEnabled()) {
            this.log("Begin addGraphListener( " + listener + " )");
        }
        if (!(this.delegate instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate == null) {
            this.observableDelegate = new ObservableGraphDelegate(this, this.getLogger(), this.getLevel());
            this.delegateListener = new DelegateListener();
            ((ObservableGraph)this.delegate).addGraphListener(this.delegateListener);
        }
        this.observableDelegate.addGraphListener(listener);
        if (this.isLoggerEnabled()) {
            this.log("End addGraphListener( " + listener + " )");
        }
    }

    public void removeGraphListener(GraphListener listener) {
        if (this.isLoggerEnabled()) {
            this.log("Begin removeGraphListener( " + listener + " )");
        }
        if (!(this.delegate instanceof ObservableGraph)) {
            throw new UnsupportedOperationException("Wrapped graph is not observable.");
        }
        if (this.observableDelegate != null && this.observableDelegate.removeGraphListener(listener)) {
            ((ObservableGraph)this.delegate).removeGraphListener(this.delegateListener);
            this.delegateListener = null;
            this.observableDelegate = null;
        }
        if (this.isLoggerEnabled()) {
            this.log("End removeGraphListener( " + listener + " )");
        }
    }

    public boolean equals(Object object) {
        if (this.isLoggerEnabled()) {
            String argString = String.valueOf(object);
            this.log("Begin equals( " + argString + " )");
            boolean equals = this.delegate.equals(object);
            this.log("End equals( " + argString + " ), returns " + equals);
            return equals;
        }
        return this.delegate.equals(object);
    }

    public int hashCode() {
        if (this.isLoggerEnabled()) {
            this.log("Begin hashCode()");
            int hashCode = this.delegate.hashCode();
            this.log("End hashCode(), returns " + hashCode);
            return hashCode;
        }
        return this.delegate.hashCode();
    }

    public String toString() {
        if (this.isLoggerEnabled()) {
            this.log("Begin toString()");
            String string = this.delegate.toString();
            this.log("End toString(), returns " + string);
            return string;
        }
        return this.delegate.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class DelegateListener
    implements GraphListener {
        protected DelegateListener() {
        }

        public void nodeAdded(GraphEvent event) {
            LoggingGraph.this.observableDelegate.fireNodeAdded(event.getObject());
        }

        public void nodeRemoved(GraphEvent event) {
            LoggingGraph.this.observableDelegate.fireNodeRemoved(event.getObject());
        }

        public void edgeAdded(GraphEvent event) {
            LoggingGraph.this.observableDelegate.fireEdgeAdded((Graph.Edge)event.getObject());
        }

        public void edgeRemoved(GraphEvent event) {
            LoggingGraph.this.observableDelegate.fireEdgeRemoved((Graph.Edge)event.getObject());
        }
    }
}

