/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.collections.SimpleStack;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.PruningTraverser;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.ChildTraverserFactory;
import com.phoenixst.plexus.util.DefaultTraverserFactory;
import com.phoenixst.plexus.util.SingletonTraverser;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;

public class PreOrderTraverser
implements PruningTraverser {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$PreOrderTraverser == null ? (class$com$phoenixst$plexus$PreOrderTraverser = PreOrderTraverser.class$("com.phoenixst.plexus.PreOrderTraverser")) : class$com$phoenixst$plexus$PreOrderTraverser));
    private Transformer traverserFactory;
    private SimpleStack traverserStack;
    private Traverser current;
    static /* synthetic */ Class class$com$phoenixst$plexus$PreOrderTraverser;

    public PreOrderTraverser(Object startNode, Graph graph, Predicate traverserPredicate) {
        this(startNode, graph, new DefaultTraverserFactory(graph, traverserPredicate));
    }

    public PreOrderTraverser(Object startNode, OrientedForestView forestView) {
        this(startNode, forestView.getGraph(), new ChildTraverserFactory(forestView));
    }

    public PreOrderTraverser(Object startNode, Transformer traverserFactory) {
        this(startNode, null, traverserFactory);
    }

    private PreOrderTraverser(Object startNode, Graph graph, Transformer traverserFactory) {
        this.traverserFactory = traverserFactory;
        if (traverserFactory == null) {
            throw new NullPointerException("Traverser Factory is null.");
        }
        if (graph == null) {
            traverserFactory.transform(startNode);
        } else if (!graph.containsNode(startNode)) {
            throw new NoSuchNodeException("Graph does not contain start node: " + startNode);
        }
        this.current = null;
        this.traverserStack = new SimpleStack();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Consturctor: Pushing trivial Traverser to " + startNode + " onto stack."));
        }
        this.traverserStack.push(new SingletonTraverser(graph, startNode, null));
    }

    public boolean hasNext() {
        LOGGER.debug((Object)"hasNext(): Calling hasNext() on current Traverser.");
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        LOGGER.debug((Object)"  Calling hasNext() on Traversers in stack.");
        int size = this.traverserStack.size();
        for (int i = 0; i < size; ++i) {
            if (!((Traverser)this.traverserStack.get(i)).hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        LOGGER.debug((Object)"next():");
        while (!this.traverserStack.isEmpty()) {
            Traverser t = (Traverser)this.traverserStack.peek();
            LOGGER.debug((Object)"  Calling hasNext() on top Traverser of stack.");
            if (t.hasNext()) {
                this.current = t;
                Object node = this.current.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"  Setting current Traverser to top of stack.");
                    LOGGER.debug((Object)("  Pushing new Traverser for " + node + " onto stack."));
                }
                this.traverserStack.push(this.traverserFactory.transform(node));
                return node;
            }
            LOGGER.debug((Object)"  Popping top Traverser off of stack.");
            this.traverserStack.pop();
        }
        this.current = null;
        throw new NoSuchElementException();
    }

    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"remove(): Calling remove() on current Traverser.");
        this.current.remove();
        LOGGER.debug((Object)"  Setting current Traverser to null and popping top Traverser off of stack.");
        this.current = null;
        this.traverserStack.pop();
    }

    public Graph.Edge getEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"getEdge(): Calling getEdge() on current Traverser.");
        return this.current.getEdge();
    }

    public void removeEdge() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"removeEdge(): Calling removeEdge() on current Traverser.");
        this.current.removeEdge();
        LOGGER.debug((Object)"  Setting current Traverser to null and popping top Traverser off of stack.");
        this.current = null;
        this.traverserStack.pop();
    }

    public void prune() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        LOGGER.debug((Object)"prune(): Setting current Traverser to null and popping top Traverser off of stack.");
        this.current = null;
        this.traverserStack.pop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

