/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.NoSuchNodeException;
import com.phoenixst.plexus.OrientedForestView;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.DefaultIncidentEdgeGetter;
import com.phoenixst.plexus.util.ParentEdgeGetter;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class Walker
implements Traverser {
    private static final int STATE_INIT = 0;
    private static final int STATE_FIRST_NODE = 1;
    private static final int STATE_OTHER = 2;
    private Object startNode;
    private Graph graph;
    private Transformer incidentEdgeGetter;
    private Object currentNode;
    private Graph.Edge currentEdge;
    private Graph.Edge nextEdge;
    private int state;

    public Walker(Object startNode, Graph graph, Predicate traverserPredicate) {
        this(startNode, graph, new DefaultIncidentEdgeGetter(graph, traverserPredicate));
    }

    public Walker(Object startNode, OrientedForestView forestView) {
        this(startNode, forestView.getGraph(), new ParentEdgeGetter(forestView));
    }

    public Walker(Object startNode, Transformer incidentEdgeGetter) {
        this(startNode, null, incidentEdgeGetter);
    }

    private Walker(Object startNode, Graph graph, Transformer incidentEdgeGetter) {
        this.startNode = startNode;
        this.graph = graph;
        this.incidentEdgeGetter = incidentEdgeGetter;
        if (incidentEdgeGetter == null) {
            throw new NullPointerException("Incident Edge Getter is null.");
        }
        if (graph == null) {
            incidentEdgeGetter.transform(startNode);
        } else if (!graph.containsNode(startNode)) {
            throw new NoSuchNodeException("Graph does not contain start node: " + startNode);
        }
        this.state = 0;
        this.currentNode = null;
        this.currentEdge = null;
        this.nextEdge = null;
    }

    public boolean hasNext() {
        return this.state == 0 || this.nextEdge != null;
    }

    public Object next() {
        if (this.state == 0) {
            this.state = 1;
            this.currentNode = this.startNode;
        } else {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            this.state = 2;
            this.currentNode = this.nextEdge.getOtherEndpoint(this.currentNode);
        }
        this.currentEdge = this.nextEdge;
        this.nextEdge = (Graph.Edge)this.incidentEdgeGetter.transform(this.currentNode);
        return this.currentNode;
    }

    public void remove() {
        if (this.state == 0) {
            throw new IllegalStateException();
        }
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (this.state == 2 && this.currentEdge == null) {
            throw new IllegalStateException();
        }
        this.graph.removeNode(this.currentNode);
        this.state = 2;
        this.currentEdge = null;
        this.nextEdge = null;
    }

    public Graph.Edge getEdge() {
        if (this.state == 0 || this.state == 2 && this.currentEdge == null) {
            throw new IllegalStateException();
        }
        return this.currentEdge;
    }

    public void removeEdge() {
        if (this.currentEdge == null) {
            throw new IllegalStateException();
        }
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        this.graph.removeEdge(this.currentEdge);
        this.currentEdge = null;
    }
}

