/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.Traverser;
import com.phoenixst.plexus.util.TraverserAdjacentNodeIteratorAdapter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;

public class AdjacentNodeCollection
extends AbstractCollection {
    protected Graph graph;
    protected Object baseNode;
    protected Predicate traverserPredicate;

    public AdjacentNodeCollection(Graph graph, Object baseNode, Predicate traverserPredicate) {
        this.graph = graph;
        this.baseNode = baseNode;
        Object object = this.traverserPredicate = traverserPredicate != null ? traverserPredicate : TruePredicate.INSTANCE;
        if (!graph.containsNode(baseNode)) {
            throw new IllegalArgumentException("Graph does not contain base node: " + baseNode);
        }
    }

    public int size() {
        return this.graph.degree(this.baseNode, this.traverserPredicate);
    }

    public boolean remove(Object object) {
        Traverser t = this.graph.traverser(this.baseNode, this.traverserPredicate);
        while (t.hasNext()) {
            if (!GraphUtils.equals(object, t.next())) continue;
            t.removeEdge();
            return true;
        }
        return false;
    }

    public boolean contains(Object object) {
        Traverser i = this.graph.traverser(this.baseNode, this.traverserPredicate);
        while (i.hasNext()) {
            if (!GraphUtils.equals(object, i.next())) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new TraverserAdjacentNodeIteratorAdapter(this.graph.traverser(this.baseNode, this.traverserPredicate));
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }
}

