/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.plexus.Graph;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class DefaultTraverserFactory
implements Transformer,
Serializable {
    private static final long serialVersionUID = 1L;
    private Graph graph;
    private Predicate traverserPredicate;

    public DefaultTraverserFactory(Graph graph, Predicate traverserPredicate) {
        this.graph = graph;
        this.traverserPredicate = traverserPredicate;
        if (graph == null) {
            throw new NullPointerException("Graph is null.");
        }
        if (traverserPredicate == null) {
            throw new NullPointerException("Traverser predicate is null.");
        }
    }

    public Object transform(Object node) {
        return this.graph.traverser(node, this.traverserPredicate);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Predicate getTraverserPredicate() {
        return this.traverserPredicate;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.graph == null) {
            throw new InvalidObjectException("Graph is null.");
        }
        if (this.traverserPredicate == null) {
            throw new InvalidObjectException("Traverser predicate is null.");
        }
    }
}

