/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.Traverser;
import java.util.Iterator;

public class EdgeIteratorTraverserAdapter
implements Traverser {
    private Graph graph;
    private Object baseNode;
    private Iterator edgeIter;
    private Object currentNode;
    private Graph.Edge currentEdge;
    private boolean isCurrentNodeValid;

    public EdgeIteratorTraverserAdapter(Object baseNode, Iterator edgeIter) {
        this(null, baseNode, edgeIter);
    }

    public EdgeIteratorTraverserAdapter(Graph graph, Object baseNode, Iterator edgeIter) {
        this.graph = graph;
        this.baseNode = baseNode;
        this.edgeIter = edgeIter;
        this.currentNode = null;
        this.currentEdge = null;
        this.isCurrentNodeValid = false;
    }

    public boolean hasNext() {
        return this.edgeIter.hasNext();
    }

    public Object next() {
        this.currentEdge = (Graph.Edge)this.edgeIter.next();
        this.currentNode = this.currentEdge.getOtherEndpoint(this.baseNode);
        this.isCurrentNodeValid = true;
        return this.currentNode;
    }

    public void remove() {
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (!this.isCurrentNodeValid) {
            throw new IllegalStateException();
        }
        this.graph.removeNode(this.currentNode);
        this.currentEdge = null;
        this.isCurrentNodeValid = false;
    }

    public Graph.Edge getEdge() {
        if (this.currentEdge == null) {
            throw new IllegalStateException();
        }
        return this.currentEdge;
    }

    public void removeEdge() {
        if (this.graph == null) {
            throw new UnsupportedOperationException();
        }
        if (this.currentEdge == null) {
            throw new IllegalStateException();
        }
        this.graph.removeEdge(this.currentEdge);
        this.currentEdge = null;
    }
}

