/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.collections.OrderedPair;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.Traverser;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;

public class FilteredTraverser
implements Traverser {
    private Graph graph;
    private Traverser traverser;
    private Predicate traverserPredicate;
    private Object currentNode;
    private Object nextNode;
    private Graph.Edge currentEdge;
    private Graph.Edge nextEdge;
    private boolean isCurrentValid;
    private boolean isNextValid;
    private OrderedPair pair;

    public FilteredTraverser(Traverser traverser, Predicate traverserPredicate) {
        this(null, traverser, traverserPredicate);
    }

    public FilteredTraverser(Graph graph, Traverser traverser, Predicate traverserPredicate) {
        this.graph = graph;
        this.traverser = traverser;
        this.traverserPredicate = traverserPredicate;
        this.currentNode = null;
        this.nextNode = null;
        this.currentEdge = null;
        this.nextEdge = null;
        this.isCurrentValid = false;
        this.isNextValid = false;
        this.pair = new OrderedPair(null, null);
    }

    public boolean hasNext() {
        if (!this.isNextValid) {
            while (this.traverser.hasNext()) {
                Object node = this.traverser.next();
                Graph.Edge edge = this.traverser.getEdge();
                this.pair.set(0, edge.getOtherEndpoint(node));
                this.pair.set(1, edge);
                if (!this.traverserPredicate.evaluate((Object)this.pair)) continue;
                this.nextNode = node;
                this.nextEdge = edge;
                this.isNextValid = true;
                break;
            }
        }
        return this.isNextValid;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentNode = this.nextNode;
        this.currentEdge = this.nextEdge;
        this.isCurrentValid = true;
        this.isNextValid = false;
        return this.currentNode;
    }

    public void remove() {
        if (!this.isCurrentValid) {
            throw new IllegalStateException();
        }
        if (!this.isNextValid) {
            this.traverser.remove();
        } else {
            if (this.graph == null) {
                throw new IllegalStateException("The remove() method cannot be called after hasNext() without an intervening call to next().");
            }
            this.graph.removeNode(this.currentNode);
        }
        this.isCurrentValid = false;
    }

    public Graph.Edge getEdge() {
        if (!this.isCurrentValid) {
            throw new IllegalStateException();
        }
        return this.currentEdge;
    }

    public void removeEdge() {
        if (!this.isCurrentValid) {
            throw new IllegalStateException();
        }
        if (!this.isNextValid) {
            this.traverser.removeEdge();
        } else {
            if (this.graph == null) {
                throw new IllegalStateException("The removeEdge() method cannot be called after hasNext() without an intervening call to next().");
            }
            this.graph.removeEdge(this.currentEdge);
        }
        this.isCurrentValid = false;
    }
}

