/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.collections.OrderedPair;
import com.phoenixst.collections.TruePredicate;
import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphUtils;
import com.phoenixst.plexus.util.TraverserEdgeIteratorAdapter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;

public class IncidentEdgeCollection
extends AbstractCollection {
    protected Graph graph;
    protected Object baseNode;
    protected Predicate traverserPredicate;
    protected OrderedPair pair;

    public IncidentEdgeCollection(Graph graph, Object baseNode, Predicate traverserPredicate) {
        this.graph = graph;
        this.baseNode = baseNode;
        Object object = this.traverserPredicate = traverserPredicate != null ? traverserPredicate : TruePredicate.INSTANCE;
        if (!graph.containsNode(baseNode)) {
            throw new IllegalArgumentException("Graph does not contain base node: " + baseNode);
        }
        this.pair = new OrderedPair(baseNode, null);
    }

    public int size() {
        return this.graph.degree(this.baseNode, this.traverserPredicate);
    }

    public boolean remove(Object object) {
        if (!(object instanceof Graph.Edge)) {
            return false;
        }
        Graph.Edge edge = (Graph.Edge)object;
        this.pair.set(1, edge);
        return (GraphUtils.equals(this.baseNode, edge.getTail()) || GraphUtils.equals(this.baseNode, edge.getHead())) && this.traverserPredicate.evaluate((Object)this.pair) && this.graph.removeEdge(edge);
    }

    public boolean contains(Object object) {
        if (!(object instanceof Graph.Edge)) {
            return false;
        }
        Graph.Edge edge = (Graph.Edge)object;
        this.pair.set(1, edge);
        return (GraphUtils.equals(this.baseNode, edge.getTail()) || GraphUtils.equals(this.baseNode, edge.getHead())) && this.traverserPredicate.evaluate((Object)this.pair) && this.graph.containsEdge(edge);
    }

    public Iterator iterator() {
        return new TraverserEdgeIteratorAdapter(this.graph.traverser(this.baseNode, this.traverserPredicate));
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }
}

