/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixst.plexus.util;

import com.phoenixst.plexus.Graph;
import com.phoenixst.plexus.GraphEvent;
import com.phoenixst.plexus.GraphListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ObservableGraphDelegate {
    private static final Logger DEFAULT_LOGGER = Logger.getLogger((Class)(class$com$phoenixst$plexus$util$ObservableGraphDelegate == null ? (class$com$phoenixst$plexus$util$ObservableGraphDelegate = ObservableGraphDelegate.class$("com.phoenixst.plexus.util.ObservableGraphDelegate")) : class$com$phoenixst$plexus$util$ObservableGraphDelegate));
    private Graph graph;
    private Logger logger;
    private final Level level;
    private List listeners;
    private GraphListener[] listenerArray;
    static /* synthetic */ Class class$com$phoenixst$plexus$util$ObservableGraphDelegate;

    public ObservableGraphDelegate(Graph graph) {
        this(graph, DEFAULT_LOGGER, Level.DEBUG);
    }

    public ObservableGraphDelegate(Graph graph, Logger logger) {
        this(graph, logger, Level.DEBUG);
    }

    public ObservableGraphDelegate(Graph graph, Logger logger, Level level) {
        this.graph = graph;
        this.logger = logger;
        this.level = level;
        if (graph == null) {
            throw new NullPointerException();
        }
        if (logger == null) {
            throw new NullPointerException();
        }
        if (level == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void addGraphListener(GraphListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
        this.listenerArray = null;
    }

    public synchronized boolean removeGraphListener(GraphListener listener) {
        if (this.listeners == null) {
            return true;
        }
        this.listeners.remove(listener);
        this.listenerArray = null;
        return this.listeners.isEmpty();
    }

    public synchronized GraphListener[] getGraphListeners() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return new GraphListener[0];
        }
        if (this.listenerArray == null) {
            GraphListener[] array = new GraphListener[this.listeners.size()];
            return this.listeners.toArray(array);
        }
        GraphListener[] array = new GraphListener[this.listenerArray.length];
        System.arraycopy(this.listenerArray, 0, array, 0, this.listenerArray.length);
        return array;
    }

    public synchronized void removeAllGraphListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
            this.listenerArray = null;
        }
    }

    private GraphListener[] createListenerArray() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return null;
        }
        if (this.listenerArray == null) {
            this.listenerArray = new GraphListener[this.listeners.size()];
            this.listenerArray = this.listeners.toArray(this.listenerArray);
        }
        return this.listenerArray;
    }

    public void fireNodeAdded(Object node) {
        GraphListener[] array;
        if (this.logger.isEnabledFor((Priority)this.level)) {
            this.logger.log((Priority)this.level, (Object)("Firing node added: " + node));
        }
        if ((array = this.createListenerArray()) != null) {
            GraphEvent event = new GraphEvent(this.graph, node);
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].nodeAdded(event);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception thrown by GraphListener adding node: " + node), (Throwable)e);
                }
            }
        }
    }

    public void fireNodeRemoved(Object node) {
        GraphListener[] array;
        if (this.logger.isEnabledFor((Priority)this.level)) {
            this.logger.log((Priority)this.level, (Object)("Firing node removed: " + node));
        }
        if ((array = this.createListenerArray()) != null) {
            GraphEvent event = new GraphEvent(this.graph, node);
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].nodeRemoved(event);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception thrown by GraphListener removing node: " + node), (Throwable)e);
                }
            }
        }
    }

    public void fireEdgeAdded(Graph.Edge edge) {
        GraphListener[] array;
        if (this.logger.isEnabledFor((Priority)this.level)) {
            this.logger.log((Priority)this.level, (Object)("Firing edge added: " + edge));
        }
        if ((array = this.createListenerArray()) != null) {
            GraphEvent event = new GraphEvent(this.graph, edge);
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].edgeAdded(event);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception thrown by GraphListener adding edge: " + edge), (Throwable)e);
                }
            }
        }
    }

    public void fireEdgeRemoved(Graph.Edge edge) {
        GraphListener[] array;
        if (this.logger.isEnabledFor((Priority)this.level)) {
            this.logger.log((Priority)this.level, (Object)("Firing edge removed: " + edge));
        }
        if ((array = this.createListenerArray()) != null) {
            GraphEvent event = new GraphEvent(this.graph, edge);
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].edgeRemoved(event);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception thrown by GraphListener removing edge: " + edge), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

